/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.frontend.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiriusServerFrontendFilter
implements Filter {
    private static final String HTTP_API_PATH = "/api";
    private static final String WS_API_PATH = "/ws";
    private static final String IMAGES_PATH = "/images";
    private static final String WORKFLOW_PATH = "/workflow";
    private static final String STATIC_PATH = "/static";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String requestURI = httpServletRequest.getRequestURI();
            if (this.isStaticResource(requestURI)) {
                this.handleStaticResource(httpServletRequest, httpServletResponse, chain);
            } else if (this.isFrontEnd(requestURI)) {
                this.redirectToFrontEnd(httpServletRequest, httpServletResponse);
            }
        }
    }

    private boolean isStaticResource(String requestURI) {
        return requestURI.startsWith(STATIC_PATH);
    }

    private boolean isFrontEnd(String requestURI) {
        boolean isFrontEnd = true;
        isFrontEnd = isFrontEnd && !requestURI.startsWith(HTTP_API_PATH);
        isFrontEnd = isFrontEnd && !requestURI.startsWith(WS_API_PATH);
        isFrontEnd = isFrontEnd && !requestURI.startsWith(IMAGES_PATH);
        isFrontEnd = isFrontEnd && !requestURI.startsWith(WORKFLOW_PATH);
        isFrontEnd = isFrontEnd && !requestURI.startsWith(STATIC_PATH);
        return isFrontEnd;
    }

    private void handleStaticResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private void redirectToFrontEnd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.getRequestDispatcher("/").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }
}

