/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.user;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public final class UserProjectField {
    private static final String PROJECT_FIELD = "project";
    private static final String PROJECT_NAME_ARG = "name";

    private UserProjectField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(PROJECT_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("Project")).argument(UserProjectField.getProjectFieldNameArg()).dataFetcher(UserProjectField.getProjectDataFetcher()).build();
    }

    private static GraphQLArgument getProjectFieldNameArg() {
        return GraphQLArgument.newArgument().name(PROJECT_NAME_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static DataFetcher<IProject> getProjectDataFetcher() {
        return environment -> {
            Optional<String> optionalProjectName = Optional.of(environment.getArgument(PROJECT_NAME_ARG)).filter(String.class::isInstance).map(String.class::cast);
            Optional<IProject> optionalProject = optionalProjectName.map(arg_0 -> ((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getProject(arg_0));
            return optionalProject.orElse(null);
        };
    }
}

