/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.pages;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.api.SiriusServerPath;
import org.eclipse.sirius.server.api.SiriusServerResponse;
import org.eclipse.sirius.server.backend.internal.services.pages.SiriusServerActivityDto;
import org.eclipse.sirius.server.backend.internal.services.pages.SiriusServerPageDto;
import org.eclipse.sirius.server.backend.internal.services.pages.SiriusServerSectionDto;
import org.eclipse.sirius.server.backend.internal.services.workflow.WorkflowHelper;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerUtils;

@SiriusServerPath(value="/projects/{projectName}/pages/{pageIdentifier}")
public class SiriusServerPageService
implements ISiriusServerService {
    private static final Object PROJECT_NAME = "projectName";
    private static final Object PAGE_IDENTIFIER = "pageIdentifier";

    public SiriusServerResponse doGet(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        String projectName = variables.get(PROJECT_NAME);
        String pageIdentifier = variables.get(PAGE_IDENTIFIER);
        Optional<IProject> optionalProject = Optional.ofNullable(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
        Optional<ModelingProject> optionalModelingProject = optionalProject.filter(ModelingProject::hasModelingProjectNature).filter(IProject::isOpen).map(iProject -> (ModelingProject)ModelingProject.asModelingProject((IProject)iProject).get());
        Optional optionalPage = optionalModelingProject.flatMap(modelingProject -> this.getPage((ModelingProject)modelingProject, pageIdentifier));
        if (optionalPage.isPresent()) {
            SiriusServerPageDto page = (SiriusServerPageDto)optionalPage.get();
            return new SiriusServerResponse(200, (Object)page);
        }
        return new SiriusServerResponse(404);
    }

    private Optional<SiriusServerPageDto> getPage(ModelingProject modelingProject, String pageIdentifier) {
        Session session = SiriusServerUtils.getSession(modelingProject);
        return WorkflowHelper.on(session).findPageById(pageIdentifier).map(page -> {
            List<SiriusServerSectionDto> sections = page.getSections().stream().map(section -> {
                List<SiriusServerActivityDto> activities = section.getActivities().stream().map(desc -> new SiriusServerActivityDto(desc.getName(), desc.getLabelExpression())).collect(Collectors.toList());
                return new SiriusServerSectionDto(section.getName(), section.getTitleExpression(), activities);
            }).collect(Collectors.toList());
            return new SiriusServerPageDto(page.getName(), page.getTitleExpression(), page.getDescriptionExpression(), sections);
        });
    }
}

