/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.workspace.internal.schema;

import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypesProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnectionTypeProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLEdgeTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ContainerResourcesField;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourceTypeResolver;

public class ContainerTypesProvider
implements ISiriusGraphQLTypesProvider {
    public static final String CONTAINER_TYPE = "Container";
    public static final String CONTAINER_RESOURCE_CONNECTION_TYPE = "ContainerResourceConnection";
    public static final String CONTAINER_RESOURCE_EDGE_TYPE = "ContainerResourceEdge";

    public Set<GraphQLType> getTypes(ISiriusGraphQLTypeCustomizer customizer) {
        GraphQLObjectType resourceEdge = new SiriusGraphQLEdgeTypeProvider(CONTAINER_RESOURCE_EDGE_TYPE, "Resource").getType(customizer);
        GraphQLObjectType resourceConnection = new SiriusGraphQLConnectionTypeProvider(CONTAINER_RESOURCE_CONNECTION_TYPE, CONTAINER_RESOURCE_EDGE_TYPE).getType(customizer);
        GraphQLInterfaceType.Builder containerBuilder = GraphQLInterfaceType.newInterface().name(CONTAINER_TYPE).field(ContainerResourcesField.build()).typeResolver(ResourceTypeResolver.build());
        GraphQLInterfaceType.Builder customizedContainerBuilder = customizer.customize(CONTAINER_TYPE, containerBuilder);
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add((GraphQLType)customizedContainerBuilder.build());
        types.add((GraphQLType)resourceEdge);
        types.add((GraphQLType)resourceConnection);
        return types;
    }
}

