/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.graph;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.graph.AsDirectedTopGraph;
import org.eclipse.set.utils.graph.AsSplitTopGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.WeightedPseudograph;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=modelsession/change/model"}, service={EventHandler.class, TopologicalGraphService.class})
public class TopologicalGraphServiceImpl
implements TopologicalGraphService,
EventHandler {
    private WeightedPseudograph<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> topGraphBase;
    @Reference
    EventAdmin eventAdmin;

    public TopologicalGraphServiceImpl() {
        Services.setTopGraphService((TopologicalGraphService)this);
    }

    public void handleEvent(Event event) {
        this.topGraphBase = new WeightedPseudograph(AsSplitTopGraph.Edge.class);
        PlanPro_Schnittstelle planProSchnittstelle = (PlanPro_Schnittstelle)event.getProperty("org.eclipse.e4.data");
        this.addContainerToGraph(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.INITIAL));
        this.addContainerToGraph(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.FINAL));
        this.addContainerToGraph(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planProSchnittstelle, (ContainerType)ContainerType.SINGLE));
        HashMap<String, PlanPro_Schnittstelle> properties = new HashMap<String, PlanPro_Schnittstelle>();
        properties.put("org.eclipse.e4.data", planProSchnittstelle);
        this.eventAdmin.sendEvent(new Event("modelsession/change/topmodel", properties));
    }

    private void addContainerToGraph(MultiContainer_AttributeGroup container) {
        if (container == null) {
            return;
        }
        container.getTOPKante().forEach(this::addEdge);
    }

    private void addEdge(TOP_Kante edge) {
        AsSplitTopGraph.Node a = new AsSplitTopGraph.Node(edge.getIDTOPKnotenA().getValue());
        AsSplitTopGraph.Node b = new AsSplitTopGraph.Node(edge.getIDTOPKnotenB().getValue());
        this.topGraphBase.addVertex((Object)a);
        this.topGraphBase.addVertex((Object)b);
        AsSplitTopGraph.Edge graphEdge = new AsSplitTopGraph.Edge(edge);
        this.topGraphBase.addEdge((Object)a, (Object)b, (Object)graphEdge);
        this.topGraphBase.setEdgeWeight((Object)graphEdge, edge.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue());
    }

    public List<TopPath> findAllPathsBetween(TopPoint from, TopPoint to, int limit) {
        return AsDirectedTopGraph.getAllPaths((AsSplitTopGraph)new AsSplitTopGraph(this.topGraphBase), (TopPoint)from, (TopPoint)to, (int)limit);
    }

    public TopPath findPathBetween(TopPoint from, TopPoint to, int limit, Predicate<TopPath> condition) {
        return AsDirectedTopGraph.getPath((AsSplitTopGraph)new AsSplitTopGraph(this.topGraphBase), (TopPoint)from, (TopPoint)to, (int)limit, condition);
    }

    public Optional<BigDecimal> findShortestDistanceInDirection(TopPoint from, TopPoint to, boolean searchInTopDirection) {
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.topGraphBase);
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from, Boolean.valueOf(searchInTopDirection));
        AsSplitTopGraph.Node toNode = graphView.splitGraphAt(to);
        return Optional.ofNullable(DijkstraShortestPath.findPathBetween((Graph)graphView, (Object)fromNode, (Object)toNode)).map(p -> TopologicalGraphServiceImpl.getPathWeight((GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)p));
    }

    public Optional<TopPath> findShortestPath(TopPoint from, TopPoint to) {
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.topGraphBase);
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from);
        AsSplitTopGraph.Node toNode = graphView.splitGraphAt(to);
        return Optional.ofNullable(DijkstraShortestPath.findPathBetween((Graph)graphView, (Object)fromNode, (Object)toNode)).map(p -> new TopPath(p.getEdgeList().stream().map(AsSplitTopGraph.Edge::edge).distinct().toList(), TopologicalGraphServiceImpl.getPathWeight((GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)p), fromNode.point().distance()));
    }

    private static BigDecimal getPathWeight(GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge> path) {
        return path.getEdgeList().stream().map(AsSplitTopGraph.Edge::getWeight).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public Optional<BigDecimal> findShortestDistance(TopPoint from, TopPoint to) {
        return this.findShortestPath(from, to).map(TopPath::length);
    }

    public Optional<TopPoint> findClosestPoint(TopPoint from, List<TopPoint> points, boolean searchInTopDirection) {
        AsSplitTopGraph graphView = new AsSplitTopGraph(this.topGraphBase);
        AsSplitTopGraph.Node fromNode = graphView.splitGraphAt(from, Boolean.valueOf(searchInTopDirection));
        BigDecimal minWeight = BigDecimal.valueOf(1000000L);
        Optional<TopPoint> minPoint = Optional.empty();
        for (TopPoint point : points) {
            AsSplitTopGraph.Node toNode = null;
            try {
                toNode = graphView.splitGraphAt(point);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            GraphPath path = DijkstraShortestPath.findPathBetween((Graph)graphView, (Object)fromNode, (Object)toNode);
            if (path == null) continue;
            BigDecimal weight = TopologicalGraphServiceImpl.getPathWeight((GraphPath<AsSplitTopGraph.Node, AsSplitTopGraph.Edge>)path);
            if (!minPoint.isEmpty() && weight.compareTo(minWeight) >= 0) continue;
            minWeight = weight;
            minPoint = Optional.of(point);
        }
        return minPoint;
    }
}

