/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GEOKanteSegment;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.basis.geometry.Geometries;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CacheUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=modelsession/change/topmodel", "event.topics=modelsession/close"}, service={GeoKanteGeometryService.class, EventHandler.class})
public class GeoKanteGeometryServiceImpl
implements GeoKanteGeometryService,
EventHandler {
    private Thread findGeometryThread;
    static double GEO_LENGTH_DEVIATION_TOLERANCE = 0.001;
    static double GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE = 1.0E-4;
    static final Logger logger = LoggerFactory.getLogger(GeoKanteGeometryServiceImpl.class);
    private Map<GEO_Kante, LineString> edgeGeometry;
    private Map<String, List<GEOKanteMetadata>> geoKanteMetadas;
    private boolean isProcessComplete = false;
    @Reference
    private EventAdmin eventAdmin;

    public GeoKanteGeometryServiceImpl() {
        Services.setGeometryService((GeoKanteGeometryService)this);
    }

    /*
     * WARNING - void declaration
     */
    public void handleEvent(Event event) {
        Object object;
        String topic = event.getTopic();
        if (topic.equals("modelsession/change/topmodel") && (object = event.getProperty("org.eclipse.e4.data")) instanceof PlanPro_Schnittstelle) {
            void schnitstelle;
            PlanPro_Schnittstelle planPro_Schnittstelle = (PlanPro_Schnittstelle)object;
            PlanPro_Schnittstelle cfr_ignored_0 = (PlanPro_Schnittstelle)object;
            this.edgeGeometry = new ConcurrentHashMap<GEO_Kante, LineString>();
            this.geoKanteMetadas = new ConcurrentHashMap<String, List<GEOKanteMetadata>>();
            this.findGeometryThread = new Thread(() -> this.lambda$0((PlanPro_Schnittstelle)schnitstelle), "toolbox.cache.geokante-geometry");
            this.findGeometryThread.start();
        }
        if (topic.equals("modelsession/close") && this.findGeometryThread != null && this.findGeometryThread.isAlive() && !this.findGeometryThread.isInterrupted()) {
            this.findGeometryThread.interrupt();
            this.isProcessComplete = false;
            this.edgeGeometry.clear();
            this.geoKanteMetadas.clear();
        }
    }

    private void findGeoKanteGeometry(MultiContainer_AttributeGroup container) throws InterruptedException {
        if (container == null) {
            return;
        }
        for (GEO_Kante edge : container.getGEOKante()) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            try {
                LineString geometry = GEOKanteGeometryExtensions.defineEdgeGeometry((GEO_Kante)edge);
                if (geometry == null) continue;
                this.edgeGeometry.put(edge, geometry);
            }
            catch (NullPointerException | GeometryException e) {
                logger.warn("Cannot determine geometry for edge {}.", (Object)edge.getIdentitaet().getWert());
            }
        }
    }

    public LineString getGeometry(GEO_Kante edge) {
        while (!this.isFindGeometryComplete()) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.edgeGeometry.getOrDefault(edge, null);
    }

    public LineString getGeometry(DirectedElement<GEO_Kante> directedEdge) {
        LineString geometry = this.getGeometry((GEO_Kante)directedEdge.getElement());
        if (geometry == null) {
            return null;
        }
        return directedEdge.isForwards() ? geometry : geometry.reverse();
    }

    public boolean isFindGeometryComplete() {
        return this.isProcessComplete;
    }

    public GEOKanteCoordinate getCoordinateAt(Punkt_Objekt punktObjekt, double distance) {
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt.getPunktObjektTOPKante().getFirst();
        return this.getCoordinateAt(singlePoint, distance);
    }

    private GEOKanteCoordinate getCoordinateAt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, double distance) {
        if (singlePoint == null || singlePoint.getAbstand() == null || singlePoint.getAbstand().getWert() == null) {
            return null;
        }
        double pointDistance = singlePoint.getAbstand().getWert().doubleValue() + distance;
        ENUMWirkrichtung direction = GeoKanteGeometryServiceImpl.getNullableObject(singlePoint, p -> p.getWirkrichtung().getWert()).orElse(null);
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint);
        if (topKante == null) {
            return null;
        }
        TOP_Knoten start = TopKanteExtensions.getTOPKnotenA((TOP_Kante)topKante);
        GEOKanteMetadata geoEdgeMd = this.getGeoKanteAt(topKante, start, pointDistance);
        if (geoEdgeMd == null) {
            logger.error("Can't found Geo_Kante by TOP_Knoten: {} of TOP_Kante: {}", (Object)start.getIdentitaet().getWert(), (Object)topKante.getIdentitaet().getWert());
            return null;
        }
        double lateralDistance = 0.0;
        if (singlePoint.getSeitlicherAbstand() != null && singlePoint.getSeitlicherAbstand().getWert() != null) {
            lateralDistance = singlePoint.getSeitlicherAbstand().getWert().doubleValue();
        }
        if (direction == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_BEIDE || direction == null) {
            return this.getCoordinate(geoEdgeMd, pointDistance, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
        }
        return this.getCoordinate(geoEdgeMd, pointDistance, lateralDistance, direction);
    }

    public GEOKanteCoordinate getCoordinate(TOP_Kante topKante, TOP_Knoten start, double distance, double lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteMetadata md = this.getGeoKanteAt(topKante, start, distance);
        return this.getCoordinate(md, distance, lateralDistance, wirkrichtung);
    }

    public GEOKanteCoordinate getCoordinate(GEOKanteMetadata md, double distance, double lateralDistance, ENUMWirkrichtung wirkrichtung) {
        GEOKanteSegment segment = md.getContainingSegment(distance);
        if (segment == null) {
            throw new RuntimeException("Missing GEO_Kante segment");
        }
        double edgeLength = Math.abs(md.getLength());
        double geoLength = md.getGeometry().getLength();
        double localDistance = distance - md.getStart();
        double scaledDistance = localDistance != 0.0 ? localDistance * (geoLength / edgeLength) : 0.0;
        SegmentPosition position = Geometries.getSegmentPosition((LineString)md.getGeometry(), (Coordinate)GeoKnotenExtensions.getCoordinate((GEO_Knoten)md.getGeoKnoten()), (double)scaledDistance);
        LineSegment tangent = GeoKanteExtensions.getTangent((GEO_Kante)md.getGeoKante(), (SegmentPosition)position);
        GeoPosition coordinate = GeoKanteExtensions.getCoordinate((LineSegment)tangent, (SegmentPosition)position, (double)lateralDistance, (ENUMWirkrichtung)wirkrichtung);
        return new GEOKanteCoordinate(coordinate, segment.getBereichObjekte(), GeoKnotenExtensions.getCRS((GEO_Knoten)md.getGeoKnoten()));
    }

    public GEOKanteMetadata getGeoKanteAt(TOP_Kante topKante, TOP_Knoten topKnoten, double distance) {
        List<GEOKanteMetadata> geoMetadatas = this.getTOPKanteMetadata(topKante, topKnoten);
        Optional<GEOKanteMetadata> result = geoMetadatas.stream().filter(md -> md.getStart() <= distance && md.getEnd() >= distance).findFirst();
        return result.orElse(null);
    }

    public List<GEOKanteMetadata> getGeoKanten(TOP_Kante topKante) {
        return this.getTOPKanteMetadata(topKante, topKante.getIDTOPKnotenA().getValue());
    }

    private List<GEOKanteMetadata> getTOPKanteMetadata(TOP_Kante topEdge, TOP_Knoten start) {
        String key = CacheUtils.getCacheKey((Ur_Objekt)topEdge, (Object)start);
        return this.geoKanteMetadas.computeIfAbsent(key, k -> {
            List<Bereich_Objekt> bereichObjekt = StreamSupport.stream(BasisAttributExtensions.getContainer((EObject)start).getBereichObjekt().spliterator(), false).toList();
            return this.getTOPKanteMetadata(topEdge, start, bereichObjekt);
        });
    }

    private List<GEOKanteMetadata> getTOPKanteMetadata(TOP_Kante topKante, TOP_Knoten start, List<Bereich_Objekt> bereichObjekte) {
        double distanceScalingFactor = GeoKanteGeometryServiceImpl.getTOPKanteScalingFactor(topKante);
        double distance = 0.0;
        GEO_Knoten geoKnoten = TopKnotenExtensions.getGEOKnoten((TOP_Knoten)start);
        GEO_Kante geoKante = null;
        ArrayList<GEOKanteMetadata> geoKanteMetadata = new ArrayList<GEOKanteMetadata>();
        while (true) {
            List geoKanten = GeoKnotenExtensions.getGeoKantenOnTopKante((GEO_Knoten)geoKnoten, (TOP_Kante)topKante);
            geoKanten.remove(geoKante);
            if (geoKanten.isEmpty()) {
                return geoKanteMetadata;
            }
            geoKante = (GEO_Kante)geoKanten.get(0);
            double geoKanteLength = geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue() * (1.0 / distanceScalingFactor);
            geoKanteMetadata.add(new GEOKanteMetadata(geoKante, distance, geoKanteLength, bereichObjekte, topKante, geoKnoten, this.getGeometry(geoKante)));
            distance += geoKanteLength;
            geoKnoten = GeoKanteExtensions.getOpposite((GEO_Kante)geoKante, (GEO_Knoten)geoKnoten);
        }
    }

    private static double getTOPKanteScalingFactor(TOP_Kante topKante) {
        double scale;
        double tolerance;
        List geoKantenOnTopKante = TopKanteExtensions.getGeoKanten((TOP_Kante)topKante);
        double geoLength = 0.0;
        for (GEO_Kante geoKante : geoKantenOnTopKante) {
            try {
                geoLength += geoKante.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
            }
            catch (NullPointerException e) {
                logger.error("Geo_Kante: {} missing Geo_Laenge", (Object)geoKante.getIdentitaet().getWert());
            }
        }
        double topLength = topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        double difference = Math.abs(geoLength - topLength);
        if (difference > (tolerance = Math.max(GEO_LENGTH_DEVIATION_TOLERANCE, topLength * GEO_LENGTH_DEVIATION_TOLERANCE_RELATIVE))) {
            logger.debug("lengthTopKante={}", (Object)topLength);
            logger.debug("lengthGeoKanten={}", (Object)geoLength);
            logger.debug("geoKantenOnTopKante={}", (Object)geoKantenOnTopKante.size());
            logger.warn("Difference of GEO Kanten length and TOP Kante length for TOP Kante {} greater than tolerance {} ({}).", new Object[]{topKante.getIdentitaet().getWert(), tolerance, difference});
        }
        return (scale = geoLength / topLength) > 0.0 ? scale : 1.0;
    }

    private static <T, U> Optional<U> getNullableObject(T t, Function<T, U> func) {
        try {
            U result = func.apply(t);
            return Optional.ofNullable(result);
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    private /* synthetic */ void lambda$0(PlanPro_Schnittstelle planPro_Schnittstelle) {
        try {
            logger.debug("Start find geometry of GEO_Kante");
            this.isProcessComplete = false;
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.INITIAL));
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.FINAL));
            this.findGeoKanteGeometry(PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planPro_Schnittstelle, (ContainerType)ContainerType.SINGLE));
            this.isProcessComplete = true;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("event.topics", "geometryService/done");
            this.eventAdmin.sendEvent(new Event("geometryService/done", properties));
            logger.debug("Find geometry of GEO_Kante process is complete");
        }
        catch (InterruptedException e) {
            this.isProcessComplete = true;
            Thread.currentThread().interrupt();
        }
    }
}

