/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.sskp;

import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.model.planpro.Bahnsteig.Bahnsteig_Kante;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;

public class SskpBahnsteigUtils {
    static BahnsteigDistance getBahnsteigDistances(List<Bahnsteig_Kante> bahnsteigs, PZB_Element pzb) {
        Punkt_Objekt_TOP_Kante_AttributeGroup point = (Punkt_Objekt_TOP_Kante_AttributeGroup)pzb.getPunktObjektTOPKante().get(0);
        boolean isPZBAtBahnsteig = bahnsteigs.stream().anyMatch(bahnsteig -> PunktObjektTopKanteExtensions.isBelongToBereichObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)point, (Bereich_Objekt)bahnsteig));
        if (isPZBAtBahnsteig) {
            return SskpBahnsteigUtils.getBahnsteigDistanceAtMagnet(bahnsteigs, pzb);
        }
        return SskpBahnsteigUtils.getBahnsteigDistancesNotAtMagnet(bahnsteigs, pzb);
    }

    private static BahnsteigDistance getBahnsteigDistancesNotAtMagnet(Iterable<Bahnsteig_Kante> bahnsteig, PZB_Element pzb) {
        Punkt_Objekt_TOP_Kante_AttributeGroup potk = PunktObjektExtensions.getSinglePoint((Punkt_Objekt)pzb);
        boolean searchDirection = !PunktObjektTopKanteExtensions.isWirkrichtungTopDirection((Punkt_Objekt_TOP_Kante_AttributeGroup)potk);
        Optional<Range> reduce = Streams.stream(bahnsteig).map(bsk -> PunktObjektExtensions.distanceToBereichObjekt((Punkt_Objekt)pzb, (Bereich_Objekt)bsk, (boolean)searchDirection)).filter(Optional::isPresent).map(Optional::get).reduce(Range::span);
        if (reduce.isEmpty()) {
            return new BahnsteigDistance(OptionalDouble.empty(), OptionalDouble.empty());
        }
        return new BahnsteigDistance((Double)reduce.get().upperEndpoint(), (Double)reduce.get().lowerEndpoint());
    }

    private static BahnsteigDistance getBahnsteigDistanceAtMagnet(Iterable<Bahnsteig_Kante> bahnsteig, PZB_Element pzb) {
        Punkt_Objekt_TOP_Kante_AttributeGroup potk = PunktObjektExtensions.getSinglePoint((Punkt_Objekt)pzb);
        boolean isWirkrichtungTopDirection = PunktObjektTopKanteExtensions.isWirkrichtungTopDirection((Punkt_Objekt_TOP_Kante_AttributeGroup)potk);
        TopPoint pzbPoint = new TopPoint((Punkt_Objekt)pzb);
        TopologicalGraphService topGraphService = Services.getTopGraphService();
        OptionalDouble start = Streams.stream(bahnsteig).flatMap(bsk -> BereichObjektExtensions.toTopPoints((Bereich_Objekt)bsk).stream().flatMap(Collection::stream)).map(point -> topGraphService.findShortestDistanceInDirection(pzbPoint, point, !isWirkrichtungTopDirection)).filter(Optional::isPresent).mapToDouble(c -> ((BigDecimal)c.get()).doubleValue()).max();
        OptionalDouble end = Streams.stream(bahnsteig).flatMap(bsk -> BereichObjektExtensions.toTopPoints((Bereich_Objekt)bsk).stream().flatMap(Collection::stream)).map(point -> topGraphService.findShortestDistanceInDirection(pzbPoint, point, isWirkrichtungTopDirection)).filter(Optional::isPresent).mapToDouble(c -> ((BigDecimal)c.get()).doubleValue()).map(c -> -c).min();
        return new BahnsteigDistance(start, end);
    }

    public static class BahnsteigDistance {
        private final OptionalDouble distanceEnd;
        private final OptionalDouble distanceStart;

        public BahnsteigDistance(OptionalDouble min, OptionalDouble max) {
            this.distanceStart = min;
            this.distanceEnd = max;
        }

        public BahnsteigDistance(double start, double end) {
            this.distanceStart = OptionalDouble.of(start);
            this.distanceEnd = OptionalDouble.of(end);
        }

        public BahnsteigDistance(Double start, Double end) {
            this(OptionalDouble.of(start), OptionalDouble.of(end));
        }

        public OptionalDouble getDistanceStart() {
            return this.distanceStart;
        }

        public OptionalDouble getDistanceEnd() {
            return this.distanceEnd;
        }
    }
}

