/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.service;

import java.util.Comparator;
import java.util.List;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazReport;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.model.validationreport.ValidationSeverity;

public interface PlazModelService {
    public static final List<ValidationSeverity> severityOrder = List.of(ValidationSeverity.ERROR, ValidationSeverity.WARNING, ValidationSeverity.SUCCESS);

    public PlazReport runPlazModel(IModelSession var1);

    public <T extends PlazCheck> PlazReport runPlazModel(IModelSession var1, Class<T> var2);

    public static void sortProblems(List<ValidationProblem> problems) {
        Comparator<ValidationProblem> comparator = Comparator.comparingInt(t -> severityOrder.indexOf(t.getSeverity())).thenComparing(t -> t.getType()).thenComparingInt(t -> t.getLineNumber());
        problems.sort(comparator);
    }

    public static void sortAndIndexedProblems(List<ValidationProblem> problems) {
        PlazModelService.sortProblems(problems);
        int i = 1;
        for (ValidationProblem problem : problems) {
            problem.setId(i);
            ++i;
        }
    }
}

