/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class GuidUnique
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        HashSet knownGUIDs = CollectionLiterals.newHashSet();
        Functions.Function1 _function = it -> {
            String guid;
            Identitaet_TypeClass _identitaet = it.getIdentitaet();
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if ((guid = _wert) != null && knownGUIDs.contains(guid)) {
                PlazError err = PlazFactory.eINSTANCE.createPlazError();
                err.setMessage(this.transformErrorMsg(Map.of("GUID", guid)));
                err.setType(this.checkType());
                err.setObject((EObject)it.getIdentitaet());
                return err;
            }
            knownGUIDs.add(guid);
            return null;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)container.getUrObjekt(), (Functions.Function1)_function)));
    }

    @Override
    public String checkType() {
        return "GUID-Eindeutigkeit";
    }

    @Override
    public String getDescription() {
        return "Die GUIDs aller Objekte sind eindeutig.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Die GUID {GUID} ist nicht eindeutig!";
    }
}

