/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SinglePointIterator
implements Iterator<Punkt_Objekt_TOP_Kante_AttributeGroup> {
    private static Cache cache;
    private final Iterator<Punkt_Objekt_TOP_Kante_AttributeGroup> internalIterator;

    public SinglePointIterator(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        try {
            this.createCache();
            MissingSupplier _function = () -> this.singlePoints(edge);
            List singlePoints = (List)cache.get(edge.getCacheKey(), _function);
            this.internalIterator = singlePoints.iterator();
        }
        catch (Throwable _t) {
            if (_t instanceof ExecutionException) {
                ExecutionException e = (ExecutionException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private void createCache() {
        if (cache == null) {
            cache = Services.getCacheService().getCache("toolbox.cache.directed-edge-to-singlepoints");
        }
    }

    private List<Punkt_Objekt_TOP_Kante_AttributeGroup> singlePoints(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
        List<Punkt_Objekt_TOP_Kante_AttributeGroup> _connected = TopKanteExtensions.getConnected((TOP_Kante)edge.getElement());
        SinglePointComparator _singlePointComparator = new SinglePointComparator(edge);
        return IterableExtensions.sortWith(_connected, (Comparator)_singlePointComparator);
    }

    @Override
    public boolean hasNext() {
        return this.internalIterator.hasNext();
    }

    @Override
    public Punkt_Objekt_TOP_Kante_AttributeGroup next() {
        return this.internalIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum Direction {
        AB,
        BA;

    }

    private static class SinglePointComparator
    implements Comparator<Punkt_Objekt_TOP_Kante_AttributeGroup> {
        private final DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge;

        public SinglePointComparator(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edge) {
            this.edge = edge;
        }

        @Override
        public int compare(Punkt_Objekt_TOP_Kante_AttributeGroup o1, Punkt_Objekt_TOP_Kante_AttributeGroup o2) {
            double d1 = this.edge.distanceFromTail((Object)o1);
            double d2 = this.edge.distanceFromTail((Object)o2);
            return Distance.compare(d1, d2);
        }
    }
}

