/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.BasisobjekteFactory;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Akteur;
import org.eclipse.set.model.planpro.PlanPro.Akteur_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Akteur_Zuordnung;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.Bauabschnitt_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bauphase_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bauzustand_Kurzbezeichnung_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bemerkung_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Anlage_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Planung_Gruppe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Planung_Projekt_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Unteranlage_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Datum_Abschluss_Einzel_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Datum_Abschluss_Gruppe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Datum_Abschluss_Projekt_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.DocumentRoot;
import org.eclipse.set.model.planpro.PlanPro.ENUMPlanungEArt;
import org.eclipse.set.model.planpro.PlanPro.ENUMPlanungPhase;
import org.eclipse.set.model.planpro.PlanPro.Erzeugung_Zeitstempel_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Fachdaten_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Fuehrende_Oertlichkeit_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Index_Ausgabe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Informativ_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.LST_Planung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Zustand;
import org.eclipse.set.model.planpro.PlanPro.Laufende_Nummer_Ausgabe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Objektmanagement_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Organisation;
import org.eclipse.set.model.planpro.PlanPro.PlanProFactory;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_XSD_Version_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Planung_E_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_E_Art_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Planung_E_Handlung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Fuehrende_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Schriftfeld_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Planung_P_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Phase_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Planung_Projekt;
import org.eclipse.set.model.planpro.PlanPro.Projekt_Nummer_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Strecke_Abschnitt_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Strecke_Km_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Verantwortliche_Stelle_DB_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Werkzeug_Name_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Werkzeug_Version_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.util.PlanProResourceImpl;
import org.eclipse.set.model.planpro.Verweise.ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass;
import org.eclipse.set.model.planpro.Verweise.VerweiseFactory;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungEinzelExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungProjektExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class PlanProSchnittstelleExtensions {
    public static boolean isPlanning(PlanPro_Schnittstelle schnittstelle) {
        return schnittstelle != null && PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle) != null;
    }

    public static void fix(PlanPro_Schnittstelle schnittstelle) {
        boolean _isPlanning = PlanProSchnittstelleExtensions.isPlanning(schnittstelle);
        if (_isPlanning) {
            PlanProSchnittstelleExtensions.fixGuids(schnittstelle);
        }
    }

    public static boolean containsUnfilledManagementValues(PlanPro_Schnittstelle schnittstelle, XMLResource resource) {
        Objektmanagement_AttributeGroup objman;
        boolean _isEmpty;
        LST_Planung_AttributeGroup _lSTPlanung = null;
        if (schnittstelle != null) {
            _lSTPlanung = schnittstelle.getLSTPlanung();
        }
        Objektmanagement_AttributeGroup _objektmanagement = null;
        if (_lSTPlanung != null) {
            _objektmanagement = _lSTPlanung.getObjektmanagement();
        }
        return !(_isEmpty = IterableExtensions.isEmpty(EObjectExtensions.getUnfilledValues((EObject)(objman = _objektmanagement))));
    }

    public static void fixManagementDefaults(PlanPro_Schnittstelle schnittstlle) {
        LST_Planung_AttributeGroup _lSTPlanung = null;
        if (schnittstlle != null) {
            _lSTPlanung = schnittstlle.getLSTPlanung();
        }
        Objektmanagement_AttributeGroup _objektmanagement = null;
        if (_lSTPlanung != null) {
            _objektmanagement = _lSTPlanung.getObjektmanagement();
        }
        Consumer<Pair> _function = it -> EObjectExtensions.fillDefaults((EObject)it.getValue());
        EObjectExtensions.getUnfilledValues((EObject)_objektmanagement).forEach(_function);
    }

    public static boolean containsUnfilledValues(PlanPro_Schnittstelle schnittstelle, XMLResource resource) {
        List unfilledValues = IterableExtensions.toList(EObjectExtensions.getUnfilledValues((EObject)schnittstelle));
        if (resource instanceof PlanProResourceImpl) {
            boolean _isEmpty = unfilledValues.isEmpty();
            return !_isEmpty;
        }
        boolean _isEmpty_1 = unfilledValues.isEmpty();
        return !_isEmpty_1;
    }

    public static MultiContainer_AttributeGroup getContainer(PlanPro_Schnittstelle schnittstelle, ContainerType container) throws IllegalArgumentException {
        if (container != null) {
            switch (container) {
                case INITIAL: {
                    Optional<Iterable<Planung_Gruppe>> projects = PlanProSchnittstelleExtensions.getLSTPlanungGruppe(schnittstelle);
                    boolean _isPresent = projects.isPresent();
                    if (_isPresent) {
                        Functions.Function1 _function = it -> {
                            Planung_Einzel _lSTPlanungEinzel = it.getLSTPlanungEinzel();
                            LST_Zustand _LSTZustandStart = null;
                            if (_lSTPlanungEinzel != null) {
                                _LSTZustandStart = PlanungEinzelExtensions.LSTZustandStart(_lSTPlanungEinzel);
                            }
                            Container_AttributeGroup _container = null;
                            if (_LSTZustandStart != null) {
                                _container = _LSTZustandStart.getContainer();
                            }
                            return _container;
                        };
                        Iterable containers = IterableExtensions.map(projects.get(), (Functions.Function1)_function);
                        return new MultiContainer_AttributeGroup(containers);
                    }
                    return null;
                }
                case FINAL: {
                    Optional<Iterable<Planung_Gruppe>> projects_1 = PlanProSchnittstelleExtensions.getLSTPlanungGruppe(schnittstelle);
                    boolean _isPresent_1 = projects_1.isPresent();
                    if (_isPresent_1) {
                        Functions.Function1 _function_1 = it -> {
                            Planung_Einzel _lSTPlanungEinzel = it.getLSTPlanungEinzel();
                            LST_Zustand _LSTZustandZiel = null;
                            if (_lSTPlanungEinzel != null) {
                                _LSTZustandZiel = PlanungEinzelExtensions.LSTZustandZiel(_lSTPlanungEinzel);
                            }
                            Container_AttributeGroup _container = null;
                            if (_LSTZustandZiel != null) {
                                _container = _LSTZustandZiel.getContainer();
                            }
                            return _container;
                        };
                        Iterable containers_1 = IterableExtensions.map(projects_1.get(), (Functions.Function1)_function_1);
                        return new MultiContainer_AttributeGroup(containers_1);
                    }
                    return null;
                }
                case SINGLE: {
                    Container_AttributeGroup singleContainer;
                    LST_Zustand _lSTZustand = null;
                    if (schnittstelle != null) {
                        _lSTZustand = schnittstelle.getLSTZustand();
                    }
                    Container_AttributeGroup _container = null;
                    if (_lSTZustand != null) {
                        _container = _lSTZustand.getContainer();
                    }
                    if ((singleContainer = _container) != null) {
                        LST_Zustand _lSTZustand_1 = null;
                        if (schnittstelle != null) {
                            _lSTZustand_1 = schnittstelle.getLSTZustand();
                        }
                        Container_AttributeGroup _container_1 = null;
                        if (_lSTZustand_1 != null) {
                            _container_1 = _lSTZustand_1.getContainer();
                        }
                        return new MultiContainer_AttributeGroup(_container_1);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static DocumentRoot getDocumentRoot(PlanPro_Schnittstelle schnittstelle) {
        EObject container = schnittstelle.eContainer();
        if (container instanceof DocumentRoot) {
            return (DocumentRoot)container;
        }
        return null;
    }

    public static Planung_E_Allg_AttributeGroup getPlanungAllgemein(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        return _planungEAllg;
    }

    public static void copyMetaData(PlanPro_Schnittstelle schnittstelle, PlanPro_Schnittstelle destination) {
        String bauzustandKurzbezeichnung;
        PlanPro_Schnittstelle copy = (PlanPro_Schnittstelle)EcoreUtil.copy((EObject)schnittstelle);
        PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel().getAnhangErlaeuterungsbericht().addAll((Collection)PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getLSTPlanungEinzel().getAnhangErlaeuterungsbericht());
        PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel().getAnhangMaterialBesonders().addAll((Collection)PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getLSTPlanungEinzel().getAnhangMaterialBesonders());
        PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel().getAnhangVzG().addAll((Collection)PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getLSTPlanungEinzel().getAnhangVzG());
        Planung_Einzel _lSTPlanungEinzel = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel();
        _lSTPlanungEinzel.setPlanungEAllg(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getLSTPlanungEinzel().getPlanungEAllg());
        Planung_Einzel _lSTPlanungEinzel_1 = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel();
        _lSTPlanungEinzel_1.setPlanungEHandlung(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getLSTPlanungEinzel().getPlanungEHandlung());
        Planung_Gruppe _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination));
        _planungGruppe.setPlanungGAllg(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getPlanungGAllg());
        Planung_Gruppe _planungGruppe_1 = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination));
        _planungGruppe_1.setPlanungGFuehrendeStrecke(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getPlanungGFuehrendeStrecke());
        Planung_Gruppe _planungGruppe_2 = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination));
        _planungGruppe_2.setPlanungGSchriftfeld(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy)).getPlanungGSchriftfeld());
        Planung_Projekt _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination);
        _LSTPlanungProjekt.setPlanungPAllg(PlanProSchnittstelleExtensions.LSTPlanungProjekt(copy).getPlanungPAllg());
        Planung_Projekt _LSTPlanungProjekt_1 = null;
        if (destination != null) {
            _LSTPlanungProjekt_1 = PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination);
        }
        Planung_Gruppe _planungGruppe_3 = null;
        if (_LSTPlanungProjekt_1 != null) {
            _planungGruppe_3 = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt_1);
        }
        Planung_Einzel _lSTPlanungEinzel_2 = null;
        if (_planungGruppe_3 != null) {
            _lSTPlanungEinzel_2 = _planungGruppe_3.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel_2 != null) {
            _planungEAllg = _lSTPlanungEinzel_2.getPlanungEAllg();
        }
        Bauzustand_Kurzbezeichnung_TypeClass _bauzustandKurzbezeichnung = null;
        if (_planungEAllg != null) {
            _bauzustandKurzbezeichnung = _planungEAllg.getBauzustandKurzbezeichnung();
        }
        String _wert = null;
        if (_bauzustandKurzbezeichnung != null) {
            _wert = _bauzustandKurzbezeichnung.getWert();
        }
        if ((bauzustandKurzbezeichnung = _wert) != null) {
            Bauzustand_Kurzbezeichnung_TypeClass _bauzustandKurzbezeichnung_1 = PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(destination)).getLSTPlanungEinzel().getPlanungEAllg().getBauzustandKurzbezeichnung();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(bauzustandKurzbezeichnung);
            _builder.append("_Gesamt");
            _bauzustandKurzbezeichnung_1.setWert(_builder.toString());
        }
    }

    public static PlanPro_Schnittstelle createEmptyModel() {
        PlanProFactory factory = PlanProFactory.eINSTANCE;
        PlanPro_Schnittstelle planPro_Schnittstelle = factory.createPlanPro_Schnittstelle();
        PlanPro_Schnittstelle_Allg_AttributeGroup allgemeineAttribute = factory.createPlanPro_Schnittstelle_Allg_AttributeGroup();
        Werkzeug_Name_TypeClass toolboxName = factory.createWerkzeug_Name_TypeClass();
        Werkzeug_Version_TypeClass toolboxVersion = factory.createWerkzeug_Version_TypeClass();
        Erzeugung_Zeitstempel_TypeClass timestamp = factory.createErzeugung_Zeitstempel_TypeClass();
        allgemeineAttribute.setErzeugungZeitstempel(timestamp);
        allgemeineAttribute.setWerkzeugName(toolboxName);
        allgemeineAttribute.setWerkzeugVersion(toolboxVersion);
        planPro_Schnittstelle.setPlanProSchnittstelleAllg(allgemeineAttribute);
        Planung_Projekt planungProject = factory.createPlanung_Projekt();
        PlanProSchnittstelleExtensions.setLSTPlanungProjekt(planPro_Schnittstelle, planungProject);
        Planung_Gruppe planungGruppe = factory.createPlanung_Gruppe();
        PlanungProjektExtensions.setLSTPlanungGruppe(planungProject, planungGruppe);
        Planung_Einzel planungEinzel = factory.createPlanung_Einzel();
        planungGruppe.setLSTPlanungEinzel(planungEinzel);
        Planung_G_Schriftfeld_AttributeGroup schriftfeld = factory.createPlanung_G_Schriftfeld_AttributeGroup();
        schriftfeld.setPlanungsbuero(factory.createOrganisation());
        planungGruppe.setPlanungGSchriftfeld(schriftfeld);
        Planung_P_Allg_AttributeGroup planungPAllg = factory.createPlanung_P_Allg_AttributeGroup();
        Akteur projektleiter = factory.createAkteur();
        projektleiter.setKontaktdaten(factory.createOrganisation());
        projektleiter.setAkteurAllg(factory.createAkteur_Allg_AttributeGroup());
        planungPAllg.setProjektleiter(projektleiter);
        planungProject.setPlanungPAllg(planungPAllg);
        Fachdaten_AttributeGroup fachdaten = factory.createFachdaten_AttributeGroup();
        Ausgabe_Fachdaten ausgabeFachdaten = factory.createAusgabe_Fachdaten();
        PlanProSchnittstelleExtensions.fixGuids((EObject)ausgabeFachdaten);
        planungEinzel.setIDAusgabeFachdaten(VerweiseFactory.eINSTANCE.createID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass());
        ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass _iDAusgabeFachdaten = planungEinzel.getIDAusgabeFachdaten();
        _iDAusgabeFachdaten.setValue(ausgabeFachdaten);
        ID_Ausgabe_Fachdaten_ohne_Proxy_TypeClass _iDAusgabeFachdaten_1 = planungEinzel.getIDAusgabeFachdaten();
        _iDAusgabeFachdaten_1.setWert(ausgabeFachdaten.getIdentitaet().getWert());
        fachdaten.getAusgabeFachdaten().add((Object)ausgabeFachdaten);
        LST_Planung_AttributeGroup _LSTPlanung = PlanungEinzelExtensions.LSTPlanung(planungEinzel);
        _LSTPlanung.setFachdaten(fachdaten);
        planungEinzel.setPlanungEHandlung(factory.createPlanung_E_Handlung_AttributeGroup());
        LST_Zustand zustandStart = factory.createLST_Zustand();
        Ausgabe_Fachdaten _ausgabeFachdaten = PlanungEinzelExtensions.getAusgabeFachdaten(planungEinzel);
        _ausgabeFachdaten.setLSTZustandStart(zustandStart);
        Planung_E_Allg_AttributeGroup planungAllgemein = factory.createPlanung_E_Allg_AttributeGroup();
        Bauzustand_Kurzbezeichnung_TypeClass bauzustand = factory.createBauzustand_Kurzbezeichnung_TypeClass();
        planungAllgemein.setBauzustandKurzbezeichnung(bauzustand);
        Laufende_Nummer_Ausgabe_TypeClass lfdNummer = factory.createLaufende_Nummer_Ausgabe_TypeClass();
        planungAllgemein.setLaufendeNummerAusgabe(lfdNummer);
        Index_Ausgabe_TypeClass index = factory.createIndex_Ausgabe_TypeClass();
        planungAllgemein.setIndexAusgabe(index);
        planungEinzel.setPlanungEAllg(planungAllgemein);
        Container_AttributeGroup containerStart = factory.createContainer_AttributeGroup();
        zustandStart.setContainer(containerStart);
        PlanProSchnittstelleExtensions.fixGuids((EObject)zustandStart);
        LST_Zustand zustandZiel = factory.createLST_Zustand();
        Ausgabe_Fachdaten _ausgabeFachdaten_1 = PlanungEinzelExtensions.getAusgabeFachdaten(planungEinzel);
        _ausgabeFachdaten_1.setLSTZustandZiel(zustandZiel);
        Container_AttributeGroup containerZiel = factory.createContainer_AttributeGroup();
        zustandZiel.setContainer(containerZiel);
        PlanProSchnittstelleExtensions.fixGuids((EObject)zustandZiel);
        return planPro_Schnittstelle;
    }

    public static PlanPro_Schnittstelle readFrom(Resource resource) {
        EList contents = resource.getContents();
        boolean _isEmpty = contents.isEmpty();
        if (_isEmpty) {
            return null;
        }
        EObject root = (EObject)IterableExtensions.head((Iterable)contents);
        if (root instanceof DocumentRoot) {
            return ((DocumentRoot)root).getPlanProSchnittstelle();
        }
        throw new IllegalArgumentException("Ressource contains no PlanPro model with the requested version.");
    }

    public static Optional<Akteur_Allg_AttributeGroup> getProjektleiter(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_P_Allg_AttributeGroup _planungPAllg = null;
        if (_LSTPlanungProjekt != null) {
            _planungPAllg = _LSTPlanungProjekt.getPlanungPAllg();
        }
        Akteur _projektleiter = null;
        if (_planungPAllg != null) {
            _projektleiter = _planungPAllg.getProjektleiter();
        }
        Akteur_Allg_AttributeGroup _akteurAllg = null;
        if (_projektleiter != null) {
            _akteurAllg = _projektleiter.getAkteurAllg();
        }
        return Optional.ofNullable(_akteurAllg);
    }

    public static Optional<Organisation> getFachplaner(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_planungGruppe != null) {
            _planungGSchriftfeld = _planungGruppe.getPlanungGSchriftfeld();
        }
        Organisation _planungsbuero = null;
        if (_planungGSchriftfeld != null) {
            _planungsbuero = _planungGSchriftfeld.getPlanungsbuero();
        }
        return Optional.ofNullable(_planungsbuero);
    }

    public static Optional<String> getBauphase(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Bauphase_TypeClass _bauphase = null;
        if (_planungEAllg != null) {
            _bauphase = _planungEAllg.getBauphase();
        }
        String _wert = null;
        if (_bauphase != null) {
            _wert = _bauphase.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBauzustandKurzbezeichnung(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Bauzustand_Kurzbezeichnung_TypeClass _bauzustandKurzbezeichnung = null;
        if (_planungEAllg != null) {
            _bauzustandKurzbezeichnung = _planungEAllg.getBauzustandKurzbezeichnung();
        }
        String _wert = null;
        if (_bauzustandKurzbezeichnung != null) {
            _wert = _bauzustandKurzbezeichnung.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<XMLGregorianCalendar> getDatumAbschlussEinzel(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Datum_Abschluss_Einzel_TypeClass _datumAbschlussEinzel = null;
        if (_planungEAllg != null) {
            _datumAbschlussEinzel = _planungEAllg.getDatumAbschlussEinzel();
        }
        XMLGregorianCalendar _wert = null;
        if (_datumAbschlussEinzel != null) {
            _wert = _datumAbschlussEinzel.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getIndexAusgabe(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Index_Ausgabe_TypeClass _indexAusgabe = null;
        if (_planungEAllg != null) {
            _indexAusgabe = _planungEAllg.getIndexAusgabe();
        }
        String _wert = null;
        if (_indexAusgabe != null) {
            _wert = _indexAusgabe.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<Boolean> getInformativ(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Informativ_TypeClass _informativ = null;
        if (_planungEAllg != null) {
            _informativ = _planungEAllg.getInformativ();
        }
        Boolean _wert = null;
        if (_informativ != null) {
            _wert = _informativ.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getLaufendeNummerAusgabe(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Laufende_Nummer_Ausgabe_TypeClass _laufendeNummerAusgabe = null;
        if (_planungEAllg != null) {
            _laufendeNummerAusgabe = _planungEAllg.getLaufendeNummerAusgabe();
        }
        String _wert = null;
        if (_laufendeNummerAusgabe != null) {
            _wert = _laufendeNummerAusgabe.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<ENUMPlanungEArt> getPlanungArt(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Planung_E_Art_TypeClass _planungEArt = null;
        if (_planungEAllg != null) {
            _planungEArt = _planungEAllg.getPlanungEArt();
        }
        ENUMPlanungEArt _wert = null;
        if (_planungEArt != null) {
            _wert = _planungEArt.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<ENUMPlanungPhase> getPlanungPhase(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_lSTPlanungEinzel != null) {
            _planungEAllg = _lSTPlanungEinzel.getPlanungEAllg();
        }
        Planung_Phase_TypeClass _planungPhase = null;
        if (_planungEAllg != null) {
            _planungPhase = _planungEAllg.getPlanungPhase();
        }
        ENUMPlanungPhase _wert = null;
        if (_planungPhase != null) {
            _wert = _planungPhase.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<XMLGregorianCalendar> getDatumAbschlussGruppe(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Allg_AttributeGroup _planungGAllg = null;
        if (_planungGruppe != null) {
            _planungGAllg = _planungGruppe.getPlanungGAllg();
        }
        Datum_Abschluss_Gruppe_TypeClass _datumAbschlussGruppe = null;
        if (_planungGAllg != null) {
            _datumAbschlussGruppe = _planungGAllg.getDatumAbschlussGruppe();
        }
        XMLGregorianCalendar _wert = null;
        if (_datumAbschlussGruppe != null) {
            _wert = _datumAbschlussGruppe.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getPlanProXSDVersion(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Allg_AttributeGroup _planungGAllg = null;
        if (_planungGruppe != null) {
            _planungGAllg = _planungGruppe.getPlanungGAllg();
        }
        PlanPro_XSD_Version_TypeClass _planProXSDVersion = null;
        if (_planungGAllg != null) {
            _planProXSDVersion = _planungGAllg.getPlanProXSDVersion();
        }
        String _wert = null;
        if (_planProXSDVersion != null) {
            _wert = _planProXSDVersion.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getVerantwortlicheStelleDB(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Allg_AttributeGroup _planungGAllg = null;
        if (_planungGruppe != null) {
            _planungGAllg = _planungGruppe.getPlanungGAllg();
        }
        Verantwortliche_Stelle_DB_TypeClass _verantwortlicheStelleDB = null;
        if (_planungGAllg != null) {
            _verantwortlicheStelleDB = _planungGAllg.getVerantwortlicheStelleDB();
        }
        String _wert = null;
        if (_verantwortlicheStelleDB != null) {
            _wert = _verantwortlicheStelleDB.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getStreckeAbschnitt(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Fuehrende_Strecke_AttributeGroup _planungGFuehrendeStrecke = null;
        if (_planungGruppe != null) {
            _planungGFuehrendeStrecke = _planungGruppe.getPlanungGFuehrendeStrecke();
        }
        Strecke_Abschnitt_TypeClass _streckeAbschnitt = null;
        if (_planungGFuehrendeStrecke != null) {
            _streckeAbschnitt = _planungGFuehrendeStrecke.getStreckeAbschnitt();
        }
        String _wert = null;
        if (_streckeAbschnitt != null) {
            _wert = _streckeAbschnitt.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getStreckeKm(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Fuehrende_Strecke_AttributeGroup _planungGFuehrendeStrecke = null;
        if (_planungGruppe != null) {
            _planungGFuehrendeStrecke = _planungGruppe.getPlanungGFuehrendeStrecke();
        }
        Strecke_Km_TypeClass _streckeKm = null;
        if (_planungGFuehrendeStrecke != null) {
            _streckeKm = _planungGFuehrendeStrecke.getStreckeKm();
        }
        String _wert = null;
        if (_streckeKm != null) {
            _wert = _streckeKm.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBauabschnitt(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_planungGruppe != null) {
            _planungGSchriftfeld = _planungGruppe.getPlanungGSchriftfeld();
        }
        Bauabschnitt_TypeClass _bauabschnitt = null;
        if (_planungGSchriftfeld != null) {
            _bauabschnitt = _planungGSchriftfeld.getBauabschnitt();
        }
        String _wert = null;
        if (_bauabschnitt != null) {
            _wert = _bauabschnitt.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBezeichnungAnlage(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_planungGruppe != null) {
            _planungGSchriftfeld = _planungGruppe.getPlanungGSchriftfeld();
        }
        Bezeichnung_Anlage_TypeClass _bezeichnungAnlage = null;
        if (_planungGSchriftfeld != null) {
            _bezeichnungAnlage = _planungGSchriftfeld.getBezeichnungAnlage();
        }
        String _wert = null;
        if (_bezeichnungAnlage != null) {
            _wert = _bezeichnungAnlage.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBezeichnungPlanungGruppe(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_planungGruppe != null) {
            _planungGSchriftfeld = _planungGruppe.getPlanungGSchriftfeld();
        }
        Bezeichnung_Planung_Gruppe_TypeClass _bezeichnungPlanungGruppe = null;
        if (_planungGSchriftfeld != null) {
            _bezeichnungPlanungGruppe = _planungGSchriftfeld.getBezeichnungPlanungGruppe();
        }
        String _wert = null;
        if (_bezeichnungPlanungGruppe != null) {
            _wert = _bezeichnungPlanungGruppe.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBezeichnungUnteranlage(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_planungGruppe != null) {
            _planungGSchriftfeld = _planungGruppe.getPlanungGSchriftfeld();
        }
        Bezeichnung_Unteranlage_TypeClass _bezeichnungUnteranlage = null;
        if (_planungGSchriftfeld != null) {
            _bezeichnungUnteranlage = _planungGSchriftfeld.getBezeichnungUnteranlage();
        }
        String _wert = null;
        if (_bezeichnungUnteranlage != null) {
            _wert = _bezeichnungUnteranlage.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getWerkzeugName(PlanPro_Schnittstelle schnittstelle) {
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg = null;
        if (schnittstelle != null) {
            _planProSchnittstelleAllg = schnittstelle.getPlanProSchnittstelleAllg();
        }
        Werkzeug_Name_TypeClass _werkzeugName = null;
        if (_planProSchnittstelleAllg != null) {
            _werkzeugName = _planProSchnittstelleAllg.getWerkzeugName();
        }
        String _wert = null;
        if (_werkzeugName != null) {
            _wert = _werkzeugName.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<XMLGregorianCalendar> getErzeugungZeitstempel(PlanPro_Schnittstelle schnittstelle) {
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg = null;
        if (schnittstelle != null) {
            _planProSchnittstelleAllg = schnittstelle.getPlanProSchnittstelleAllg();
        }
        Erzeugung_Zeitstempel_TypeClass _erzeugungZeitstempel = null;
        if (_planProSchnittstelleAllg != null) {
            _erzeugungZeitstempel = _planProSchnittstelleAllg.getErzeugungZeitstempel();
        }
        XMLGregorianCalendar _wert = null;
        if (_erzeugungZeitstempel != null) {
            _wert = _erzeugungZeitstempel.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getWerkzeugVersion(PlanPro_Schnittstelle schnittstelle) {
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg = null;
        if (schnittstelle != null) {
            _planProSchnittstelleAllg = schnittstelle.getPlanProSchnittstelleAllg();
        }
        Werkzeug_Version_TypeClass _werkzeugVersion = null;
        if (_planProSchnittstelleAllg != null) {
            _werkzeugVersion = _planProSchnittstelleAllg.getWerkzeugVersion();
        }
        String _wert = null;
        if (_werkzeugVersion != null) {
            _wert = _werkzeugVersion.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBezeichnungPlanungProjekt(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_P_Allg_AttributeGroup _planungPAllg = null;
        if (_LSTPlanungProjekt != null) {
            _planungPAllg = _LSTPlanungProjekt.getPlanungPAllg();
        }
        Bezeichnung_Planung_Projekt_TypeClass _bezeichnungPlanungProjekt = null;
        if (_planungPAllg != null) {
            _bezeichnungPlanungProjekt = _planungPAllg.getBezeichnungPlanungProjekt();
        }
        String _wert = null;
        if (_bezeichnungPlanungProjekt != null) {
            _wert = _bezeichnungPlanungProjekt.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<XMLGregorianCalendar> getDatumAbschlussProjekt(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_P_Allg_AttributeGroup _planungPAllg = null;
        if (_LSTPlanungProjekt != null) {
            _planungPAllg = _LSTPlanungProjekt.getPlanungPAllg();
        }
        Datum_Abschluss_Projekt_TypeClass _datumAbschlussProjekt = null;
        if (_planungPAllg != null) {
            _datumAbschlussProjekt = _planungPAllg.getDatumAbschlussProjekt();
        }
        XMLGregorianCalendar _wert = null;
        if (_datumAbschlussProjekt != null) {
            _wert = _datumAbschlussProjekt.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getProjektNummer(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_P_Allg_AttributeGroup _planungPAllg = null;
        if (_LSTPlanungProjekt != null) {
            _planungPAllg = _LSTPlanungProjekt.getPlanungPAllg();
        }
        Projekt_Nummer_TypeClass _projektNummer = null;
        if (_planungPAllg != null) {
            _projektNummer = _planungPAllg.getProjektNummer();
        }
        String _wert = null;
        if (_projektNummer != null) {
            _wert = _projektNummer.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getIdentitaet(PlanPro_Schnittstelle schnittstelle) {
        Identitaet_TypeClass _identitaet = null;
        if (schnittstelle != null) {
            _identitaet = schnittstelle.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getLSTPlanungEinzelIdentitaet(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Identitaet_TypeClass _identitaet = null;
        if (_lSTPlanungEinzel != null) {
            _identitaet = _lSTPlanungEinzel.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getLSTPlanungGruppeIdentitaet(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Identitaet_TypeClass _identitaet = null;
        if (_planungGruppe != null) {
            _identitaet = _planungGruppe.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        String wert = _wert;
        return Optional.ofNullable(wert);
    }

    public static Optional<Iterable<Planung_Gruppe>> getLSTPlanungGruppe(PlanPro_Schnittstelle schnittstelle) {
        LST_Planung_AttributeGroup _lSTPlanung = null;
        if (schnittstelle != null) {
            _lSTPlanung = schnittstelle.getLSTPlanung();
        }
        Objektmanagement_AttributeGroup _objektmanagement = null;
        if (_lSTPlanung != null) {
            _objektmanagement = _lSTPlanung.getObjektmanagement();
        }
        EList _lSTPlanungProjekt = null;
        if (_objektmanagement != null) {
            _lSTPlanungProjekt = _objektmanagement.getLSTPlanungProjekt();
        }
        List _map = null;
        if (_lSTPlanungProjekt != null) {
            Functions.Function1 _function = it -> it.getLSTPlanungGruppe();
            _map = ListExtensions.map((List)_lSTPlanungProjekt, (Functions.Function1)_function);
        }
        Iterable _flatten = null;
        if (_map != null) {
            _flatten = Iterables.concat((Iterable)_map);
        }
        return Optional.ofNullable(_flatten);
    }

    public static Optional<String> getLSTPlanungProjektIdentitaet(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Identitaet_TypeClass _identitaet = null;
        if (_LSTPlanungProjekt != null) {
            _identitaet = _LSTPlanungProjekt.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getLSTZustandInformationIdentitaet(PlanPro_Schnittstelle schnittstelle) {
        LST_Zustand _lSTZustand = null;
        if (schnittstelle != null) {
            _lSTZustand = schnittstelle.getLSTZustand();
        }
        Identitaet_TypeClass _identitaet = null;
        if (_lSTZustand != null) {
            _identitaet = _lSTZustand.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static List<Akteur_Zuordnung> getPlanungAbnahme(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEAbnahme = null;
        if (_planungEHandlung != null) {
            _planungEAbnahme = _planungEHandlung.getPlanungEAbnahme();
        }
        if (_planungEAbnahme != null) {
            _elvis = _planungEAbnahme;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungErstellung(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEErstellung = null;
        if (_planungEHandlung != null) {
            _planungEErstellung = _planungEHandlung.getPlanungEErstellung();
        }
        if (_planungEErstellung != null) {
            _elvis = _planungEErstellung;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungFreigabe(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEFreigabe = null;
        if (_planungEHandlung != null) {
            _planungEFreigabe = _planungEHandlung.getPlanungEFreigabe();
        }
        if (_planungEFreigabe != null) {
            _elvis = _planungEFreigabe;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungGenehmigung(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEGenehmigung = null;
        if (_planungEHandlung != null) {
            _planungEGenehmigung = _planungEHandlung.getPlanungEGenehmigung();
        }
        if (_planungEGenehmigung != null) {
            _elvis = _planungEGenehmigung;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungGleichstellung(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEGleichstellung = null;
        if (_planungEHandlung != null) {
            _planungEGleichstellung = _planungEHandlung.getPlanungEGleichstellung();
        }
        if (_planungEGleichstellung != null) {
            _elvis = _planungEGleichstellung;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungPruefung(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEPruefung = null;
        if (_planungEHandlung != null) {
            _planungEPruefung = _planungEHandlung.getPlanungEPruefung();
        }
        if (_planungEPruefung != null) {
            _elvis = _planungEPruefung;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungQualitaetspruefung(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEQualitaetspruefung = null;
        if (_planungEHandlung != null) {
            _planungEQualitaetspruefung = _planungEHandlung.getPlanungEQualitaetspruefung();
        }
        if (_planungEQualitaetspruefung != null) {
            _elvis = _planungEQualitaetspruefung;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungSonstige(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungESonstige = null;
        if (_planungEHandlung != null) {
            _planungESonstige = _planungEHandlung.getPlanungESonstige();
        }
        if (_planungESonstige != null) {
            _elvis = _planungESonstige;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static List<Akteur_Zuordnung> getPlanungUebernahme(PlanPro_Schnittstelle schnittstelle) {
        Object _elvis = null;
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_planungGruppe != null) {
            _lSTPlanungEinzel = _planungGruppe.getLSTPlanungEinzel();
        }
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (_lSTPlanungEinzel != null) {
            _planungEHandlung = _lSTPlanungEinzel.getPlanungEHandlung();
        }
        EList _planungEUebernahme = null;
        if (_planungEHandlung != null) {
            _planungEUebernahme = _planungEHandlung.getPlanungEUebernahme();
        }
        if (_planungEUebernahme != null) {
            _elvis = _planungEUebernahme;
        } else {
            List _emptyList = Collections.emptyList();
            _elvis = _emptyList;
        }
        return _elvis;
    }

    public static Optional<String> getFuehrendeOertlichkeit(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _planungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _planungGruppe = PlanungProjektExtensions.getPlanungGruppe(_LSTPlanungProjekt);
        }
        Fuehrende_Oertlichkeit_TypeClass _fuehrendeOertlichkeit = null;
        if (_planungGruppe != null) {
            _fuehrendeOertlichkeit = _planungGruppe.getFuehrendeOertlichkeit();
        }
        String _wert = null;
        if (_fuehrendeOertlichkeit != null) {
            _wert = _fuehrendeOertlichkeit.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static Optional<String> getBemerkung(PlanPro_Schnittstelle schnittstelle) {
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg = null;
        if (schnittstelle != null) {
            _planProSchnittstelleAllg = schnittstelle.getPlanProSchnittstelleAllg();
        }
        Bemerkung_TypeClass _bemerkung = null;
        if (_planProSchnittstelleAllg != null) {
            _bemerkung = _planProSchnittstelleAllg.getBemerkung();
        }
        String _wert = null;
        if (_bemerkung != null) {
            _wert = _bemerkung.getWert();
        }
        return Optional.ofNullable(_wert);
    }

    public static boolean hasHandlung(PlanPro_Schnittstelle schnittstelle) {
        return !PlanProSchnittstelleExtensions.getPlanungAbnahme(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungErstellung(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungFreigabe(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungGenehmigung(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungGleichstellung(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungPruefung(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungQualitaetspruefung(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungUebernahme(schnittstelle).isEmpty() || !PlanProSchnittstelleExtensions.getPlanungSonstige(schnittstelle).isEmpty();
    }

    public static void updateErzeugung(PlanPro_Schnittstelle schnittstelle, String applicationName, EditingDomain domain) {
        try {
            Command cmd = SetCommand.create((EditingDomain)domain, (Object)schnittstelle.getPlanProSchnittstelleAllg().getWerkzeugName(), (Object)PlanProPackage.eINSTANCE.getWerkzeug_Name_TypeClass_Wert(), (Object)applicationName);
            domain.getCommandStack().execute(cmd);
            cmd = SetCommand.create((EditingDomain)domain, (Object)schnittstelle.getPlanProSchnittstelleAllg().getWerkzeugVersion(), (Object)PlanProPackage.eINSTANCE.getWerkzeug_Version_TypeClass_Wert(), (Object)ToolboxConfiguration.getToolboxVersion().getShortVersion());
            domain.getCommandStack().execute(cmd);
            DatatypeFactory _newInstance = DatatypeFactory.newInstance();
            GregorianCalendar _gregorianCalendar = new GregorianCalendar();
            cmd = SetCommand.create((EditingDomain)domain, (Object)schnittstelle.getPlanProSchnittstelleAllg().getErzeugungZeitstempel(), (Object)PlanProPackage.eINSTANCE.getErzeugung_Zeitstempel_TypeClass_Wert(), (Object)_newInstance.newXMLGregorianCalendar(_gregorianCalendar));
            domain.getCommandStack().execute(cmd);
        }
        catch (Throwable _t) {
            if (_t instanceof DatatypeConfigurationException) {
                DatatypeConfigurationException e = (DatatypeConfigurationException)_t;
                throw new RuntimeException(e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static Path getDerivedPath(PlanPro_Schnittstelle schnittstelle, String directory, String fileExtension, ExportType exportType) {
        String oertlichkeit = PlanProSchnittstelleExtensions.getFuehrendeOertlichkeit(schnittstelle).orElse("(oertlichkeit)");
        String index = PlanProSchnittstelleExtensions.getIndexAusgabe(schnittstelle).orElse("(index)");
        String lfdNummer = PlanProSchnittstelleExtensions.getLaufendeNummerAusgabe(schnittstelle).orElse("(lfdNummer)");
        String bauzustand = PlanProSchnittstelleExtensions.getBauzustandKurzbezeichnung(schnittstelle).orElse("(bauzustand)");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm");
        Function<XMLGregorianCalendar, String> _function = it -> {
            String _format = it.toGregorianCalendar().toZonedDateTime().format(formatter);
            return "_" + _format;
        };
        String timestamp = PlanProSchnittstelleExtensions.getErzeugungZeitstempel(schnittstelle).map(_function).orElse("");
        String filename = null;
        if (exportType == ExportType.INVENTORY_RECORDS) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(oertlichkeit);
            _builder.append("_");
            _builder.append(index);
            _builder.append("_");
            _builder.append(lfdNummer);
            _builder.append("_B_");
            _builder.append(bauzustand);
            _builder.append(timestamp);
            _builder.append(".");
            _builder.append(fileExtension);
            filename = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(oertlichkeit);
            _builder_1.append("_");
            _builder_1.append(index);
            _builder_1.append("_");
            _builder_1.append(lfdNummer);
            _builder_1.append("_");
            _builder_1.append(bauzustand);
            _builder_1.append(timestamp);
            _builder_1.append(".");
            _builder_1.append(fileExtension);
            filename = _builder_1.toString();
        }
        filename = filename.replaceAll("\\*", "");
        filename = filename.replaceAll("\\?", "");
        filename = filename.replaceAll(" ", "_");
        filename = filename.replaceAll("/", "-");
        filename = filename.replaceAll("\\\\", "-");
        filename = filename.replaceAll("\\|", "-");
        filename = filename.replaceAll(":", "-");
        filename = filename.replaceAll("<", "(");
        filename = filename.replaceAll(">", ")");
        return Paths.get(directory, filename);
    }

    public static Set<String> getGuids(PlanPro_Schnittstelle schnittstelle, ContainerType containerType) {
        Functions.Function1 _function = it -> it.getIdentitaet().getWert();
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)PlanProSchnittstelleExtensions.getContainer(schnittstelle, containerType).getUrObjekt(), (Functions.Function1)_function));
    }

    public static Planung_Projekt LSTPlanungProjekt(PlanPro_Schnittstelle schnittstelle) {
        return Services.getPlanningAccessService().getLSTPlanungProjekt(schnittstelle);
    }

    public static void setLSTPlanungProjekt(PlanPro_Schnittstelle schnittstelle, Planung_Projekt planungProject) {
        Services.getPlanningAccessService().setLSTPlanungProjekt(schnittstelle, planungProject);
    }

    private static void fixGuids(PlanPro_Schnittstelle schnittstelle) {
        Procedures.Procedure1 _function = it -> PlanProSchnittstelleExtensions.fixGuids(it);
        IteratorExtensions.forEach((Iterator)schnittstelle.getLSTPlanung().getObjektmanagement().eAllContents(), (Procedures.Procedure1)_function);
    }

    private static void fixGuids(EObject element) {
        String _wert;
        boolean _tripleEquals;
        boolean _greaterThan;
        Functions.Function1 _function = it -> {
            Class _instanceClass = it.getEType().getInstanceClass();
            return Objects.equals(_instanceClass, Identitaet_TypeClass.class);
        };
        Iterable idContainments = IterableExtensions.filter((Iterable)element.eClass().getEAllContainments(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)idContainments);
        if (_isEmpty) {
            return;
        }
        int _size = IterableExtensions.size((Iterable)idContainments);
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("size=");
            int _size_1 = IterableExtensions.size((Iterable)idContainments);
            _builder.append((Object)_size_1);
            throw new RuntimeException(_builder.toString());
        }
        EReference idRef = ((EReference[])Conversions.unwrapArray((Object)idContainments, EReference.class))[0];
        Object _eGet = element.eGet((EStructuralFeature)idRef);
        Identitaet_TypeClass value = (Identitaet_TypeClass)_eGet;
        if (value == null) {
            value = BasisobjekteFactory.eINSTANCE.createIdentitaet_TypeClass();
            element.eSet((EStructuralFeature)idRef, (Object)value);
        }
        boolean bl2 = _tripleEquals = (_wert = value.getWert()) == null;
        if (_tripleEquals) {
            value.setWert(Guid.create().toString());
        }
    }

    public static List<Anhang> getAttachments(PlanPro_Schnittstelle schnittstelle) {
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)schnittstelle.eAllContents(), Anhang.class));
    }

    public static PlanPro_Schnittstelle transformSingleState(PlanPro_Schnittstelle source) {
        boolean _isPlanning = PlanProSchnittstelleExtensions.isPlanning(source);
        if (_isPlanning) {
            return source;
        }
        LST_Zustand singleStateContainer = source.getLSTZustand();
        LST_Zustand copyContainer = (LST_Zustand)EcoreUtil.copy((EObject)singleStateContainer);
        PlanPro_Schnittstelle newSchnittstelle = PlanProSchnittstelleExtensions.createEmptyModel();
        Identitaet_TypeClass guid = BasisobjekteFactory.eINSTANCE.createIdentitaet_TypeClass();
        guid.setWert(source.getIdentitaet().getWert());
        newSchnittstelle.setIdentitaet(guid);
        Ausgabe_Fachdaten newAusgabeFachdaten = PlanungEinzelExtensions.getAusgabeFachdaten(PlanungProjektExtensions.getPlanungGruppe(PlanProSchnittstelleExtensions.LSTPlanungProjekt(newSchnittstelle)).getLSTPlanungEinzel());
        newAusgabeFachdaten.setLSTZustandStart(copyContainer);
        return newSchnittstelle;
    }
}

