/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.extensions;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.part.PartDescription;
import org.eclipse.set.basis.part.ViewVisibility;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class MApplicationElementExtensions {
    private static final String TOOLBOX_VIEW_STATE = "toolbox.view.state";
    private static final String TOOLBOX_VIEW_DESCRIPTION = "toolbox.view.description";
    private static final String TOOLBOX_VIEW_VISIBILITY = "toolbox.view.visibility";
    private static final String TOOLBOX_VIEW_MARK = "toolbox.view.mark";
    private static final String MARK_VALUE = "true";

    public static void setViewState(MApplicationElement element, ToolboxViewState state) {
        element.getTransientData().put(TOOLBOX_VIEW_STATE, state);
    }

    public static ToolboxViewState getViewState(MApplicationElement element) {
        Object _get = element.getTransientData().get(TOOLBOX_VIEW_STATE);
        ToolboxViewState value = (ToolboxViewState)((Object)_get);
        if (value == null) {
            return ToolboxViewState.UNKNOWN;
        }
        return value;
    }

    public static void resetViewState(MApplicationElement element) {
        element.getTransientData().remove(TOOLBOX_VIEW_STATE);
    }

    public static boolean isSuccessful(MApplicationElement element) {
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new ToolboxViewState[]{ToolboxViewState.UNKNOWN, ToolboxViewState.CREATED})).contains((Object)MApplicationElementExtensions.getViewState(element));
    }

    public static PartDescription getDescription(MApplicationElement element) {
        Object _get = element.getTransientData().get(TOOLBOX_VIEW_DESCRIPTION);
        return (PartDescription)_get;
    }

    public static void setDescription(MApplicationElement element, PartDescription description) {
        element.getTransientData().put(TOOLBOX_VIEW_DESCRIPTION, description);
    }

    public static ViewVisibility getVisibility(MApplicationElement element) {
        Object _get = element.getTransientData().get(TOOLBOX_VIEW_VISIBILITY);
        return (ViewVisibility)((Object)_get);
    }

    public static void setVisibility(MApplicationElement element, ViewVisibility visibility) {
        element.getTransientData().put(TOOLBOX_VIEW_VISIBILITY, visibility);
    }

    public static void markAsToolboxView(MApplicationElement element) {
        element.getTransientData().put(TOOLBOX_VIEW_MARK, MARK_VALUE);
    }

    public static boolean isToolboxView(MApplicationElement element) {
        Object mark_value;
        Map _transientData = null;
        if (element != null) {
            _transientData = element.getTransientData();
        }
        Object _get = null;
        if (_transientData != null) {
            _get = _transientData.get(TOOLBOX_VIEW_MARK);
        }
        if ((mark_value = _get) == null) {
            return false;
        }
        return Objects.equals(mark_value, MARK_VALUE);
    }

    public static boolean isOpenPart(MApplicationElement element) {
        if (element instanceof MPart) {
            return ((MPart)element).isVisible() && ((MPart)element).isToBeRendered();
        }
        return false;
    }
}

