/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.feature.siteplan.transform.SiteplanTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.model.siteplan.SiteplanObject;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.model.siteplan.SiteplanState;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSiteplanTransformator
implements SiteplanTransformator {
    private static final Logger logger = LoggerFactory.getLogger(SiteplanTransformator.class);

    @Override
    public Siteplan transform(IModelSession modelSession) {
        TransformUtils.transformThreads.clear();
        return this.transform(modelSession.getPlanProSchnittstelle());
    }

    public abstract SiteplanState transformState(MultiContainer_AttributeGroup var1);

    public abstract Position getLeadingPosition(PlanPro_Schnittstelle var1, MultiContainer_AttributeGroup var2);

    public Siteplan transform(PlanPro_Schnittstelle planproSchnittstelle) {
        Siteplan siteplan = SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplan();
        siteplan.setInitialState(SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState());
        siteplan.setCommonState(SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState());
        siteplan.setFinalState(SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState());
        siteplan.setChangedInitialState(SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState());
        siteplan.setChangedFinalState(SiteplanPackage.eINSTANCE.getSiteplanFactory().createSiteplanState());
        List<SiteplanMultiConainer> multiContainer = this.getMultiContainer(planproSchnittstelle);
        Functions.Function1 _function = it -> it.type == ContainerType.INITIAL;
        SiteplanMultiConainer _findFirst = (SiteplanMultiConainer)IterableExtensions.findFirst(multiContainer, (Functions.Function1)_function);
        MultiContainer_AttributeGroup _multiContainer = null;
        if (_findFirst != null) {
            _multiContainer = _findFirst.multiContainer;
        }
        MultiContainer_AttributeGroup initialLSTState = _multiContainer;
        Functions.Function1 _function_1 = it -> it.type == ContainerType.FINAL;
        SiteplanMultiConainer _findFirst_1 = (SiteplanMultiConainer)IterableExtensions.findFirst(multiContainer, (Functions.Function1)_function_1);
        MultiContainer_AttributeGroup _multiContainer_1 = null;
        if (_findFirst_1 != null) {
            _multiContainer_1 = _findFirst_1.multiContainer;
        }
        MultiContainer_AttributeGroup finalLSTState = _multiContainer_1;
        Functions.Function1 _function_2 = it -> it.type == ContainerType.SINGLE;
        SiteplanMultiConainer _findFirst_2 = (SiteplanMultiConainer)IterableExtensions.findFirst(multiContainer, (Functions.Function1)_function_2);
        MultiContainer_AttributeGroup _multiContainer_2 = null;
        if (_findFirst_2 != null) {
            _multiContainer_2 = _findFirst_2.multiContainer;
        }
        MultiContainer_AttributeGroup singleLSTState = _multiContainer_2;
        if (initialLSTState != null && finalLSTState != null) {
            Map state = Collections.synchronizedMap(CollectionLiterals.newHashMap());
            Functions.Function1 _function_3 = it -> it.type != ContainerType.SINGLE;
            Procedures.Procedure1 _function_4 = it -> {
                Map map2 = state;
                synchronized (map2) {
                    state.put(it.type, this.transformState(it.multiContainer));
                }
            };
            TransformUtils.createTransformatorThread(IterableExtensions.toList((Iterable)IterableExtensions.filter(multiContainer, (Functions.Function1)_function_3)), "TransformSiteplan", 2, _function_4);
            SiteplanState initialState = (SiteplanState)state.get(ContainerType.INITIAL);
            SiteplanState finalState = (SiteplanState)state.get(ContainerType.FINAL);
            EReference _siteplanState_Signals = SiteplanPackage.eINSTANCE.getSiteplanState_Signals();
            EReference _siteplanState_TrackSwitches = SiteplanPackage.eINSTANCE.getSiteplanState_TrackSwitches();
            EReference _siteplanState_TrackSwitchEndMarkers = SiteplanPackage.eINSTANCE.getSiteplanState_TrackSwitchEndMarkers();
            EReference _siteplanState_FmaComponents = SiteplanPackage.eINSTANCE.getSiteplanState_FmaComponents();
            EReference _siteplanState_Pzb = SiteplanPackage.eINSTANCE.getSiteplanState_Pzb();
            EReference _siteplanState_PzbGU = SiteplanPackage.eINSTANCE.getSiteplanState_PzbGU();
            EReference _siteplanState_Routes = SiteplanPackage.eINSTANCE.getSiteplanState_Routes();
            EReference _siteplanState_Stations = SiteplanPackage.eINSTANCE.getSiteplanState_Stations();
            EReference _siteplanState_TrackLock = SiteplanPackage.eINSTANCE.getSiteplanState_TrackLock();
            EReference _siteplanState_Tracks = SiteplanPackage.eINSTANCE.getSiteplanState_Tracks();
            EReference _siteplanState_TrackClosures = SiteplanPackage.eINSTANCE.getSiteplanState_TrackClosures();
            EReference _siteplanState_ExternalElementControls = SiteplanPackage.eINSTANCE.getSiteplanState_ExternalElementControls();
            EReference _siteplanState_Lockkeys = SiteplanPackage.eINSTANCE.getSiteplanState_Lockkeys();
            EReference _siteplanState_Cants = SiteplanPackage.eINSTANCE.getSiteplanState_Cants();
            EReference _siteplanState_UnknownObjects = SiteplanPackage.eINSTANCE.getSiteplanState_UnknownObjects();
            Consumer<EReference> _function_5 = it -> this.createDiffView(siteplan, initialState, finalState, (EReference)it);
            Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{_siteplanState_Signals, _siteplanState_TrackSwitches, _siteplanState_TrackSwitchEndMarkers, _siteplanState_FmaComponents, _siteplanState_Pzb, _siteplanState_PzbGU, _siteplanState_Routes, _siteplanState_Stations, _siteplanState_TrackLock, _siteplanState_Tracks, _siteplanState_TrackClosures, _siteplanState_ExternalElementControls, _siteplanState_Lockkeys, _siteplanState_Cants, _siteplanState_UnknownObjects})).forEach(_function_5);
            EList _errors = siteplan.getInitialState().getErrors();
            List _elvis = null;
            Functions.Function1 _function_6 = it -> (String)it.getRelevantGUIDs().get(0);
            List _sortBy = IterableExtensions.sortBy((Iterable)initialState.getErrors(), (Functions.Function1)_function_6);
            _elvis = _sortBy != null ? _sortBy : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _errors.addAll(_elvis);
            EList _errors_1 = siteplan.getFinalState().getErrors();
            List _elvis_1 = null;
            Functions.Function1 _function_7 = it -> (String)it.getRelevantGUIDs().get(0);
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)finalState.getErrors(), (Functions.Function1)_function_7);
            _elvis_1 = _sortBy_1 != null ? _sortBy_1 : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _errors_1.addAll(_elvis_1);
        } else if (singleLSTState != null) {
            siteplan.setCommonState(this.transformState(singleLSTState));
        }
        TransformUtils.transformPlanningRegion(siteplan, planproSchnittstelle);
        siteplan.setCenterPosition(this.getLeadingPosition(planproSchnittstelle, PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)planproSchnittstelle, (ContainerType)ContainerType.FINAL)));
        Functions.Function1 _function_8 = it -> it.isInterrupted();
        boolean _exists = IterableExtensions.exists(TransformUtils.transformThreads, (Functions.Function1)_function_8);
        if (_exists) {
            logger.warn("Transformator Cancel");
            return null;
        }
        return siteplan;
    }

    private List<SiteplanMultiConainer> getMultiContainer(PlanPro_Schnittstelle schnitstelle) {
        Functions.Function1 _function = it -> {
            MultiContainer_AttributeGroup _container = PlanProSchnittstelleExtensions.getContainer((PlanPro_Schnittstelle)schnitstelle, (ContainerType)it);
            return new SiteplanMultiConainer(_container, (ContainerType)it);
        };
        return ListExtensions.map((List)((List)Conversions.doWrapArray((Object)ContainerType.values())), (Functions.Function1)_function);
    }

    private void createDiffView(Siteplan siteplan, SiteplanState start, SiteplanState target, EReference ref) {
        Object _eGet = start.eGet((EStructuralFeature)ref);
        EList initialList = (EList)_eGet;
        Object _eGet_1 = target.eGet((EStructuralFeature)ref);
        EList finalList = (EList)_eGet_1;
        Object _eGet_2 = siteplan.getInitialState().eGet((EStructuralFeature)ref);
        EList siteplanInitialList = (EList)_eGet_2;
        Object _eGet_3 = siteplan.getCommonState().eGet((EStructuralFeature)ref);
        EList siteplanCommonList = (EList)_eGet_3;
        Object _eGet_4 = siteplan.getFinalState().eGet((EStructuralFeature)ref);
        EList siteplanFinalList = (EList)_eGet_4;
        Object _eGet_5 = siteplan.getChangedInitialState().eGet((EStructuralFeature)ref);
        EList siteplanChangedInitialList = (EList)_eGet_5;
        Object _eGet_6 = siteplan.getChangedFinalState().eGet((EStructuralFeature)ref);
        EList siteplanChangedFinalList = (EList)_eGet_6;
        Functions.Function1 _function = it -> it.getGuid();
        List<Pair<Pair, Pair>> diffObjects = this.createListDiff((List)initialList, (List)finalList, (Functions.Function1)_function);
        Consumer<Pair> _function_1 = it -> {
            boolean _tripleEquals;
            SiteplanObject _key = (SiteplanObject)it.getKey();
            boolean bl = _tripleEquals = _key == null;
            if (_tripleEquals) {
                siteplanFinalList.add((Object)((SiteplanObject)it.getValue()));
            } else {
                boolean _tripleEquals_1;
                SiteplanObject _value = (SiteplanObject)it.getValue();
                boolean bl2 = _tripleEquals_1 = _value == null;
                if (_tripleEquals_1) {
                    siteplanInitialList.add((Object)((SiteplanObject)it.getKey()));
                } else {
                    boolean _equals = EcoreUtil.equals((EObject)((EObject)it.getKey()), (EObject)((EObject)it.getValue()));
                    if (_equals) {
                        siteplanCommonList.add((Object)((SiteplanObject)it.getKey()));
                    } else {
                        siteplanChangedInitialList.add((Object)((SiteplanObject)it.getKey()));
                        siteplanChangedFinalList.add((Object)((SiteplanObject)it.getValue()));
                    }
                }
            }
        };
        diffObjects.forEach(_function_1);
    }

    private <T> List<Pair<T, T>> createListDiff(List<T> startList, List<T> targetList, Functions.Function1<T, String> keyFunc) {
        Pair _mappedTo;
        Object _next;
        Procedures.Procedure0 _function_2;
        boolean _not_1;
        boolean _not;
        ArrayList outList = CollectionLiterals.newArrayList();
        List start = IterableExtensions.sortBy(startList, keyFunc);
        List target = IterableExtensions.sortBy(targetList, keyFunc);
        Iterator startIt = start.iterator();
        Iterator targetIt = target.iterator();
        boolean _hasNext = targetIt.hasNext();
        boolean bl = _not = !_hasNext;
        if (_not) {
            Functions.Function1 _function = it -> Pair.of((Object)it, null);
            return ListExtensions.map((List)start, (Functions.Function1)_function);
        }
        boolean _hasNext_1 = startIt.hasNext();
        boolean bl2 = _not_1 = !_hasNext_1;
        if (_not_1) {
            Functions.Function1 _function_1 = it -> Pair.of(null, (Object)it);
            return ListExtensions.map((List)target, (Functions.Function1)_function_1);
        }
        Procedures.Procedure0 iterate = _function_2 = () -> {
            Object startValue = startIt.next();
            Object targetValue = targetIt.next();
            while (true) {
                boolean _lessThan;
                String targetGuid;
                String startGuid;
                boolean _greaterThan;
                boolean bl = _greaterThan = (startGuid = (String)keyFunc.apply(startValue)).compareTo(targetGuid = (String)keyFunc.apply(targetValue)) > 0;
                if (_greaterThan) {
                    Pair _mappedTo = Pair.of(null, targetValue);
                    outList.add(_mappedTo);
                    if (!startIt.hasNext() || !targetIt.hasNext()) {
                        return;
                    }
                    targetValue = targetIt.next();
                    continue;
                }
                boolean bl2 = _lessThan = startGuid.compareTo(targetGuid) < 0;
                if (_lessThan) {
                    Pair _mappedTo_1 = Pair.of(startValue, null);
                    outList.add(_mappedTo_1);
                    if (!startIt.hasNext() || !targetIt.hasNext()) {
                        return;
                    }
                    startValue = startIt.next();
                    continue;
                }
                Pair _mappedTo_2 = Pair.of(startValue, targetValue);
                outList.add(_mappedTo_2);
                if (!startIt.hasNext() || !targetIt.hasNext()) {
                    return;
                }
                startValue = startIt.next();
                targetValue = targetIt.next();
            }
        };
        iterate.apply();
        while (startIt.hasNext()) {
            _next = startIt.next();
            _mappedTo = Pair.of(_next, null);
            outList.add(_mappedTo);
        }
        while (targetIt.hasNext()) {
            _next = targetIt.next();
            _mappedTo = Pair.of(null, _next);
            outList.add(_mappedTo);
        }
        return outList;
    }

    @Override
    public void stopTransform() {
        try {
            Consumer<Thread> _function = it -> {
                boolean _isAlive = it.isAlive();
                if (_isAlive) {
                    it.interrupt();
                }
            };
            TransformUtils.transformThreads.forEach(_function);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static class SiteplanMultiConainer {
        private MultiContainer_AttributeGroup multiContainer;
        private ContainerType type;

        public SiteplanMultiConainer(MultiContainer_AttributeGroup container, ContainerType type) {
            this.multiContainer = container;
            this.type = type;
        }
    }
}

