/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.parts;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ToolboxViewState;
import org.eclipse.set.basis.extensions.MApplicationElementExtensions;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.siteplan.SiteplanService;
import org.eclipse.set.feature.plazmodel.check.CRSValid;
import org.eclipse.set.feature.siteplan.Messages;
import org.eclipse.set.feature.siteplan.SiteplanBrowser;
import org.eclipse.set.feature.siteplan.browserfunctions.GetSessionStateBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.JumpToSiteplanElementBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.JumpToSourceLineBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.LayoutChangeCRSBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.SelectFolderDialogBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.SiteplanLoadingStateBrowserFunction;
import org.eclipse.set.feature.siteplan.browserfunctions.TableSelectRowBrowserFunction;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.WebBrowser;
import org.eclipse.set.utils.events.FunctionalToolboxEventHandler;
import org.eclipse.set.utils.events.JumpToSiteplanEvent;
import org.eclipse.set.utils.events.NewTableTypeEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.swt.widgets.Composite;

public class WebSiteplanPart
extends BasePart {
    private JumpToSiteplanElementBrowserFunction signalSelectBrowserFunction;
    @Inject
    @Translation
    protected Messages messages;
    @Inject
    IEclipseContext applicationContext;
    @Inject
    ToolboxPartService partService;
    @Inject
    private DialogService dialogService;
    @Inject
    CacheService cacheService;
    @Inject
    SiteplanService siteplanService;
    ToolboxEventHandler<JumpToSiteplanEvent> selectRowEvent;
    private SiteplanBrowser webBrowser;

    @PostConstruct
    private void postConstruct() {
        this.selectRowEvent = new FunctionalToolboxEventHandler(this::handleEvent);
        ToolboxEvents.subscribe((IEventBroker)this.getBroker(), JumpToSiteplanEvent.class, this.selectRowEvent);
    }

    private void handleEvent(JumpToSiteplanEvent selectedRowEvent) {
        this.signalSelectBrowserFunction.execute(selectedRowEvent);
    }

    protected void handleNewTableType(NewTableTypeEvent e) {
        this.webBrowser.executeJavascript(String.format("%s()", "window.planproNewTableType"));
    }

    @PreDestroy
    private void preDestroyWebSiteplanPart() {
        ToolboxEvents.unsubscribe((IEventBroker)this.getBroker(), this.selectRowEvent);
        this.webBrowser.stop();
    }

    protected void createView(Composite parent) {
        this.getBroker().send("siteplan/open", (Object)Boolean.TRUE);
        if (!this.isCRSValid()) {
            MApplicationElementExtensions.setViewState((MApplicationElement)this.getToolboxPart(), (ToolboxViewState)ToolboxViewState.ERROR);
            this.getBroker().send("siteplan/open", (Object)Boolean.FALSE);
            return;
        }
        try {
            this.webBrowser = new SiteplanBrowser(parent, this.applicationContext, this.getToolboxShell(), this.getBroker());
        }
        catch (IOException e) {
            this.getBroker().send("siteplan/open", (Object)Boolean.FALSE);
            throw new RuntimeException(e);
        }
        this.registerJavascriptFunctions();
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(this.webBrowser.getControl());
        this.webBrowser.setUrl("https://toolbox/?");
    }

    private boolean isCRSValid() {
        CRSValid test = new CRSValid();
        IModelSession modelSession = (IModelSession)this.applicationContext.get(IModelSession.class);
        List listValid = test.run(modelSession);
        if (!listValid.isEmpty()) {
            String fileName = modelSession.getToolboxFile().getPath().toString();
            if (!this.dialogService.sitePlanError(this.getToolboxShell(), fileName)) {
                return false;
            }
        }
        return true;
    }

    private void registerJavascriptFunctions() {
        this.webBrowser.registerJSFunction(new TableSelectRowBrowserFunction((WebBrowser)this.webBrowser, "planproSelectTableRow", this.getBroker()));
        this.webBrowser.registerJSFunction(new SelectFolderDialogBrowserFunction(this.webBrowser, "planproSelectFolderDialog", this.getToolboxShell(), this.getDialogService()));
        this.webBrowser.registerJSFunction(new GetSessionStateBrowserFunction((WebBrowser)this.webBrowser, "planproGetSessionState", this.getModelSession()));
        this.webBrowser.registerJSFunction(new JumpToSourceLineBrowserFunction((WebBrowser)this.webBrowser, "planproJumpToTextView", this.getBroker(), this.partService));
        this.webBrowser.registerJSFunction(new LayoutChangeCRSBrowserFunction((WebBrowser)this.webBrowser, "planproChangeLayoutCRS", this.cacheService));
        this.webBrowser.registerJSFunction(new SiteplanLoadingStateBrowserFunction((WebBrowser)this.webBrowser, "planproSiteplanLoadingState", this.getBroker()));
        this.signalSelectBrowserFunction = new JumpToSiteplanElementBrowserFunction(this.siteplanService, (WebBrowser)this.webBrowser);
    }
}

