/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.xlsx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.runtime.Assert;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.table.TableSpanUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ExcelExportBuilder
implements TableExport {
    private static final Logger logger = LoggerFactory.getLogger(ExcelExportBuilder.class);
    private static final String TEMPLATE_DIR = "./data/export/excel";

    private static int getFirstRowForContent(Sheet sheet) {
        return ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)sheet) + 1;
    }

    private static Table getTableToBeExported(Map<TableType, Table> tables) {
        Table invTable = tables.get(TableType.FINAL);
        if (invTable != null) {
            return invTable;
        }
        return tables.get(TableType.SINGLE);
    }

    static String[] getColumnHeaders(Sheet sheet) {
        Row row = sheet.getRow(0);
        int maxColIx = ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)sheet);
        ArrayList<String> headers = new ArrayList<String>();
        int colIx = 1;
        while (colIx <= maxColIx) {
            Optional cell = ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)row.getRowNum(), (int)colIx);
            Optional cellStringValue = ExcelWorkbookExtension.getCellStringValue((Optional)cell);
            if (cellStringValue.isPresent()) {
                headers.add((String)cellStringValue.get());
            }
            ++colIx;
        }
        return headers.toArray(new String[0]);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
        Table table = ExcelExportBuilder.getTableToBeExported(tables);
        Path templatePath = Paths.get(TEMPLATE_DIR, shortcut + "_vorlage.xlsx");
        Path outputPath = toolboxPaths.getTableExportPath(shortcut, Paths.get(outputDir, new String[0]), exportType, ToolboxPaths.ExportPathExtension.TABLE_XLSX_EXPORT_EXTENSION);
        try {
            Throwable throwable = null;
            Object var14_16 = null;
            try {
                XSSFWorkbook workbook;
                FileInputStream inputStream;
                block26: {
                    block27: {
                        inputStream = new FileInputStream(templatePath.toFile());
                        workbook = new XSSFWorkbook((InputStream)inputStream);
                        if (overwriteHandling.test(outputPath)) break block26;
                        if (workbook == null) break block27;
                        workbook.close();
                    }
                    if (inputStream == null) return;
                    inputStream.close();
                    return;
                }
                try {
                    block28: {
                        Sheet sheet = workbook.getSheetAt(0);
                        String[] headers = ExcelExportBuilder.getColumnHeaders(sheet);
                        int columnCount = headers.length;
                        int rowIndex = ExcelExportBuilder.getFirstRowForContent(sheet);
                        logger.info("exporting table = {}", (Object)templatePath);
                        List rows = TableExtensions.getTableRows((Table)table);
                        ExcelExportBuilder.fillSheet(sheet, rows, rowIndex, columnCount);
                        ExcelExportBuilder.addTableSpans(sheet, rows, rowIndex, columnCount);
                        Path outputDirPath = outputPath.getParent();
                        Assert.isNotNull((Object)outputDirPath);
                        FileUtils.forceMkdir((File)outputDirPath.toFile());
                        Throwable throwable2 = null;
                        Object var24_29 = null;
                        try (FileOutputStream fileOut = new FileOutputStream(outputPath.toString());){
                            workbook.write((OutputStream)fileOut);
                            break block28;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        {
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                        }
                        finally {
                            if (workbook != null) {
                                workbook.close();
                            }
                        }
                    }
                    if (inputStream == null) return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return;
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                } else {
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new FileExportException(outputPath, (Throwable)e);
        }
    }

    private static void fillSheet(Sheet sheet, List<TableRow> rows, int rowIndex, int columnCount) {
        int contentRowIndex = rowIndex;
        for (TableRow row : rows) {
            Row sheetRow = contentRowIndex == rowIndex ? sheet.getRow(contentRowIndex) : ExcelExportBuilder.createNewRow(sheet, contentRowIndex, columnCount);
            int i = 0;
            while (i < columnCount) {
                String content = TableRowExtensions.getPlainStringValue((TableRow)row, (int)i);
                Cell cell = sheetRow.getCell(i + 1);
                if (cell == null) {
                    cell = sheetRow.createCell(i + 1);
                }
                cell.setCellValue(content);
                ++i;
            }
            sheetRow.setHeight((short)-1);
            ++contentRowIndex;
        }
    }

    private static Row createNewRow(Sheet sheet, int rowIndex, int maxColIndex) {
        Row cloneRow = sheet.createRow(rowIndex);
        Workbook workbook = sheet.getWorkbook();
        int i = 0;
        while (i <= maxColIndex) {
            Optional cellAt = ExcelWorkbookExtension.getCellAt((Sheet)sheet, (int)(rowIndex - 1), (int)i);
            Cell newCell = cloneRow.createCell(i);
            if (cellAt.isPresent()) {
                CellStyle cloneStyle = workbook.createCellStyle();
                cloneStyle.cloneStyleFrom(((Cell)cellAt.get()).getCellStyle());
                cloneStyle.setBorderTop(BorderStyle.NONE);
                cloneStyle.setBorderBottom(BorderStyle.NONE);
                newCell.setCellStyle(cloneStyle);
            }
            ++i;
        }
        return cloneRow;
    }

    private static void addTableSpans(Sheet sheet, List<TableRow> rows, int rowIndex, int columnCount) {
        int sheetRowIndex = rowIndex;
        TableSpanUtils spanUtils = new TableSpanUtils(rows);
        int row = 0;
        while (row < rows.size()) {
            int column = 0;
            while (column < columnCount) {
                if (spanUtils.isMergeAllowed(column, row)) {
                    int spanUp = spanUtils.getRowSpanUp(column, row);
                    int spanDown = spanUtils.getRowSpanDown(column, row);
                    if (spanUp <= 0 && spanDown != 0) {
                        sheet.addMergedRegion(new CellRangeAddress(sheetRowIndex + row, sheetRowIndex + row + spanDown, column, column));
                    }
                }
                ++column;
            }
            ++sheetRowIndex;
            ++row;
        }
    }

    public void exportTitleboxImage(Titlebox titlebox, Path path, OverwriteHandling overwriteHandling) {
    }

    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
    }
}

