/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.parts;

import jakarta.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.services.export.AdditionalExportService;
import org.eclipse.set.core.services.export.CheckboxModelElement;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.export.parts.DocumentExportPart;
import org.eclipse.set.feature.table.TableService;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToFreeFieldTransformation;
import org.eclipse.set.ppmodel.extensions.utils.PlanProToTitleboxTransformation;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.exception.ExceptionHandler;

public abstract class PlanProExportPart
extends DocumentExportPart {
    @Inject
    @Optional
    private AdditionalExportService additionalExportService;
    @Inject
    ToolboxPartService toolboxPartService;

    @Inject
    public PlanProExportPart() {
    }

    @Override
    protected CheckboxModelElement[] createCheckboxModelElements() {
        ArrayList<String> shortCuts = new ArrayList<String>(this.tableService.getAvailableTables().stream().map(TableService.TableInfo::shortcut).toList());
        Collections.sort(shortCuts);
        ArrayList<CheckboxModelElement> elements = new ArrayList<CheckboxModelElement>(shortCuts.stream().map(arg_0 -> ((TableService)this.tableService).getTableNameInfo(arg_0)).map(info -> new CheckboxModelElement(info.getShortName().toLowerCase(), info.getFullDisplayName())).toList());
        if (this.additionalExportService != null) {
            this.additionalExportService.createAdditionalCheckboxModelElements(elements);
        }
        return elements.toArray(new CheckboxModelElement[0]);
    }

    private Path getAttachmentPath(String guid) {
        try {
            return this.getModelSession().getToolboxFile().getMediaPath(Guid.create((String)guid));
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    protected void export(CheckboxModelElement element, IModelSession modelSession, OverwriteHandling overwriteHandling, IProgressMonitor monitor) {
        String id = element.getId();
        if (this.additionalExportService != null && this.additionalExportService.isAdditionalExportId(id)) {
            this.additionalExportService.createAdditionalExport(id, modelSession, monitor, this.getSelectedDirectory(), this.getExportType(), overwriteHandling);
        } else {
            Map tables = this.compileService.compile(id, modelSession, modelSession.getSelectedControlAreas().stream().map(Pair::getSecond).collect(Collectors.toSet()));
            PlanProToTitleboxTransformation planProToTitlebox = PlanProToTitleboxTransformation.create();
            Titlebox titlebox = planProToTitlebox.transform(modelSession.getPlanProSchnittstelle(), this.tableService.getTableNameInfo(id), this::getAttachmentPath);
            this.updateTitlebox(titlebox);
            PlanProToFreeFieldTransformation planProToFreeField = PlanProToFreeFieldTransformation.create();
            FreeFieldInfo freeFieldInfo = planProToFreeField.transform(modelSession);
            this.exportService.export(tables, this.getExportType(), titlebox, freeFieldInfo, id, this.getSelectedDirectory().toString(), modelSession.getToolboxPaths(), modelSession.getTableType(), overwriteHandling, (Consumer)new ExceptionHandler(this.getToolboxShell(), this.getDialogService()));
        }
    }

    protected abstract ExportType getExportType();

    @Override
    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    @Override
    protected String getTaskMessage() {
        return this.messages.exportTable_message;
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected abstract void updateTitlebox(Titlebox var1);

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.setOutdated(false);
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.setOutdated(false);
    }
}

