/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;

public class EMapKeySerializer
extends JsonSerializer<Object> {
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        EStructuralFeature feature = EMFContext.getFeature((DatabindContext)serializers);
        Optional<EReference> mapRef = Optional.ofNullable(feature).filter(EReference.class::isInstance).map(EReference.class::cast);
        Optional<EStructuralFeature> keyFeature = mapRef.map(EReference::getEReferenceType).map(mapType -> mapType.getEStructuralFeature("key")).filter(Objects::nonNull);
        Optional<EDataType> keyType = keyFeature.filter(EAttribute.class::isInstance).map(EAttribute.class::cast).map(EAttribute::getEAttributeType);
        if (keyType.isPresent()) {
            gen.writeFieldName(EcoreUtil.convertToString((EDataType)keyType.get(), (Object)value));
        } else {
            gen.writeFieldName(value.toString());
        }
    }
}

