/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.version;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.set.core.services.version.PlanProVersionService;
import org.eclipse.set.model.validationreport.ValidationreportFactory;
import org.eclipse.set.model.validationreport.VersionInfo;
import org.eclipse.set.ppmodel.extensions.PlanProPackageExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffeRil301PackageExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class PlanProVersionServiceImpl
implements PlanProVersionService {
    private static final String DELIMITER = "";
    private static final String KEY_VALUE_PATTERN = ".*xmlns:.*=\\s*['\"](%s[^'\" ]+)['\"].*";
    private static final String PLAN_PRO_KEY = "http://www.plan-pro.org/modell/PlanPro/";
    private static final String SIGNALS_KEY = "http://www.plan-pro.org/modell/Signalbegriffe_Ril_301/";
    private static final int VALUE_GROUP = 1;

    private static String getText(Path location) {
        List<String> lines;
        try {
            lines = Files.readAllLines(location);
        }
        catch (IOException e) {
            return DELIMITER;
        }
        List<String> subList = lines.subList(0, Math.min(10, lines.size()));
        return subList.stream().collect(Collectors.joining(DELIMITER));
    }

    private static String parseVersion(String text, String key) {
        Pattern p = Pattern.compile(String.format(KEY_VALUE_PATTERN, key));
        Matcher m = p.matcher(text);
        if (m.matches()) {
            String fullVersion = m.group(1);
            return fullVersion.substring(fullVersion.lastIndexOf(47) + 1);
        }
        return null;
    }

    public VersionInfo createSupportedVersion() {
        VersionInfo versionInfo = ValidationreportFactory.eINSTANCE.createVersionInfo();
        versionInfo.setPlanPro(PlanProPackageExtensions.getModelVersion());
        versionInfo.setSignals(SignalbegriffeRil301PackageExtensions.getModelVersion());
        return versionInfo;
    }

    public VersionInfo createUsedVersion(Path location) {
        VersionInfo versionInfo = ValidationreportFactory.eINSTANCE.createVersionInfo();
        String text = PlanProVersionServiceImpl.getText(location);
        String planProVersion = PlanProVersionServiceImpl.parseVersion(text, PLAN_PRO_KEY);
        versionInfo.setPlanPro(planProVersion != null ? planProVersion : DELIMITER);
        versionInfo.setSignals(PlanProVersionServiceImpl.parseVersion(text, SIGNALS_KEY));
        return versionInfo;
    }
}

