/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Pool;

public class CompoundPool<P>
implements Pool<P> {
    private final Pool<P> primaryPool;
    private final Pool<P> secondaryPool;

    public CompoundPool(Pool<P> primaryPool, Pool<P> secondaryPool) {
        this.primaryPool = primaryPool;
        this.secondaryPool = secondaryPool;
    }

    public Pool.Entry<P> reserve() {
        Pool.Entry primary = this.primaryPool.reserve();
        return primary != null ? primary : this.secondaryPool.reserve();
    }

    public Pool.Entry<P> acquire() {
        Pool.Entry primary = this.primaryPool.acquire();
        return primary != null ? primary : this.secondaryPool.acquire();
    }

    public boolean isTerminated() {
        return this.primaryPool.isTerminated();
    }

    public Collection<Pool.Entry<P>> terminate() {
        ArrayList<Pool.Entry<P>> entries = new ArrayList<Pool.Entry<P>>();
        entries.addAll(this.primaryPool.terminate());
        entries.addAll(this.secondaryPool.terminate());
        return entries;
    }

    public int size() {
        return this.primaryPool.size() + this.secondaryPool.size();
    }

    public int getMaxSize() {
        return this.primaryPool.getMaxSize() + this.secondaryPool.getMaxSize();
    }

    public Stream<Pool.Entry<P>> stream() {
        return Stream.concat(this.primaryPool.stream(), this.secondaryPool.stream());
    }
}

