/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.branding;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.branding.Header;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.URLHelper;
import org.eclipse.rwt.service.IApplicationStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrandingUtil {
    private static final String ATTR_CURRENT_BRANDING_ID = String.valueOf(BrandingUtil.class.getName()) + "#currentBrandingId";
    private static final String ATTR_REG_BRANDINGS = String.valueOf(BrandingUtil.class.getName()) + "#registeredBrandings";
    private static final Object LOCK = new Object();

    public static String headerMarkup(AbstractBranding branding) {
        StringBuilder buffer = new StringBuilder();
        BrandingUtil.appendFavIconMarkup(buffer, branding);
        BrandingUtil.appendHeaderMarkup(buffer, branding);
        return buffer.toString();
    }

    private static void appendFavIconMarkup(StringBuilder buffer, AbstractBranding branding) {
        String favIcon = branding.getFavIcon();
        if (favIcon != null && !"".equals(favIcon)) {
            Header header = BrandingUtil.createHeaderForFavIcon(favIcon);
            buffer.append(BrandingUtil.createMarkupForHeaders(header));
        }
    }

    private static void appendHeaderMarkup(StringBuilder buffer, AbstractBranding branding) {
        Header[] headers = branding.getHeaders();
        if (headers != null) {
            buffer.append(BrandingUtil.createMarkupForHeaders(headers));
        }
    }

    public static Header createHeaderForFavIcon(String favIcon) {
        String[] names = new String[]{"rel", "type", "href"};
        String favIconUrl = RWT.getResourceManager().getLocation(favIcon);
        String[] values = new String[]{"shortcut icon", "image/x-icon", favIconUrl};
        return new Header("link", names, values);
    }

    public static String createMarkupForHeaders(Header ... headers) {
        StringBuilder buffer = new StringBuilder();
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            BrandingUtil.appendHeaderMarkup(buffer, header);
            ++n2;
        }
        return buffer.toString();
    }

    private static String appendHeaderMarkup(StringBuilder buffer, Header header) {
        buffer.append("<");
        buffer.append(header.getTagName());
        buffer.append(" ");
        String[] names = header.getNames();
        String[] values = header.getValues();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = values[i];
            if (name != null && value != null) {
                buffer.append(name);
                buffer.append("=\"");
                buffer.append(value);
                buffer.append("\" ");
            }
            ++i;
        }
        buffer.append("/>\n");
        return buffer.toString();
    }

    public static AbstractBranding determineBranding() {
        HttpServletRequest request = ContextProvider.getRequest();
        String servletName = URLHelper.getServletName();
        String entryPoint = request.getParameter("startup");
        AbstractBranding result = RWTFactory.getBrandingManager().find(servletName, entryPoint);
        RWT.getSessionStore().setAttribute(ATTR_CURRENT_BRANDING_ID, result.getId());
        return result;
    }

    public static String getCurrentBrandingId() {
        return (String)RWT.getSessionStore().getAttribute(ATTR_CURRENT_BRANDING_ID);
    }

    public static void registerResources(AbstractBranding branding) throws IOException {
        if (BrandingUtil.needsRegistration(branding)) {
            branding.registerResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean needsRegistration(AbstractBranding branding) {
        boolean result;
        Set<AbstractBranding> registeredBrandings = BrandingUtil.getRegisteredBrandings();
        Object object = LOCK;
        synchronized (object) {
            result = registeredBrandings.add(branding);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<AbstractBranding> getRegisteredBrandings() {
        HashSet<AbstractBranding> result;
        IApplicationStore store = RWT.getApplicationStore();
        Object object = LOCK;
        synchronized (object) {
            result = (HashSet<AbstractBranding>)store.getAttribute(ATTR_REG_BRANDINGS);
            if (result == null) {
                result = new HashSet<AbstractBranding>();
                store.setAttribute(ATTR_REG_BRANDINGS, result);
            }
        }
        return result;
    }

    private BrandingUtil() {
    }
}

