/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.rap.rwt.internal.theme.QxAnimation;
import org.eclipse.rap.rwt.internal.theme.QxBorder;
import org.eclipse.rap.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxCursor;
import org.eclipse.rap.rwt.internal.theme.QxDimension;
import org.eclipse.rap.rwt.internal.theme.QxFloat;
import org.eclipse.rap.rwt.internal.theme.QxFont;
import org.eclipse.rap.rwt.internal.theme.QxIdentifier;
import org.eclipse.rap.rwt.internal.theme.QxImage;
import org.eclipse.rap.rwt.internal.theme.QxShadow;
import org.eclipse.rap.rwt.internal.theme.QxType;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.w3c.css.sac.LexicalUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyResolver {
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String NORMAL = "normal";
    private static final String NONE = "none";
    private static final String HIDDEN = "hidden";
    private static final String DOTTED = "dotted";
    private static final String DASHED = "dashed";
    private static final String SOLID = "solid";
    private static final String DOUBLE = "double";
    private static final String GROOVE = "groove";
    private static final String RIDGE = "ridge";
    private static final String INSET = "inset";
    private static final String OUTSET = "outset";
    private static final String THIN = "thin";
    private static final String MEDIUM = "medium";
    private static final String THICK = "thick";
    private static final String TRANSPARENT = "transparent";
    private static final Map<String, NamedColor> NAMED_COLORS = new HashMap<String, NamedColor>();
    private static final List<String> BORDER_STYLES = new ArrayList<String>();
    static final int THIN_VALUE = 1;
    static final int MEDIUM_VALUE = 3;
    static final int THICK_VALUE = 5;

    static {
        NAMED_COLORS.put("black", new NamedColor(0, 0, 0));
        NAMED_COLORS.put("gray", new NamedColor(128, 128, 128));
        NAMED_COLORS.put("silver", new NamedColor(192, 192, 192));
        NAMED_COLORS.put("white", new NamedColor(255, 255, 255));
        NAMED_COLORS.put("maroon", new NamedColor(128, 0, 0));
        NAMED_COLORS.put("red", new NamedColor(255, 0, 0));
        NAMED_COLORS.put("purple", new NamedColor(128, 0, 128));
        NAMED_COLORS.put("fuchsia", new NamedColor(255, 0, 255));
        NAMED_COLORS.put("green", new NamedColor(0, 128, 0));
        NAMED_COLORS.put("lime", new NamedColor(0, 255, 0));
        NAMED_COLORS.put("navy", new NamedColor(0, 0, 128));
        NAMED_COLORS.put("blue", new NamedColor(0, 0, 255));
        NAMED_COLORS.put("olive", new NamedColor(128, 128, 0));
        NAMED_COLORS.put("yellow", new NamedColor(255, 255, 0));
        NAMED_COLORS.put("teal", new NamedColor(0, 128, 128));
        NAMED_COLORS.put("aqua", new NamedColor(0, 255, 255));
        BORDER_STYLES.add(NONE);
        BORDER_STYLES.add(HIDDEN);
        BORDER_STYLES.add(DOTTED);
        BORDER_STYLES.add(DASHED);
        BORDER_STYLES.add(SOLID);
        BORDER_STYLES.add(DOUBLE);
        BORDER_STYLES.add(GROOVE);
        BORDER_STYLES.add(RIDGE);
        BORDER_STYLES.add(INSET);
        BORDER_STYLES.add(OUTSET);
    }

    public static QxType resolveProperty(String name, LexicalUnit unit, ResourceLoader loader) {
        QxType result;
        if (PropertyResolver.isBorderProperty(name)) {
            result = PropertyResolver.readBorder(unit);
        } else if (PropertyResolver.isBoxDimensionProperty(name)) {
            result = PropertyResolver.readBoxDimensions(unit);
        } else if (PropertyResolver.isColorProperty(name)) {
            result = PropertyResolver.readColor(unit);
        } else if (PropertyResolver.isDimensionProperty(name)) {
            result = PropertyResolver.readDimension(unit);
        } else if (PropertyResolver.isFontProperty(name)) {
            result = PropertyResolver.readFont(unit);
        } else if (PropertyResolver.isImageProperty(name)) {
            result = PropertyResolver.readBackgroundImage(unit, loader);
        } else if (PropertyResolver.isBackgroundRepeatProperty(name)) {
            result = PropertyResolver.readBackgroundRepeat(unit);
        } else if (PropertyResolver.isBackgroundPositionProperty(name)) {
            result = PropertyResolver.readBackgroundPosition(unit);
        } else if (PropertyResolver.isTextDecorationProperty(name)) {
            result = PropertyResolver.readTextDecoration(unit);
        } else if (PropertyResolver.isTextAlignProperty(name)) {
            result = PropertyResolver.readTextAlign(unit);
        } else if (PropertyResolver.isCursorProperty(name)) {
            result = PropertyResolver.readCursor(unit, loader);
        } else if (PropertyResolver.isFloatProperty(name)) {
            result = PropertyResolver.readFloat(unit);
        } else if (PropertyResolver.isAnimationProperty(name)) {
            result = PropertyResolver.readAnimation(unit);
        } else if (PropertyResolver.isShadowProperty(name)) {
            result = PropertyResolver.readShadow(unit);
        } else {
            throw new IllegalArgumentException("Unknown property " + name);
        }
        return result;
    }

    static boolean isColorProperty(String property) {
        return "color".equals(property) || property.endsWith("-color");
    }

    static QxColor readColor(LexicalUnit unit) {
        QxColor result = null;
        short type = unit.getLexicalUnitType();
        if (type == 27) {
            result = PropertyResolver.readColorRgb(unit);
        } else if (type == 41 && "rgba".equals(unit.getFunctionName())) {
            result = PropertyResolver.readColorRgba(unit);
        } else {
            if (type == 41 && "rgb".equals(unit.getFunctionName())) {
                throw new IllegalArgumentException("Failed to parse rgb() function");
            }
            if (type == 35) {
                result = PropertyResolver.readColorNamed(unit);
            } else if (type == 12) {
                result = QxColor.TRANSPARENT;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse color " + PropertyResolver.toString(unit));
        }
        return result;
    }

    private static QxColor readColorNamed(LexicalUnit unit) {
        QxColor result = null;
        String string = unit.getStringValue();
        String lowerCaseString = string.toLowerCase(Locale.ENGLISH);
        if (TRANSPARENT.equals(string)) {
            result = QxColor.TRANSPARENT;
        } else if (NAMED_COLORS.containsKey(lowerCaseString)) {
            NamedColor color = NAMED_COLORS.get(lowerCaseString);
            result = QxColor.create(color.red, color.green, color.blue);
        }
        return result;
    }

    private static QxColor readColorRgb(LexicalUnit unit) {
        QxColor result = null;
        LexicalUnit redParam = unit.getParameters();
        LexicalUnit greenParam = redParam.getNextLexicalUnit().getNextLexicalUnit();
        LexicalUnit blueParam = greenParam.getNextLexicalUnit().getNextLexicalUnit();
        short valueType = redParam.getLexicalUnitType();
        if (greenParam.getLexicalUnitType() == valueType || blueParam.getLexicalUnitType() == valueType) {
            if (valueType == 13) {
                int red = PropertyResolver.normalizeRGBValue(redParam.getIntegerValue());
                int green = PropertyResolver.normalizeRGBValue(greenParam.getIntegerValue());
                int blue = PropertyResolver.normalizeRGBValue(blueParam.getIntegerValue());
                result = QxColor.create(red, green, blue);
            } else if (valueType == 23) {
                float redPercent = PropertyResolver.normalizePercentValue(redParam.getFloatValue());
                float greenPercent = PropertyResolver.normalizePercentValue(greenParam.getFloatValue());
                float bluePercent = PropertyResolver.normalizePercentValue(blueParam.getFloatValue());
                int red = (int)(255.0f * redPercent / 100.0f);
                int green = (int)(255.0f * greenPercent / 100.0f);
                int blue = (int)(255.0f * bluePercent / 100.0f);
                result = QxColor.create(red, green, blue);
            }
        }
        return result;
    }

    static QxColor readColorRgba(LexicalUnit unit) {
        QxColor result = null;
        int[] values = new int[3];
        float alpha = 1.0f;
        short type = unit.getLexicalUnitType();
        LexicalUnit nextUnit = unit.getParameters();
        boolean ok = nextUnit != null;
        boolean mixedTypes = false;
        short previousType = -1;
        int pos = 0;
        while (ok) {
            type = nextUnit.getLexicalUnitType();
            if (pos == 0 || pos == 2 || pos == 4) {
                if (type == 13) {
                    values[pos / 2] = PropertyResolver.normalizeRGBValue(nextUnit.getIntegerValue());
                } else if (type == 23) {
                    float percentValue = PropertyResolver.normalizePercentValue(nextUnit.getFloatValue());
                    values[pos / 2] = (int)(255.0f * percentValue / 100.0f);
                } else {
                    ok = false;
                }
                mixedTypes = previousType != -1 && previousType != type;
                previousType = type;
            } else if (pos == 1 || pos == 3 || pos == 5) {
                if (type != 0) {
                    ok = false;
                }
            } else if (pos == 6) {
                if (type == 14) {
                    alpha = PropertyResolver.normalizeAlphaValue(nextUnit.getFloatValue());
                } else {
                    ok = false;
                }
            }
            nextUnit = nextUnit.getNextLexicalUnit();
            ok &= nextUnit != null && ++pos < 7 && !mixedTypes;
        }
        if (pos == 7) {
            result = QxColor.create(values[0], values[1], values[2], alpha);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse rgba color");
        }
        return result;
    }

    static boolean isDimensionProperty(String property) {
        return "spacing".equals(property) || "width".equals(property) || "height".equals(property) || "min-height".equals(property);
    }

    static QxDimension readDimension(LexicalUnit unit) {
        QxDimension result = null;
        Integer length = PropertyResolver.readSingleLengthUnit(unit);
        if (length != null) {
            result = QxDimension.create(length);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse dimension " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isBorderProperty(String property) {
        return "border".equals(property) || "border-left".equals(property) || "border-bottom".equals(property);
    }

    static QxBorder readBorder(LexicalUnit unit) {
        QxBorder result = null;
        QxColor color = null;
        String style = null;
        int width = -1;
        LexicalUnit nextUnit = unit;
        boolean consumed = false;
        while (nextUnit != null) {
            consumed = false;
            if (!consumed && width == -1) {
                width = PropertyResolver.readBorderWidth(nextUnit);
                consumed |= width != -1;
            }
            if (!consumed && style == null) {
                style = PropertyResolver.readBorderStyle(nextUnit);
                consumed |= style != null;
            }
            if (!consumed && color == null) {
                color = PropertyResolver.readColor(nextUnit);
                consumed |= color != null;
            }
            LexicalUnit lexicalUnit = nextUnit = consumed ? nextUnit.getNextLexicalUnit() : null;
        }
        if (consumed) {
            result = QxBorder.create(width == -1 ? 0 : width, style, color != null ? color.toDefaultString() : null);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse border " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isBoxDimensionProperty(String property) {
        return "padding".equals(property) || "margin".equals(property) || "border-radius".equals(property);
    }

    static QxBoxDimensions readBoxDimensions(LexicalUnit unit) {
        QxBoxDimensions result = null;
        Integer value1 = PropertyResolver.readSingleLengthUnit(unit);
        if (value1 != null) {
            int left;
            int bottom = left = value1.intValue();
            int right = left;
            int top = left;
            LexicalUnit nextUnit = unit.getNextLexicalUnit();
            boolean ok = true;
            int pos = 1;
            while (nextUnit != null && ok) {
                Integer nextValue = PropertyResolver.readSingleLengthUnit(nextUnit);
                if (ok &= nextValue != null && ++pos <= 4) {
                    if (pos == 2) {
                        right = left = nextValue.intValue();
                    } else if (pos == 3) {
                        bottom = nextValue;
                    } else if (pos == 4) {
                        left = nextValue;
                    }
                }
                nextUnit = nextUnit.getNextLexicalUnit();
            }
            if (ok &= nextUnit == null) {
                result = QxBoxDimensions.create(top, right, bottom, left);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse box dimensions " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static String readBorderStyle(LexicalUnit unit) {
        String string;
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35 && BORDER_STYLES.contains(string = unit.getStringValue())) {
            result = string;
        }
        return result;
    }

    static int readBorderWidth(LexicalUnit unit) {
        float value;
        int result = -1;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String string = unit.getStringValue();
            if (THIN.equals(string)) {
                result = 1;
            } else if (MEDIUM.equals(string)) {
                result = 3;
            } else if (THICK.equals(string)) {
                result = 5;
            }
        } else if (type == 13) {
            int value2 = unit.getIntegerValue();
            if (value2 == 0) {
                result = 0;
            }
        } else if (type == 17 && (value = unit.getFloatValue()) >= 0.0f) {
            result = Math.round(value);
        }
        return result;
    }

    static boolean isFontProperty(String property) {
        return "font".equals(property) || property.endsWith("-fontlist");
    }

    static QxFont readFont(LexicalUnit unit) {
        QxFont result = null;
        String[] family = null;
        String style = null;
        String weight = null;
        int size = -1;
        boolean consumed = false;
        boolean consumedSize = false;
        boolean consumedFamily = false;
        LexicalUnit nextUnit = unit;
        while (nextUnit != null && !consumedFamily) {
            consumed = false;
            if (!consumed && !consumedSize && style == null) {
                style = PropertyResolver.readFontStyle(nextUnit);
                consumed |= style != null;
            }
            if (!consumed && !consumedSize && weight == null) {
                weight = PropertyResolver.readFontWeight(nextUnit);
                consumed |= weight != null;
            }
            if (!consumed && !consumedFamily && size == -1) {
                size = PropertyResolver.readFontSize(nextUnit);
                consumedSize = size != -1;
                consumed |= consumedSize;
            }
            if (!consumed && consumedSize && family == null) {
                family = PropertyResolver.readFontFamily(nextUnit);
                consumedFamily = family != null;
                consumed |= consumedFamily;
            }
            LexicalUnit lexicalUnit = nextUnit = consumed ? nextUnit.getNextLexicalUnit() : null;
        }
        if (consumed && consumedSize && consumedFamily) {
            boolean bold = BOLD.equals(weight);
            boolean italic = ITALIC.equals(style);
            result = QxFont.create(family, size, bold, italic);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse font " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static String readFontStyle(LexicalUnit unit) {
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if (NORMAL.equals(value)) {
                result = value;
            } else if (ITALIC.equals(value)) {
                result = value;
            }
        }
        return result;
    }

    static String readFontWeight(LexicalUnit unit) {
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if (NORMAL.equals(value)) {
                result = value;
            } else if (BOLD.equals(value)) {
                result = value;
            }
        }
        return result;
    }

    static int readFontSize(LexicalUnit unit) {
        int value;
        int result = -1;
        Integer length = PropertyResolver.readSingleLengthUnit(unit);
        if (length != null && (value = length.intValue()) >= 0) {
            result = value;
        }
        return result;
    }

    static String[] readFontFamily(LexicalUnit unit) {
        ArrayList<String> list = new ArrayList<String>();
        LexicalUnit nextUnit = unit;
        boolean ok = true;
        String buffer = "";
        while (nextUnit != null && ok) {
            short type = nextUnit.getLexicalUnitType();
            if (type == 36 || type == 35) {
                if (buffer.length() > 0) {
                    buffer = String.valueOf(buffer) + " ";
                }
                buffer = String.valueOf(buffer) + nextUnit.getStringValue();
            } else if (type == 0) {
                if (buffer.length() > 0) {
                    list.add(buffer);
                } else {
                    ok = false;
                }
                buffer = "";
            }
            nextUnit = nextUnit.getNextLexicalUnit();
        }
        String[] result = null;
        if (buffer.length() > 0) {
            list.add(buffer);
            result = new String[list.size()];
            list.toArray(result);
        }
        return result;
    }

    static boolean isImageProperty(String property) {
        return property.endsWith("-image");
    }

    static QxImage readBackgroundImage(LexicalUnit unit, ResourceLoader loader) {
        String function;
        QxImage result = null;
        short type = unit.getLexicalUnitType();
        if (type == 24) {
            String value = unit.getStringValue();
            result = QxImage.valueOf(value, loader);
        } else if (type == 35) {
            String value = unit.getStringValue();
            if (NONE.equals(value)) {
                result = QxImage.NONE;
            }
        } else if (type == 41 && "gradient".equals(function = unit.getFunctionName())) {
            result = PropertyResolver.readGradient(unit);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse image " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static QxImage readGradient(LexicalUnit unit) {
        boolean vertical;
        QxImage result = null;
        LexicalUnit nextUnit = unit.getParameters();
        String gradientType = PropertyResolver.readGradientType(nextUnit);
        if (!"linear".equals(gradientType)) {
            String msg = "Invalid value for background-image gradient type: " + gradientType;
            throw new IllegalArgumentException(msg);
        }
        if (!PropertyResolver.checkComma(nextUnit = nextUnit.getNextLexicalUnit())) {
            throw new IllegalArgumentException("Failed to parse background-image gradient.");
        }
        String[] startPoint = PropertyResolver.readGradientPoint(nextUnit = nextUnit.getNextLexicalUnit());
        if (!"left".equals(startPoint[0]) || !"top".equals(startPoint[1])) {
            String msg = "Invalid value for background-image gradient start point: " + startPoint[0] + " " + startPoint[1];
            throw new IllegalArgumentException(msg);
        }
        nextUnit = nextUnit.getNextLexicalUnit();
        if (!PropertyResolver.checkComma(nextUnit = nextUnit.getNextLexicalUnit())) {
            throw new IllegalArgumentException("Failed to parse background-image gradient.");
        }
        String[] endPoint = PropertyResolver.readGradientPoint(nextUnit = nextUnit.getNextLexicalUnit());
        if ("left".equals(endPoint[0]) && "bottom".equals(endPoint[1])) {
            vertical = true;
        } else if ("right".equals(endPoint[0]) && "top".equals(endPoint[1])) {
            vertical = false;
        } else {
            String msg = "Invalid value for background-image gradient end point: " + endPoint[0] + " " + endPoint[1];
            throw new IllegalArgumentException(msg);
        }
        nextUnit = nextUnit.getNextLexicalUnit();
        nextUnit = nextUnit.getNextLexicalUnit();
        TreeMap<Float, String> gradient = PropertyResolver.readGradientColorsPercents(nextUnit);
        if (gradient.size() > 0) {
            gradient = PropertyResolver.normalizeGradientValue(gradient);
            String[] gradientColors = PropertyResolver.getGradientColors(gradient);
            float[] gradientPercents = PropertyResolver.getGradientPercents(gradient);
            result = QxImage.createGradient(gradientColors, gradientPercents, vertical);
        }
        return result;
    }

    static String readGradientType(LexicalUnit unit) {
        String result = null;
        if (unit != null && unit.getLexicalUnitType() == 35) {
            result = unit.getStringValue();
        }
        return result;
    }

    static String[] readGradientPoint(LexicalUnit unit) {
        String[] result = new String[2];
        LexicalUnit x = unit;
        LexicalUnit y = null;
        if (unit != null) {
            y = unit.getNextLexicalUnit();
        }
        if (x != null && y != null) {
            short xType = x.getLexicalUnitType();
            short yType = y.getLexicalUnitType();
            if (xType == 35 && yType == 35) {
                result[0] = x.getStringValue();
                result[1] = y.getStringValue();
            } else if (xType == 13 && yType == 13) {
                result[0] = Integer.toString(x.getIntegerValue());
                result[1] = Integer.toString(y.getIntegerValue());
            }
        }
        return result;
    }

    static TreeMap<Float, String> readGradientColorsPercents(LexicalUnit unit) {
        TreeMap<Float, String> result = new TreeMap<Float, String>();
        LexicalUnit nextUnit = unit;
        while (nextUnit != null) {
            Float percent = null;
            String color = null;
            if ((nextUnit = nextUnit.getNextLexicalUnit()) != null && nextUnit.getLexicalUnitType() == 41) {
                LexicalUnit colorUnit;
                String function = nextUnit.getFunctionName();
                if ("from".equals(function)) {
                    percent = new Float(0.0f);
                    colorUnit = nextUnit.getParameters();
                    color = PropertyResolver.readGradientColor(colorUnit);
                } else if ("to".equals(function)) {
                    percent = new Float(100.0f);
                    colorUnit = nextUnit.getParameters();
                    color = PropertyResolver.readGradientColor(colorUnit);
                } else if ("color-stop".equals(function)) {
                    LexicalUnit percentUnit = nextUnit.getParameters();
                    percent = PropertyResolver.readGradientPercent(percentUnit);
                    LexicalUnit colorUnit2 = percentUnit.getNextLexicalUnit().getNextLexicalUnit();
                    color = PropertyResolver.readGradientColor(colorUnit2);
                } else {
                    String msg = "Invalid value for background-image gradient: " + function;
                    throw new IllegalArgumentException(msg);
                }
                nextUnit = nextUnit.getNextLexicalUnit();
            }
            if (percent == null || color == null) continue;
            result.put(percent, color);
        }
        return result;
    }

    static String readGradientColor(LexicalUnit unit) {
        QxColor result = PropertyResolver.readColor(unit);
        return result != null ? result.toDefaultString() : null;
    }

    static Float readGradientPercent(LexicalUnit unit) {
        Float result = null;
        short type = unit.getLexicalUnitType();
        if (type == 23) {
            result = new Float(PropertyResolver.normalizePercentValue(unit.getFloatValue()));
        } else if (type == 14) {
            result = new Float(PropertyResolver.normalizePercentValue(unit.getFloatValue() * 100.0f));
        }
        return result;
    }

    static boolean isBackgroundRepeatProperty(String property) {
        return "background-repeat".equals(property);
    }

    static QxIdentifier readBackgroundRepeat(LexicalUnit unit) {
        QxIdentifier result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if ("repeat".equals(value) || "repeat-x".equals(value) || "repeat-y".equals(value) || "no-repeat".equals(value)) {
                result = new QxIdentifier(value);
            } else {
                String msg = "Invalid value for background-repeat: " + value;
                throw new IllegalArgumentException(msg);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse background-repeat " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isBackgroundPositionProperty(String property) {
        return "background-position".equals(property);
    }

    static QxIdentifier readBackgroundPosition(LexicalUnit unit) {
        QxIdentifier result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(unit.getStringValue());
            LexicalUnit nextUnit = unit.getNextLexicalUnit();
            if (nextUnit != null && nextUnit.getStringValue() != null) {
                buffer.append(" ");
                buffer.append(nextUnit.getStringValue());
            } else {
                buffer.append(" center");
            }
            String value = buffer.toString();
            if ("left top".equals(value) || "left center".equals(value) || "left bottom".equals(value) || "right top".equals(value) || "right center".equals(value) || "right bottom".equals(value) || "center top".equals(value) || "center center".equals(value) || "center bottom".equals(value)) {
                result = new QxIdentifier(value);
            } else {
                String msg = "Invalid value for background-position: " + value;
                throw new IllegalArgumentException(msg);
            }
        }
        if (result == null) {
            String msg = "Failed to parse background-position " + PropertyResolver.toString(unit);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    static boolean isTextDecorationProperty(String property) {
        return "text-decoration".equals(property);
    }

    static QxIdentifier readTextDecoration(LexicalUnit unit) {
        QxIdentifier result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if ("underline".equals(value) || "overline".equals(value) || "line-through".equals(value) || NONE.equals(value)) {
                result = new QxIdentifier(value);
            } else {
                throw new IllegalArgumentException("Invalid value for text-decoration: " + value);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse text-decoration " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isTextAlignProperty(String property) {
        return "text-align".equals(property);
    }

    static QxIdentifier readTextAlign(LexicalUnit unit) {
        QxIdentifier result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if ("left".equals(value) || "right".equals(value) || "center".equals(value)) {
                result = new QxIdentifier(value);
            } else {
                throw new IllegalArgumentException("Invalid value for text-align: " + value);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse text-align " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isCursorProperty(String property) {
        return "cursor".equals(property);
    }

    static QxCursor readCursor(LexicalUnit unit, ResourceLoader loader) {
        QxCursor result = null;
        short type = unit.getLexicalUnitType();
        if (type == 24) {
            String value = unit.getStringValue();
            result = QxCursor.valueOf(value, loader);
        } else if (type == 35) {
            String value = unit.getStringValue();
            result = QxCursor.valueOf(value);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse cursor " + PropertyResolver.toString(unit));
        }
        return result;
    }

    static boolean isFloatProperty(String property) {
        return "opacity".equals(property);
    }

    static QxFloat readFloat(LexicalUnit unit) {
        float value;
        if (unit.getLexicalUnitType() == 14 || unit.getLexicalUnitType() == 13) {
            value = unit.getLexicalUnitType() == 13 ? (float)unit.getIntegerValue() : unit.getFloatValue();
            if (!(value >= 0.0f) || !(value <= 1.0f)) {
                throw new IllegalArgumentException("Float out of bounds: " + value);
            }
        } else {
            String msg = "Failed to parse float " + PropertyResolver.toString(unit);
            throw new IllegalArgumentException(msg);
        }
        QxFloat result = QxFloat.create(value);
        return result;
    }

    static boolean isAnimationProperty(String property) {
        return "animation".equals(property);
    }

    static QxAnimation readAnimation(LexicalUnit unit) {
        String value;
        QxAnimation result = new QxAnimation();
        LexicalUnit nextUnit = unit;
        short type = nextUnit.getLexicalUnitType();
        if (type == 35 && NONE.equals(value = nextUnit.getStringValue())) {
            nextUnit = null;
        }
        while (nextUnit != null) {
            int duration;
            type = nextUnit.getLexicalUnitType();
            if (type != 35) {
                String msg = "Invalid value for animation name: " + PropertyResolver.toString(nextUnit);
                throw new IllegalArgumentException(msg);
            }
            String name = nextUnit.getStringValue();
            nextUnit = nextUnit.getNextLexicalUnit();
            if (nextUnit == null) {
                String msg = "Missing value for animation duration.";
                throw new IllegalArgumentException(msg);
            }
            type = nextUnit.getLexicalUnitType();
            if (type == 32) {
                duration = Math.round(nextUnit.getFloatValue() * 1000.0f);
            } else if (type == 31) {
                duration = Math.round(nextUnit.getFloatValue());
            } else {
                String msg = "Invalid value for animation duration: " + PropertyResolver.toString(nextUnit);
                throw new IllegalArgumentException(msg);
            }
            nextUnit = nextUnit.getNextLexicalUnit();
            if (nextUnit == null) {
                String msg = "Missing value for animation timing function.";
                throw new IllegalArgumentException(msg);
            }
            type = nextUnit.getLexicalUnitType();
            if (type != 35) {
                String msg = "Invalid value for animation timing function: " + PropertyResolver.toString(nextUnit);
                throw new IllegalArgumentException(msg);
            }
            String timingFunction = nextUnit.getStringValue();
            result.addAnimation(name, duration, timingFunction);
            nextUnit = nextUnit.getNextLexicalUnit();
            if (nextUnit == null) continue;
            type = nextUnit.getLexicalUnitType();
            if (type == 0) {
                nextUnit = nextUnit.getNextLexicalUnit();
                continue;
            }
            String msg = "Failed to parse animation " + PropertyResolver.toString(nextUnit);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    static boolean isShadowProperty(String property) {
        return "box-shadow".equals(property) || "text-shadow".equals(property);
    }

    static QxShadow readShadow(LexicalUnit unit) {
        QxShadow result = null;
        boolean inset = false;
        Integer offsetX = null;
        Integer offsetY = null;
        int blur = 0;
        int spread = 0;
        QxColor color = QxColor.BLACK;
        LexicalUnit nextUnit = unit;
        short type = nextUnit.getLexicalUnitType();
        if (type == 35) {
            String value = nextUnit.getStringValue();
            if (NONE.equals(value)) {
                result = QxShadow.NONE;
            } else if (INSET.equals(value)) {
                inset = true;
            }
            nextUnit = nextUnit.getNextLexicalUnit();
        }
        if (result == null) {
            boolean ok = true;
            int pos = 0;
            while (nextUnit != null && ok) {
                Integer nextValue = PropertyResolver.readSingleLengthUnit(nextUnit);
                if (!(ok &= nextValue != null && ++pos <= 4)) continue;
                if (pos == 1) {
                    offsetX = nextValue;
                } else if (pos == 2) {
                    offsetY = nextValue;
                } else if (pos == 3) {
                    blur = nextValue;
                } else if (pos == 4) {
                    spread = nextValue;
                }
                nextUnit = nextUnit.getNextLexicalUnit();
            }
            if (nextUnit != null) {
                type = nextUnit.getLexicalUnitType();
                color = type == 41 && "rgba".equals(nextUnit.getFunctionName()) ? PropertyResolver.readColorRgba(nextUnit) : PropertyResolver.readColor(nextUnit);
            }
        }
        if (offsetX != null && offsetY != null) {
            result = QxShadow.create(inset, offsetX, offsetY, blur, spread, color);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse shadow " + PropertyResolver.toString(unit));
        }
        return result;
    }

    private static Integer readSingleLengthUnit(LexicalUnit unit) {
        Integer result = null;
        short type = unit.getLexicalUnitType();
        if (type == 13) {
            int value = unit.getIntegerValue();
            if (value == 0) {
                result = new Integer(0);
            }
        } else if (type == 17) {
            result = new Integer((int)unit.getFloatValue());
        }
        return result;
    }

    private static int normalizeRGBValue(int input) {
        int result = input;
        if (input < 0) {
            result = 0;
        } else if (input > 255) {
            result = 255;
        }
        return result;
    }

    private static float normalizeAlphaValue(float input) {
        float result = input;
        if (input < 0.0f) {
            result = 0.0f;
        } else if (input > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    private static float normalizePercentValue(float input) {
        float result = input;
        if (input < 0.0f) {
            result = 0.0f;
        } else if (input > 100.0f) {
            result = 100.0f;
        }
        return result;
    }

    private static TreeMap<Float, String> normalizeGradientValue(TreeMap<Float, String> gradient) {
        TreeMap<Float, String> result = gradient;
        if (gradient.size() > 0) {
            Float zero = new Float(0.0f);
            Float hundred = new Float(100.0f);
            if (gradient.get(zero) == null) {
                String firstColor = gradient.get(gradient.firstKey());
                result.put(zero, firstColor);
            }
            if (gradient.get(hundred) == null) {
                String lastColor = gradient.get(gradient.lastKey());
                result.put(hundred, lastColor);
            }
        }
        return result;
    }

    private static String[] getGradientColors(TreeMap gradient) {
        Object[] values = gradient.values().toArray();
        String[] result = new String[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = (String)values[i];
            ++i;
        }
        return result;
    }

    private static float[] getGradientPercents(TreeMap gradient) {
        Object[] keys = gradient.keySet().toArray();
        float[] result = new float[keys.length];
        int i = 0;
        while (i < keys.length) {
            result[i] = ((Float)keys[i]).floatValue();
            ++i;
        }
        return result;
    }

    static boolean checkComma(LexicalUnit unit) {
        boolean result = false;
        if (unit != null && unit.getLexicalUnitType() == 0) {
            result = true;
        }
        return result;
    }

    static String toString(LexicalUnit value) {
        StringBuilder buffer = new StringBuilder();
        short type = value.getLexicalUnitType();
        if (type == 37) {
            buffer.append("ATTR " + value.getStringValue());
        } else if (type == 19 || type == 28 || type == 15 || type == 16 || type == 29 || type == 33 || type == 18 || type == 34 || type == 20 || type == 31 || type == 23 || type == 22 || type == 21 || type == 17 || type == 30 || type == 32 || type == 42) {
            buffer.append("DIM " + value.getFloatValue() + value.getDimensionUnitText());
        } else if (type == 27) {
            LexicalUnit parameters = value.getParameters();
            buffer.append("rgb(" + PropertyResolver.toString(parameters) + ")");
        } else if (type == 36) {
            buffer.append("\"" + value.getStringValue() + "\"");
        } else if (type == 35) {
            buffer.append(value.getStringValue());
        } else if (type == 17) {
            buffer.append(String.valueOf(value.getFloatValue()) + "px");
        } else if (type == 13) {
            buffer.append(value.getIntegerValue());
        } else if (type == 0) {
            buffer.append(",");
        } else if (type == 37) {
            buffer.append("ATTR " + value.getStringValue());
        } else if (type == 41) {
            buffer.append("UNKNOWN FUNCTION " + value.getFunctionName());
        } else if (type == 42) {
            buffer.append("UNKNOWN DIMENSION " + value);
        } else {
            buffer.append("unsupported unit " + value.getLexicalUnitType());
        }
        LexicalUnit next = value.getNextLexicalUnit();
        if (next != null) {
            buffer.append(" ");
            buffer.append(PropertyResolver.toString(next));
        }
        return buffer.toString();
    }

    private static final class NamedColor {
        final int red;
        final int green;
        final int blue;

        public NamedColor(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }
    }
}

