/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.QxColor;
import org.eclipse.rap.rwt.internal.theme.QxType;

public class QxShadow
implements QxType {
    public static final QxShadow NONE = new QxShadow(false, 0, 0, 0, 0, null, 0.0f);
    public final boolean inset;
    public final int offsetX;
    public final int offsetY;
    public final int blur;
    public final int spread;
    public final String color;
    public final float opacity;

    private QxShadow(boolean inset, int offsetX, int offsetY, int blur, int spread, String color, float opacity) {
        this.inset = inset;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blur = blur;
        this.spread = spread;
        this.color = color;
        this.opacity = opacity;
    }

    public static QxShadow create(boolean inset, int offsetX, int offsetY, int blur, int spread, QxColor color) {
        if (blur < 0) {
            String msg = "Shadow blur distance can't be negative";
            throw new IllegalArgumentException(msg);
        }
        if (spread != 0) {
            String msg = "Shadow spread distance is not supported";
            throw new IllegalArgumentException(msg);
        }
        if (color == null) {
            throw new NullPointerException("null argument");
        }
        String htmlColor = QxColor.toHtmlString(color.red, color.green, color.blue);
        return new QxShadow(inset, offsetX, offsetY, blur, spread, htmlColor, color.alpha);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj instanceof QxShadow) {
            QxShadow other = (QxShadow)obj;
            result = other.inset == this.inset && other.offsetX == this.offsetX && other.offsetY == this.offsetY && other.blur == this.blur && other.spread == this.spread && (this.color == null ? other.color == null : this.color.equals(other.color)) && other.opacity == this.opacity;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result += 11 * result + this.offsetX;
        result += 11 * result + this.offsetY;
        result += 11 * result + this.blur;
        result += 11 * result + this.spread;
        if (this.color != null) {
            result += 11 * result + this.color.hashCode();
        }
        result += 11 * result + Float.floatToIntBits(this.opacity);
        return result += this.inset ? 0 : 11 * result + 13;
    }

    public String toDefaultString() {
        StringBuilder buffer = new StringBuilder();
        if (this.color == null) {
            buffer.append("none");
        } else {
            if (this.inset) {
                buffer.append("inset ");
            }
            buffer.append(this.offsetX);
            buffer.append("px ");
            buffer.append(this.offsetY);
            buffer.append("px ");
            buffer.append(this.blur);
            buffer.append("px ");
            buffer.append(this.spread);
            buffer.append("px ");
            buffer.append("rgba( ");
            QxColor qxColor = QxColor.valueOf(this.color);
            buffer.append(qxColor.red);
            buffer.append(", ");
            buffer.append(qxColor.green);
            buffer.append(", ");
            buffer.append(qxColor.blue);
            buffer.append(", ");
            buffer.append(this.opacity);
            buffer.append(" )");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.inset);
        buffer.append(", ");
        buffer.append(this.offsetX);
        buffer.append(", ");
        buffer.append(this.offsetY);
        buffer.append(", ");
        buffer.append(this.blur);
        buffer.append(", ");
        buffer.append(this.spread);
        buffer.append(", ");
        buffer.append(this.color);
        buffer.append(", ");
        buffer.append(this.opacity);
        return "QxShadow{ " + buffer.toString() + " }";
    }
}

