/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.OperationReader;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
implements Serializable {
    private static final String HEAD = "head";
    private static final String OPERATIONS = "operations";
    private final JsonObject head;
    private final List<Operation> operations;

    protected Message(JsonObject head, List<Operation> operations) {
        ParamCheck.notNull(head, HEAD);
        ParamCheck.notNull(operations, OPERATIONS);
        this.head = head;
        this.operations = operations;
    }

    protected Message(JsonObject json) {
        ParamCheck.notNull(json, "json");
        this.head = Message.readHead(json);
        this.operations = Message.readOperations(json);
    }

    public JsonObject getHead() {
        return this.head;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public JsonObject toJson() {
        JsonArray operationsArray = new JsonArray();
        for (Operation operation : this.operations) {
            operationsArray.add(operation.toJson());
        }
        return new JsonObject().add(HEAD, this.head).add(OPERATIONS, operationsArray);
    }

    public String toString() {
        return this.toJson().toString();
    }

    private static JsonObject readHead(JsonObject message) {
        try {
            return message.get(HEAD).asObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read head from JSON message", exception);
        }
    }

    private static List<Operation> readOperations(JsonObject message) {
        try {
            return Message.processOperations(message.get(OPERATIONS).asArray());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to read operations from JSON message", exception);
        }
    }

    private static List<Operation> processOperations(JsonArray operationsArray) {
        ArrayList<Operation> operations = new ArrayList<Operation>(operationsArray.size());
        for (JsonValue operation : operationsArray) {
            operations.add(OperationReader.readOperation((JsonValue)operation.asArray()));
        }
        return operations;
    }
}

