/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.internal.xpath;

import java.util.Locale;
import org.eclipse.e4.emf.internal.xpath.EObjectAttributeIterator;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeatureIterator;
import org.eclipse.e4.emf.internal.xpath.EStructuralFeaturePointer;
import org.eclipse.e4.emf.internal.xpath.helper.ValueUtils;
import org.eclipse.rap.e4.apache.jxpath.JXPathInvalidAccessException;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeNameTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeTest;
import org.eclipse.rap.e4.apache.jxpath.ri.compiler.NodeTypeTest;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodeIterator;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;

public abstract class EStructuralFeatureOwnerPointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    private static final Object UNINITIALIZED = new Object();
    private Object value = UNINITIALIZED;

    @Override
    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (test == null) {
            return this.createNodeIterator(null, reverse, startWith);
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            if (this.isValidProperty(testName)) {
                return this.createNodeIterator(nodeNameTest.isWildcard() ? null : testName.toString(), reverse, startWith);
            }
            return null;
        }
        return test instanceof NodeTypeTest && ((NodeTypeTest)test).getNodeType() == 1 ? this.createNodeIterator(null, reverse, startWith) : null;
    }

    public NodeIterator createNodeIterator(String property, boolean reverse, NodePointer startWith) {
        return new EStructuralFeatureIterator(this, property, reverse, startWith);
    }

    @Override
    public NodeIterator attributeIterator(QName name) {
        return new EObjectAttributeIterator(this, name);
    }

    protected EStructuralFeatureOwnerPointer(NodePointer parent, Locale locale) {
        super(parent, locale);
    }

    protected EStructuralFeatureOwnerPointer(NodePointer parent) {
        super(parent);
    }

    @Override
    public void setIndex(int index) {
        if (this.index != index) {
            super.setIndex(index);
            this.value = UNINITIALIZED;
        }
    }

    @Override
    public Object getImmediateNode() {
        if (this.value == UNINITIALIZED) {
            this.value = this.index == Integer.MIN_VALUE ? ValueUtils.getValue(this.getBaseValue()) : ValueUtils.getValue(this.getBaseValue(), this.index);
        }
        return this.value;
    }

    @Override
    public abstract QName getName();

    public boolean isValidProperty(QName name) {
        return this.isDefaultNamespace(name.getPrefix());
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        if (this.parent != null) {
            if (!this.parent.isContainer()) {
                if (this.index == Integer.MIN_VALUE) {
                    throw new UnsupportedOperationException("Cannot setValue of an object that is not some other object's property");
                }
                throw new JXPathInvalidAccessException("The specified collection element does not exist: " + String.valueOf(this));
            }
        } else {
            throw new UnsupportedOperationException("Cannot replace the root object");
        }
        this.parent.setValue(value);
    }

    @Override
    public void remove() {
        this.value = null;
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove an object that is not some other object's property or a collection element");
        }
        this.parent.remove();
    }

    public abstract EStructuralFeaturePointer getPropertyPointer();

    public boolean isDynamicPropertyDeclarationSupported() {
        return false;
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        int r = pointer1.getName().toString().compareTo(pointer2.getName().toString());
        return r == 0 ? pointer1.getIndex() - pointer2.getIndex() : r;
    }
}

