/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.rap.http.registry.internal.ExtensionPointTracker;
import org.eclipse.rap.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ResourceManager
implements ExtensionPointTracker.Listener {
    private static final String RESOURCES_EXTENSION_POINT = "org.eclipse.rap.http.registry.resources";
    private static final String HTTPCONTEXT_NAME = "httpcontext-name";
    private static final String BASE_NAME = "base-name";
    private static final String ALIAS = "alias";
    private static final String RESOURCE = "resource";
    private static final String HTTPCONTEXT_ID = "httpcontextId";
    private static final String SERVICESELECTOR = "serviceSelector";
    private static final String CLASS = "class";
    private static final String FILTER = "filter";
    private ExtensionPointTracker tracker;
    private List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private HttpRegistryManager httpRegistryManager;
    private ServiceReference<?> reference;

    public ResourceManager(HttpRegistryManager httpRegistryManager, ServiceReference<?> reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.reference = reference;
        this.tracker = new ExtensionPointTracker(registry, RESOURCES_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement serviceSelectorElement = iConfigurationElementArray[n2];
            if (SERVICESELECTOR.equals(serviceSelectorElement.getName())) {
                Filter serviceSelector = null;
                String clazz = serviceSelectorElement.getAttribute(CLASS);
                if (clazz != null) {
                    try {
                        serviceSelector = (Filter)serviceSelectorElement.createExecutableExtension(CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                String filter = serviceSelectorElement.getAttribute(FILTER);
                if (filter == null) {
                    return;
                }
                try {
                    serviceSelector = FrameworkUtil.createFilter((String)filter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (serviceSelector.match(this.reference)) break;
                return;
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            String alias;
            IConfigurationElement resourceElement = iConfigurationElementArray[n2];
            if (RESOURCE.equals(resourceElement.getName()) && (alias = resourceElement.getAttribute(ALIAS)) != null) {
                Object httpContextId;
                String baseName = resourceElement.getAttribute(BASE_NAME);
                if (baseName == null) {
                    baseName = "";
                }
                if ((httpContextId = resourceElement.getAttribute(HTTPCONTEXT_ID)) == null) {
                    httpContextId = resourceElement.getAttribute(HTTPCONTEXT_NAME);
                }
                if (httpContextId != null && ((String)httpContextId).indexOf(46) == -1) {
                    httpContextId = resourceElement.getNamespaceIdentifier() + "." + (String)httpContextId;
                }
                if (this.httpRegistryManager.addResourcesContribution(alias, baseName, (String)httpContextId, extension.getContributor())) {
                    this.registered.add(resourceElement);
                }
            }
            ++n2;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement resourceElement = iConfigurationElementArray[n2];
            if (this.registered.remove(resourceElement)) {
                String alias = resourceElement.getAttribute(ALIAS);
                this.httpRegistryManager.removeContribution(alias);
            }
            ++n2;
        }
    }
}

