/*******************************************************************************
 * Copyright (c) 2007, 2015 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.core.internal.databinding.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;

/**
 * Converts from a Number to a BigInteger.
 * <p>
 * Class is thread safe.
 * </p>
 *
 * @since 1.0
 */
public class NumberToBigIntegerConverter extends NumberToNumberConverter<BigInteger> {
	/**
	 * @param numberFormat
	 * @param fromType
	 */
	public NumberToBigIntegerConverter(Format numberFormat, Class<?> fromType) {
		super(numberFormat, fromType, BigInteger.class);
	}

	@Override
	protected BigInteger doConvert(Number number) {
		return toBigDecimal(number).toBigInteger();
	}

	private static BigDecimal toBigDecimal(Number number) {
		if (number instanceof BigDecimal) {
			return (BigDecimal) number;
		}

		return new BigDecimal(number.doubleValue());
	}
}
