/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.security.Permission;
import java.util.Dictionary;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.EventDispatcher;
import org.eclipse.equinox.internal.cm.LogTracker;
import org.eclipse.equinox.internal.cm.ManagedServiceFactoryTracker;
import org.eclipse.equinox.internal.cm.ManagedServiceTracker;
import org.eclipse.equinox.internal.cm.PluginManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;

public class ConfigurationAdminFactory
implements ServiceFactory<ConfigurationAdmin>,
BundleListener {
    private static final Permission allConfigurationPermission = new ConfigurationPermission("*", "configure");
    private final EventDispatcher eventDispatcher;
    private final PluginManager pluginManager;
    private final LogTracker log;
    private final ManagedServiceTracker managedServiceTracker;
    private final ManagedServiceFactoryTracker managedServiceFactoryTracker;
    private final ConfigurationStore configurationStore;

    public ConfigurationAdminFactory(BundleContext context, LogTracker log) {
        this.log = log;
        this.configurationStore = new ConfigurationStore(this, context);
        this.eventDispatcher = new EventDispatcher(context, log);
        this.pluginManager = new PluginManager(context);
        this.managedServiceTracker = new ManagedServiceTracker(this, this.configurationStore, context);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this, this.configurationStore, context);
    }

    void start() {
        this.eventDispatcher.start();
        this.pluginManager.start();
        this.managedServiceTracker.open();
        this.managedServiceFactoryTracker.open();
    }

    void stop() {
        this.managedServiceTracker.close();
        this.managedServiceFactoryTracker.close();
        this.eventDispatcher.stop();
        this.pluginManager.stop();
    }

    public ConfigurationAdmin getService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration) {
        ServiceReference reference = registration.getReference();
        this.eventDispatcher.setServiceReference((ServiceReference<ConfigurationAdmin>)reference);
        return new ConfigurationAdminImpl(this, this.configurationStore, bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ConfigurationAdmin> registration, ConfigurationAdmin service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.configurationStore.unbindConfigurations(event.getBundle());
        }
    }

    public void checkConfigurePermission(String location, String forBundleLocation) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (!(sm == null || forBundleLocation != null && forBundleLocation.equals(location))) {
            if (location == null) {
                sm.checkPermission(allConfigurationPermission);
            } else {
                sm.checkPermission((Permission)new ConfigurationPermission(location, "configure"));
            }
        }
    }

    public boolean checkTargetPermission(String location, ServiceReference<?> ref) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            String forBundleLocation;
            Bundle b = ref.getBundle();
            if (location != null && b != null && !(forBundleLocation = ConfigurationAdminImpl.getLocation(b)).equals(location) && location != null) {
                return b.hasPermission((Object)new ConfigurationPermission(location, "target"));
            }
        }
        return true;
    }

    void log(int level, String message) {
        this.log.log(level, message);
    }

    void log(int level, String message, Throwable exception) {
        this.log.log(level, message, exception);
    }

    void dispatchEvent(int type, String factoryPid, String pid) {
        this.eventDispatcher.dispatchEvent(type, factoryPid, pid);
    }

    void notifyConfigurationUpdated(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyUpdated(config);
        } else {
            this.managedServiceTracker.notifyUpdated(config);
        }
    }

    void notifyConfigurationDeleted(ConfigurationImpl config, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyDeleted(config);
        } else {
            this.managedServiceTracker.notifyDeleted(config);
        }
    }

    void notifyLocationChanged(ConfigurationImpl config, String oldLocation, boolean isFactory) {
        if (isFactory) {
            this.managedServiceFactoryTracker.notifyUpdateLocation(config, oldLocation);
        } else {
            this.managedServiceTracker.notifyUpdateLocation(config, oldLocation);
        }
    }

    void modifyConfiguration(ServiceReference<?> reference, Dictionary<String, Object> properties) {
        this.pluginManager.modifyConfiguration(reference, properties);
    }
}

