/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public final class Util {
    private Util() {
    }

    public static void textSizeAdjustment(final Label label, final Control control) {
        final Composite parent = control.getParent();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int height = label.computeSize((int)-1, (int)-1).y;
                int width = height * 3;
                if (parent.getLayout() instanceof RowLayout) {
                    control.setLayoutData((Object)new RowData(width, height));
                } else if (parent.getLayout() instanceof GridLayout) {
                    control.setLayoutData((Object)new GridData(width, height));
                }
            }
        });
    }

    public static Image loadImage(Display display, String name) {
        Image result = null;
        InputStream stream = Util.class.getClassLoader().getResourceAsStream(name);
        if (stream != null) {
            try {
                result = new Image((Device)display, stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException unexpected) {
                    throw new RuntimeException("Failed to close image input stream", unexpected);
                }
            }
        }
        return result;
    }
}

