// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/*
******************************************************************************
* Copyright (C) 2007, International Business Machines Corporation and   *
* others. All Rights Reserved.                                               *
******************************************************************************
*/

package com.ibm.icu.impl.duration;

/**
 * Easy access to time units for Java 1.4, which doesn't have static imports.
 */
public interface TimeUnitConstants {
  /** Represents a year. */ 
  public static final TimeUnit YEAR = TimeUnit.YEAR;

  /** Represents a month. */  
  public static final TimeUnit MONTH = TimeUnit.MONTH;

  /** Represents a week. */ 
  public static final TimeUnit WEEK = TimeUnit.WEEK;

  /** Represents a day. */ 
  public static final TimeUnit DAY = TimeUnit.DAY;

  /** Represents an hour. */ 
  public static final TimeUnit HOUR = TimeUnit.HOUR;

  /** Represents a minute. */ 
  public static final TimeUnit MINUTE = TimeUnit.MINUTE;

  /** Represents a second. */ 
  public static final TimeUnit SECOND = TimeUnit.SECOND;

  /** Represents a millisecond. */ 
  public static final TimeUnit MILLISECOND = TimeUnit.MILLISECOND;
}
