/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;

public class RichTextEditorConfiguration {
    public static final String DEFAULT_LANGUAGE = "defaultLanguage";
    public static final String LANGUAGE = "language";
    public static final String TOOLBAR_GROUPS = "toolbarGroups";
    public static final String REMOVE_BUTTONS = "removeButtons";
    public static final String TOOLBAR_CAN_COLLAPSE = "toolbarCanCollapse";
    public static final String TOOLBAR_STARTUP_EXPANDED = "toolbarStartupExpanded";
    private static final String DEFAULT_TOOLBAR_GROUPS = RichTextEditorConfiguration.createDefaultToolbarGroups();
    private boolean removePasteText = true;
    private boolean removePasteFromWord = true;
    private boolean removeStyles = true;
    private boolean removeFormat = true;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Set<String> removedButtons = new HashSet<String>();

    public RichTextEditorConfiguration() {
        this.options.put(DEFAULT_LANGUAGE, Locale.ENGLISH.getLanguage());
        this.options.put(LANGUAGE, Locale.getDefault().getLanguage());
        this.setToolbarCollapsible(false);
        this.setToolbarInitialExpanded(true);
        this.options.put(TOOLBAR_GROUPS, DEFAULT_TOOLBAR_GROUPS);
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    RichTextEditorConfiguration(ToolbarConfiguration config) {
        this();
        this.removePasteText = config.removePasteText;
        this.removePasteFromWord = config.removePasteFromWord;
        this.removeStyles = config.removeStyles;
        this.removeFormat = config.removeFormat;
        this.removedButtons.addAll(config.getRemovedButtons());
        this.setToolbarCollapsible(config.toolbarCollapsible);
        this.setToolbarInitialExpanded(config.toolbarInitialExpanded);
        JsonObject jsonConfig = JsonObject.readFrom((String)config.toString());
        this.options.put(TOOLBAR_GROUPS, jsonConfig.get(TOOLBAR_GROUPS).toString());
        this.options.put(REMOVE_BUTTONS, jsonConfig.get(REMOVE_BUTTONS).asString());
    }

    private static String createDefaultToolbarGroups() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("{\"name\":\"basicstyles\",\"groups\":[\"basicstyles\",\"cleanup\"]},");
        builder.append("{\"name\":\"paragraph\",\"groups\":[\"list\",\"indent\",\"align\"]},");
        builder.append("\"/\",");
        builder.append("{\"name\":\"styles\"},");
        builder.append("{\"name\":\"colors\" }");
        builder.append("]");
        return builder.toString();
    }

    public void setOption(String key, Object value) {
        this.options.put(key, value);
    }

    public Object getOption(String key) {
        return this.options.get(key);
    }

    public Map<String, Object> getAllOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public void setLanguage(String lang) {
        this.options.put(LANGUAGE, lang);
    }

    public void setLanguage(Locale locale) {
        this.setLanguage(locale.getLanguage());
    }

    public void setDefaultLanguage(String lang) {
        this.options.put(DEFAULT_LANGUAGE, lang);
    }

    public void setDefaultLanguage(Locale locale) {
        this.setDefaultLanguage(locale.getLanguage());
    }

    public void setRemovePasteText(boolean removePasteText) {
        this.removePasteText = removePasteText;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemovePasteFromWord(boolean removePasteFromWord) {
        this.removePasteFromWord = removePasteFromWord;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemoveStyles(boolean removeStyles) {
        this.removeStyles = removeStyles;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void setRemoveFormat(boolean removeFormat) {
        this.removeFormat = removeFormat;
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void addDefaultToolbarButton(String ... buttonNames) {
        String[] stringArray = buttonNames;
        int n = buttonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buttonName = stringArray[n2];
            this.removedButtons.remove(buttonName);
            ++n2;
        }
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    public void removeDefaultToolbarButton(String ... buttonNames) {
        String[] stringArray = buttonNames;
        int n = buttonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buttonName = stringArray[n2];
            this.removedButtons.add(buttonName);
            ++n2;
        }
        this.options.put(REMOVE_BUTTONS, this.getRemoveButtonConfiguration());
    }

    private String getRemoveButtonConfiguration() {
        StringBuilder builder = new StringBuilder();
        if (this.removePasteText) {
            builder.append(",PasteText");
        }
        if (this.removePasteFromWord) {
            builder.append(",PasteFromWord");
        }
        if (this.removeStyles) {
            builder.append(",Styles");
        }
        if (this.removeFormat) {
            builder.append(",Format");
        }
        for (String removed : this.removedButtons) {
            builder.append(",").append(removed);
        }
        String removeButtons = builder.toString();
        if (removeButtons.startsWith(",")) {
            return removeButtons.substring(1);
        }
        return removeButtons;
    }

    public void setToolbarCollapsible(boolean toolbarCollapsible) {
        this.options.put(TOOLBAR_CAN_COLLAPSE, toolbarCollapsible);
    }

    public void setToolbarInitialExpanded(boolean toolbarInitialExpanded) {
        this.options.put(TOOLBAR_STARTUP_EXPANDED, toolbarInitialExpanded);
    }

    JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        Map<String, Object> allOptions = this.getAllOptions();
        for (Map.Entry<String, Object> entry : allOptions.entrySet()) {
            String optionName = entry.getKey();
            Object optionValue = entry.getValue();
            JsonValue jsonValue = RichTextEditorConfiguration.createJsonValue(optionValue);
            jsonObject.add(optionName, jsonValue);
        }
        return jsonObject;
    }

    private static JsonValue createJsonValue(Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return JsonValue.valueOf((boolean)bool);
        }
        if (value instanceof String) {
            String str = (String)value;
            return RichTextEditorConfiguration.processString(str);
        }
        if (value instanceof Integer) {
            Integer num = (Integer)value;
            return JsonValue.valueOf((int)num);
        }
        if (value instanceof Long) {
            Long num = (Long)value;
            return JsonValue.valueOf((long)num);
        }
        if (value instanceof Float) {
            Float num = (Float)value;
            return JsonValue.valueOf((float)num.floatValue());
        }
        if (value instanceof Double) {
            Double num = (Double)value;
            return JsonValue.valueOf((double)num);
        }
        System.out.println(value);
        String message = "Only a RichTextEditorConfiguration with Boolean, String, Integer, Long, Float and Double values is currently supported";
        throw new IllegalArgumentException(message);
    }

    private static JsonValue processString(String str) {
        if (str == null || str.length() < 1) {
            return JsonValue.valueOf((String)"");
        }
        if (str.charAt(0) == '[' || str.charAt(0) == '{') {
            return JsonValue.readFrom((String)str);
        }
        return JsonValue.valueOf((String)str);
    }
}

