/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

final class Utf8ResourceBundle {
    private static final Map<ResourceBundle, ResourceBundle> bundles = new HashMap<ResourceBundle, ResourceBundle>();

    Utf8ResourceBundle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        ResourceBundle result;
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, loader);
        Map<ResourceBundle, ResourceBundle> map = bundles;
        synchronized (map) {
            result = bundles.get(bundle);
            if (result == null) {
                result = Utf8ResourceBundle.createUtf8Bundle(bundle);
                bundles.put(bundle, result);
            }
        }
        return result;
    }

    private static ResourceBundle createUtf8Bundle(ResourceBundle bundle) {
        ResourceBundle result = bundle;
        if (bundle instanceof PropertyResourceBundle) {
            PropertyResourceBundle prb = (PropertyResourceBundle)bundle;
            result = new Utf8PropertyResourceBundle(prb);
        }
        return result;
    }

    private static class Utf8PropertyResourceBundle
    extends ResourceBundle {
        private PropertyResourceBundle bundle;

        private Utf8PropertyResourceBundle(PropertyResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }

        @Override
        protected Object handleGetObject(String key) {
            String result = (String)this.bundle.handleGetObject(key);
            try {
                if (result != null) {
                    result = new String(result.getBytes("ISO-8859-1"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            return result;
        }
    }
}

