/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.testfixture;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Widget;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Message {
    private JSONObject message;
    private JSONArray operations;

    public Message(String string) {
        String json = string.trim();
        try {
            this.message = new JSONObject(json);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Could not parse json: " + json);
        }
        try {
            this.operations = this.message.getJSONArray("operations");
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Missing operations array: " + json);
        }
    }

    public String toString() {
        try {
            return this.message.toString(2);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Formatting failed");
        }
    }

    public int getRequestCounter() {
        try {
            return this.message.getJSONObject("meta").getInt("requestCounter");
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Getting requestCounter failed");
        }
    }

    public String getError() {
        try {
            return this.message.getJSONObject("meta").getString("error");
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Getting error failed");
        }
    }

    public String getErrorMessage() {
        try {
            return this.message.getJSONObject("meta").getString("message");
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Getting error message failed");
        }
    }

    public int getOperationCount() {
        return this.operations.length();
    }

    public Operation getOperation(int position) {
        Operation result;
        JSONArray operation = this.getOperationAsJson(position);
        String action = this.getOperationAction(operation);
        if (action.equals("create")) {
            result = new CreateOperation(operation);
        } else if (action.equals("call")) {
            result = new CallOperation(operation);
        } else if (action.equals("set")) {
            result = new SetOperation(operation);
        } else if (action.equals("listen")) {
            result = new ListenOperation(operation);
        } else if (action.equals("destroy")) {
            result = new DestroyOperation(operation);
        } else {
            throw new IllegalArgumentException("Unknown operation action: " + action);
        }
        return result;
    }

    public Object findSetProperty(Widget widget, String property) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findSetProperty(target, property);
    }

    public Object findSetProperty(String target, String property) {
        SetOperation operation = this.findSetOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public SetOperation findSetOperation(Widget widget, String property) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findSetOperation(target, property);
    }

    public ListenOperation findListenOperation(Widget widget, String property) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findListenOperation(target, property);
    }

    public ListenOperation findListenOperation(String target, String property) {
        return (ListenOperation)this.findOperation(ListenOperation.class, target, property);
    }

    public Object findListenProperty(Widget widget, String property) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findListenProperty(target, property);
    }

    public Object findListenProperty(String target, String property) {
        ListenOperation operation = this.findListenOperation(target, property);
        if (operation == null) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public CreateOperation findCreateOperation(Widget widget) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findCreateOperation(target);
    }

    public Object findCreateProperty(Widget widget, String property) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findCreateProperty(target, property);
    }

    public Object findCreateProperty(String target, String property) {
        CreateOperation operation = this.findCreateOperation(target);
        if (operation == null || operation.getPropertyNames().indexOf(property) == -1) {
            throw new IllegalStateException("operation not found");
        }
        return operation.getProperty(property);
    }

    public CreateOperation findCreateOperation(String target) {
        return (CreateOperation)this.findOperation(CreateOperation.class, target);
    }

    public DestroyOperation findDestroyOperation(Widget widget) {
        String target = WidgetUtil.getId((Widget)widget);
        return (DestroyOperation)this.findOperation(DestroyOperation.class, target);
    }

    public SetOperation findSetOperation(String target, String property) {
        return (SetOperation)this.findOperation(SetOperation.class, target, property);
    }

    public CallOperation findCallOperation(Widget widget, String method) {
        String target = WidgetUtil.getId((Widget)widget);
        return this.findCallOperation(target, method);
    }

    public CallOperation findCallOperation(String target, String method) {
        CallOperation result = null;
        List<Operation> operations = this.getOperations();
        for (Operation operation : operations) {
            if (!operation.getTarget().equals(target) || !(operation instanceof CallOperation) || !method.equals(((CallOperation)operation).getMethodName())) continue;
            result = (CallOperation)operation;
        }
        return result;
    }

    private List<Operation> getOperations() {
        ArrayList<Operation> result = new ArrayList<Operation>();
        int i = 0;
        while (i < this.getOperationCount()) {
            result.add(this.getOperation(i));
            ++i;
        }
        return result;
    }

    private Operation findOperation(Class opClass, String target) {
        return this.findOperation(opClass, target, null);
    }

    private Operation findOperation(Class opClass, String target, String property) {
        Operation result = null;
        List<Operation> operations = this.getOperations();
        for (Operation operation : operations) {
            if (!operation.getTarget().equals(target) || !opClass.isInstance(operation) || property != null && !operation.getPropertyNames().contains(property)) continue;
            result = operation;
        }
        return result;
    }

    private JSONArray getOperationAsJson(int position) {
        JSONArray result;
        try {
            result = this.operations.getJSONArray(position);
        }
        catch (JSONException jSONException) {
            throw new IllegalStateException("Could not find operation at position " + position);
        }
        return result;
    }

    private String getOperationAction(JSONArray operation) {
        String action;
        try {
            action = operation.getString(0);
        }
        catch (JSONException jSONException) {
            throw new IllegalStateException("Could not find action for operation " + operation);
        }
        return action;
    }

    public final class CallOperation
    extends Operation {
        private CallOperation(JSONArray operation) {
            super(operation);
        }

        public String getMethodName() {
            String result;
            try {
                result = this.operation.getString(2);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Invalid call operation method name", e);
            }
            return result;
        }

        protected JSONObject getProperties() {
            JSONObject properties;
            try {
                properties = this.operation.getJSONObject(3);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }

    public final class CreateOperation
    extends Operation {
        private CreateOperation(JSONArray operation) {
            super(operation);
        }

        public String getParent() {
            return (String)this.getProperty("parent");
        }

        public String getType() {
            String result;
            try {
                result = this.operation.getString(2);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Invalid create operation type", e);
            }
            return result;
        }

        protected JSONObject getProperties() {
            JSONObject properties;
            try {
                properties = this.operation.getJSONObject(3);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }

        public Object[] getStyles() {
            Object detail = this.getProperty("style");
            Object[] result = null;
            if (!detail.equals(JSONObject.NULL)) {
                JSONArray parameters = (JSONArray)detail;
                result = new Object[parameters.length()];
                int i = 0;
                while (i < parameters.length()) {
                    try {
                        result[i] = parameters.get(i);
                    }
                    catch (JSONException jSONException) {
                        String message = "Style array is not valid for operation ";
                        throw new IllegalStateException(message);
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    public final class DestroyOperation
    extends Operation {
        private DestroyOperation(JSONArray operation) {
            super(operation);
        }

        protected JSONObject getProperties() {
            throw new IllegalStateException("Destroy operation has no properties");
        }
    }

    public final class ListenOperation
    extends Operation {
        private ListenOperation(JSONArray operation) {
            super(operation);
        }

        public boolean listensTo(String eventName) {
            return (Boolean)this.getProperty(eventName);
        }

        protected JSONObject getProperties() {
            JSONObject properties;
            try {
                properties = this.operation.getJSONObject(2);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Operation {
        private final String target;
        protected final JSONArray operation;

        private Operation(JSONArray operation) {
            this.operation = operation;
            try {
                this.target = operation.getString(1);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Invalid operation target", e);
            }
        }

        public String getTarget() {
            return this.target;
        }

        public List<String> getPropertyNames() {
            JSONObject properties = this.getProperties();
            String[] names = JSONObject.getNames((JSONObject)properties);
            return Arrays.asList(names);
        }

        public Object getProperty(String key) {
            Object result;
            JSONObject properties = this.getProperties();
            try {
                result = properties.get(key);
            }
            catch (JSONException jSONException) {
                throw new IllegalStateException("Property does not exist for key: " + key);
            }
            return result;
        }

        protected abstract JSONObject getProperties();
    }

    public final class SetOperation
    extends Operation {
        private SetOperation(JSONArray operation) {
            super(operation);
        }

        protected JSONObject getProperties() {
            JSONObject properties;
            try {
                properties = this.operation.getJSONObject(2);
            }
            catch (JSONException e) {
                throw new IllegalStateException("Properties object missing in operation", e);
            }
            return properties;
        }
    }
}

