/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.MarkupValidator;
import org.eclipse.swt.internal.widgets.labelkit.LabelThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    private String text = "";
    private Image image;
    boolean markupEnabled;
    private boolean markupValidationDisabled;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    void initState() {
        this.state |= 0x100;
    }

    public void setText(String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        if ((this.style & 2) == 0) {
            if (this.markupEnabled && !this.markupValidationDisabled) {
                MarkupValidator.getInstance().validate(text);
            }
            this.text = text;
            this.image = null;
        }
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            this.image = image;
            this.text = "";
        }
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) == 0 && (alignment & 0x1024000) != 0) {
            this.style &= 0xFEFDBFFF;
            this.style |= alignment & 0x1024000;
        }
    }

    public int getAlignment() {
        this.checkWidget();
        int result = (this.style & 2) != 0 ? 0 : ((this.style & 0x4000) != 0 ? 16384 : ((this.style & 0x1000000) != 0 ? 0x1000000 : ((this.style & 0x20000) != 0 ? 131072 : 16384)));
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 2) != 0) {
            int lineWidth = this.getSeparatorLineWidth();
            if ((this.style & 0x100) != 0) {
                width = 64;
                height = lineWidth;
            } else {
                width = lineWidth;
                height = 64;
            }
        } else if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            width = rect.width;
            height = rect.height;
        } else if (this.text.length() > 0) {
            int wrapWidth = 0;
            if ((this.style & 0x40) != 0 && wHint != -1) {
                wrapWidth = wHint;
            }
            Point extent = this.markupEnabled ? TextSizeUtil.markupExtent(this.getFont(), this.text, wrapWidth) : Graphics.textExtent(this.getFont(), this.text, wrapWidth);
            width = extent.x;
            height = extent.y + 2;
        } else {
            height = Graphics.getCharHeight(this.getFont());
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    String getNameText() {
        return this.getText();
    }

    public void setData(String key, Object value) {
        if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && !this.markupEnabled) {
            this.markupEnabled = Boolean.TRUE.equals(value);
        } else if ("org.eclipse.rap.rwt.markupValidationDisabled".equals(key)) {
            this.markupValidationDisabled = Boolean.TRUE.equals(value);
        }
        super.setData(key, value);
    }

    private static int checkStyle(int style) {
        int result = style;
        result |= 0x80000;
        if ((style & 2) != 0) {
            result = Label.checkBits(result, 512, 256, 0, 0, 0, 0);
            result = Label.checkBits(result, 8, 4, 32, 0, 0, 0);
        }
        result = Label.checkBits(result, 16384, 0x1000000, 131072, 0, 0, 0);
        return result;
    }

    private int getSeparatorLineWidth() {
        LabelThemeAdapter themeAdapter = (LabelThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return themeAdapter.getSeparatorLineWidth(this);
    }
}

