/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.resources.IResourceManagerFactory;

public final class ResourceManagerProvider {
    private IResourceManagerFactory factory;
    private IResourceManager instance;

    public synchronized void registerFactory(IResourceManagerFactory factory) {
        ParamCheck.notNull(factory, "factory");
        this.checkNoFactoryRegistered();
        this.factory = factory;
    }

    public synchronized IResourceManager getResourceManager() {
        if (this.instance == null) {
            this.instance = this.factory.create();
        }
        return this.instance;
    }

    private void checkNoFactoryRegistered() {
        if (this.factory != null) {
            String msg = "There is already an IResourceManagerFactory registered.";
            throw new IllegalStateException(msg);
        }
    }
}

