/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;

public class NonSynchronizedVector<E>
extends Vector<E> {
    public static <E> NonSynchronizedVector<E> newInstance(int initialCapacity, int capacityIncrement) {
        return new NonSynchronizedVector<E>(initialCapacity, capacityIncrement);
    }

    public static <E> NonSynchronizedVector<E> newInstance(int initialCapacity) {
        return new NonSynchronizedVector<E>(initialCapacity);
    }

    public static <E> NonSynchronizedVector<E> newInstance() {
        return new NonSynchronizedVector<E>();
    }

    public static <E> NonSynchronizedVector<E> newInstance(Collection<? extends E> c) {
        return new NonSynchronizedVector<E>(c);
    }

    public NonSynchronizedVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public NonSynchronizedVector(int initialCapacity) {
        super(initialCapacity);
    }

    public NonSynchronizedVector() {
    }

    public NonSynchronizedVector(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    @Override
    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            this.elementData = Arrays.copyOf(this.elementData, this.elementCount);
        }
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            ++this.modCount;
            if (minCapacity > this.elementData.length) {
                this.grow(minCapacity);
            }
        }
    }

    private Object[] grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = this.newLength(oldCapacity, minCapacity - oldCapacity, this.capacityIncrement > 0 ? this.capacityIncrement : oldCapacity);
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        return this.elementData;
    }

    private int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFEF) {
            return prefLength;
        }
        throw new OutOfMemoryError("Required array length is too large");
    }

    private Object[] grow() {
        return this.grow(this.elementCount + 1);
    }

    @Override
    public void setSize(int newSize) {
        ++this.modCount;
        if (newSize > this.elementData.length) {
            this.grow(newSize);
        }
        Object[] es = this.elementData;
        int to = this.elementCount;
        for (int i = newSize; i < to; ++i) {
            es[i] = null;
        }
        this.elementCount = newSize;
    }

    @Override
    public int capacity() {
        return this.elementData.length;
    }

    @Override
    public Object clone() {
        return new NonSynchronizedVector<E>(this);
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < NonSynchronizedVector.this.elementCount;
            }

            @Override
            public E nextElement() {
                if (this.count < NonSynchronizedVector.this.elementCount) {
                    return NonSynchronizedVector.this.elementData(this.count++);
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public int indexOf(Object elem, int index) {
        if (elem == null) {
            for (int i = index; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < this.elementCount; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    @Override
    public int lastIndexOf(Object elem, int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (elem == null) {
            for (int i = index; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public E elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData(index);
    }

    @Override
    public E firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(0);
    }

    @Override
    public E lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData(this.elementCount - 1);
    }

    @Override
    public void setElementAt(E obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    @Override
    public void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        ++this.modCount;
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    @Override
    public void insertElementAt(E obj, int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        ++this.modCount;
        int s = this.elementCount;
        Object[] elementData = this.elementData;
        if (s == elementData.length) {
            elementData = this.grow();
        }
        System.arraycopy(elementData, index, elementData, index + 1, s - index);
        elementData[index] = obj;
        this.elementCount = s + 1;
    }

    @Override
    public void addElement(E obj) {
        ++this.modCount;
        this.add(obj, this.elementData, this.elementCount);
    }

    @Override
    public boolean removeElement(Object obj) {
        ++this.modCount;
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    @Override
    public void removeAllElements() {
        Object[] es = this.elementData;
        int to = this.elementCount;
        this.elementCount = 0;
        for (int i = 0; i < to; ++i) {
            es[i] = null;
        }
        ++this.modCount;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.elementCount);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.elementCount) {
            return Arrays.copyOf(this.elementData, this.elementCount, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        if (a.length > this.elementCount) {
            a[this.elementCount] = null;
        }
        return a;
    }

    E elementData(int index) {
        return (E)this.elementData[index];
    }

    static <E> E elementAt(Object[] es, int index) {
        return (E)es[index];
    }

    @Override
    public E get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData(index);
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    private void add(E e, Object[] elementData, int s) {
        if (s == elementData.length) {
            elementData = this.grow();
        }
        elementData[s] = e;
        this.elementCount = s + 1;
    }

    @Override
    public boolean add(E o) {
        ++this.modCount;
        this.add(o, this.elementData, this.elementCount);
        return true;
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        E oldValue = this.elementData(index);
        int numMoved = this.elementCount - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.elementCount] = null;
        return oldValue;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.elementCount;
        if (numNew > elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(a, 0, elementData, s, numNew);
        this.elementCount = s + numNew;
        return true;
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    private boolean bulkRemove(Predicate<? super E> filter) {
        int i;
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        int end = this.elementCount;
        for (i = 0; i < end && !filter.test(NonSynchronizedVector.elementAt(es, i)); ++i) {
        }
        if (i < end) {
            int beg = i;
            long[] deathRow = NonSynchronizedVector.nBits(end - beg);
            deathRow[0] = 1L;
            for (i = beg + 1; i < end; ++i) {
                if (!filter.test(NonSynchronizedVector.elementAt(es, i))) continue;
                NonSynchronizedVector.setBit(deathRow, i - beg);
            }
            if (this.modCount != expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
            int w = beg;
            for (i = beg; i < end; ++i) {
                if (!NonSynchronizedVector.isClear(deathRow, i - beg)) continue;
                es[w++] = es[i];
            }
            for (i = this.elementCount = w; i < end; ++i) {
                es[i] = null;
            }
            return true;
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> c.contains(e));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int numMoved;
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Object[] a = c.toArray();
        ++this.modCount;
        int numNew = a.length;
        if (numNew == 0) {
            return false;
        }
        Object[] elementData = this.elementData;
        int s = this.elementCount;
        if (numNew > elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        if ((numMoved = s - index) > 0) {
            System.arraycopy(elementData, index, elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, elementData, index, numNew);
        this.elementCount = s + numNew;
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new NonSynchronizedSubVector(this, fromIndex, toIndex);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.shiftTailOverGap(this.elementData, fromIndex, toIndex);
    }

    private void shiftTailOverGap(Object[] es, int lo, int hi) {
        System.arraycopy(es, hi, es, lo, this.elementCount - hi);
        int to = this.elementCount;
        for (int i = this.elementCount -= hi - lo; i < to; ++i) {
            es[i] = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Object[] es = this.elementData;
        int size = this.elementCount;
        for (int i = 0; this.modCount == expectedModCount && i < size; ++i) {
            action.accept(NonSynchronizedVector.elementAt(es, i));
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            li.set(operator.apply(li.next()));
        }
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Object[] a = this.toArray();
        Arrays.sort(a, c);
        ListIterator<Object> i = this.listIterator();
        for (Object e : a) {
            i.next();
            i.set(e);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new VectorSpliterator(null, 0, -1, 0);
    }

    static /* synthetic */ int access$200(NonSynchronizedVector x0) {
        return x0.modCount;
    }

    final class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            this.cursor = i;
            this.lastRet = i;
            return NonSynchronizedVector.this.elementData(this.lastRet);
        }

        @Override
        public void set(E e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            NonSynchronizedVector.this.set(this.lastRet, e);
        }

        @Override
        public void add(E e) {
            int i = this.cursor;
            this.checkForComodification();
            NonSynchronizedVector.this.add(i, e);
            this.expectedModCount = NonSynchronizedVector.this.modCount;
            this.cursor = i + 1;
            this.lastRet = -1;
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount = NonSynchronizedVector.access$200(NonSynchronizedVector.this);

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != NonSynchronizedVector.this.elementCount;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= NonSynchronizedVector.this.elementCount) {
                throw new NoSuchElementException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return NonSynchronizedVector.this.elementData(this.lastRet);
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            NonSynchronizedVector.this.remove(this.lastRet);
            this.expectedModCount = NonSynchronizedVector.this.modCount;
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int size = NonSynchronizedVector.this.elementCount;
            int i = this.cursor;
            if (i >= size) {
                return;
            }
            Object[] es = NonSynchronizedVector.this.elementData;
            if (i >= es.length) {
                throw new ConcurrentModificationException();
            }
            while (i < size && NonSynchronizedVector.this.modCount == this.expectedModCount) {
                action.accept(NonSynchronizedVector.elementAt(es, i++));
            }
            this.cursor = i;
            this.lastRet = i - 1;
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (NonSynchronizedVector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class VectorSpliterator
    implements Spliterator<E> {
        private Object[] array;
        private int index;
        private int fence;
        private int expectedModCount;

        VectorSpliterator(Object[] array, int origin, int fence, int expectedModCount) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.array = NonSynchronizedVector.this.elementData;
                this.expectedModCount = NonSynchronizedVector.this.modCount;
                hi = this.fence = NonSynchronizedVector.this.elementCount;
            }
            return hi;
        }

        @Override
        public Spliterator<E> trySplit() {
            VectorSpliterator vectorSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                vectorSpliterator = null;
            } else {
                this.index = mid;
                VectorSpliterator vectorSpliterator2 = new VectorSpliterator(this.array, lo, this.index, this.expectedModCount);
                vectorSpliterator = vectorSpliterator2;
            }
            return vectorSpliterator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int i = this.index;
            if (this.getFence() > i) {
                this.index = i + 1;
                action.accept(this.array[i]);
                if (NonSynchronizedVector.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int hi = this.getFence();
            Object[] a = this.array;
            this.index = hi;
            for (int i = this.index; i < hi; ++i) {
                action.accept(a[i]);
            }
            if (NonSynchronizedVector.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

