package org.eclipse.ecf.ai.mcp.tools.util;

import org.eclipse.ecf.ai.mcp.tools.annotation.ToolAnnotations;

/**
 * Describes the ToolAnnotations type in the MCP schema (draft as of 5/18/2025)
 * located <a href=
 * "https://github.com/modelcontextprotocol/modelcontextprotocol/blob/main/schema/draft/schema.json#L2164">here</a>
 */
public record ToolAnnotationsDescription(boolean destructiveHint, boolean idempotentHint, boolean openWorldHint,
		boolean readOnlyHint, String title) {

	public static ToolAnnotationsDescription fromAnnotations(ToolAnnotations annotations) {
		if (annotations != null) {
			return new ToolAnnotationsDescription(annotations.destructiveHint(), annotations.idempotentHint(),
					annotations.openWorldHint(), annotations.readOnlyHint(), annotations.title());
		} else {
			return null;
		}
	}
}
