/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.jms.container.AbstractJMSServer;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.provider.jms.mqtt.container.AbstractMqttContainerInstantiator;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttJMSServerChannel;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttJMSServerContainer
extends AbstractJMSServer {
    public static final String DEFAULT_SERVER_ID = "tcp://iot.eclipse.org:1883/exampleTopic";
    public static final String MQTT_MANAGER_NAME = "ecf.jms.mqtt.manager";
    private MqttConnectOptions mqttConnectOptions;
    private int qos;

    public void disconnect() {
        super.disconnect();
        ISynchAsynchConnection conn = this.getConnection();
        if (conn != null) {
            conn.disconnect();
        }
        this.setConnection(null);
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }

    public MqttJMSServerContainer(JMSContainerConfig config, MqttConnectOptions connectOptions, int qos) {
        super(config);
        this.mqttConnectOptions = connectOptions;
        this.qos = qos;
    }

    public void start() throws ECFException {
        MqttJMSServerChannel connection = new MqttJMSServerChannel(this.getReceiver(), this.getJMSContainerConfig().getKeepAlive(), this.mqttConnectOptions, this.qos);
        this.setConnection((ISynchAsynchConnection)connection);
        connection.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instantiator
    extends AbstractMqttContainerInstantiator {
        private static List<String> exporters = Arrays.asList("ecf.jms.mqtt.manager", "ecf.jms.mqtt.client");
        private static Map<String, List<String>> exporterToImportersMap = new HashMap<String, List<String>>();

        static {
            exporterToImportersMap.put(MqttJMSServerContainer.MQTT_MANAGER_NAME, Arrays.asList("ecf.jms.mqtt.client"));
            exporterToImportersMap.put("ecf.jms.mqtt.client", Arrays.asList(MqttJMSServerContainer.MQTT_MANAGER_NAME));
        }

        public Instantiator() {
            super(exporters, exporterToImportersMap);
        }

        @Override
        protected IContainer createMqttContainer(JMSContainerConfig config, MqttConnectOptions options, int qos, Map<String, ?> parameters) throws Exception {
            MqttJMSServerContainer server = new MqttJMSServerContainer(config, options, qos);
            server.start();
            return server;
        }

        @Override
        protected JMSID createContainerID(Map<String, ?> parameters) throws Exception {
            return this.getJMSIDFromParameter(parameters.get("id"), MqttJMSServerContainer.DEFAULT_SERVER_ID);
        }
    }
}

