/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.JMSException;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MQTTMessage {
    private byte[] data;
    private String correlationId;
    private static byte[] ECFPREFIX = new byte[]{27, 69, 67, 70};

    private MQTTMessage(String correlationId, byte[] data) {
        this.data = data;
        this.correlationId = correlationId;
    }

    String getCorrelationId() {
        return this.correlationId;
    }

    byte[] getData() {
        return this.data;
    }

    static void send(final MqttAsyncClient client, final String topic, byte[] message, String jmsCorrelationId) throws JMSException {
        try {
            ByteArrayOutputStream bouts = new ByteArrayOutputStream();
            bouts.write(ECFPREFIX);
            ObjectOutputStream oos = new ObjectOutputStream(bouts);
            oos.writeObject(jmsCorrelationId);
            oos.writeObject(message);
            final MqttMessage m = new MqttMessage(bouts.toByteArray());
            m.setRetained(false);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        client.publish(topic, m);
                    }
                    catch (MqttException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (Exception e) {
            JMSException t = new JMSException(e.getMessage());
            t.setStackTrace(e.getStackTrace());
            throw t;
        }
    }

    static MQTTMessage receive(byte[] bytes) throws Exception {
        if (!MQTTMessage.checkMessagePrefix(bytes)) {
            return null;
        }
        ByteArrayInputStream bins = new ByteArrayInputStream(bytes, ECFPREFIX.length, bytes.length - ECFPREFIX.length);
        ObjectInputStream oos = new ObjectInputStream(bins);
        return new MQTTMessage((String)oos.readObject(), (byte[])oos.readObject());
    }

    private static boolean checkMessagePrefix(byte[] bytes) {
        int i = 0;
        while (i < ECFPREFIX.length) {
            if (ECFPREFIX[i] != bytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

