/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.tooling.bndtools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ecf.remoteservices.tooling.bndtools.Activator;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class PreferencesComponent {
    @Reference
    IPreferencesService prefs;

    private Repo getRepoParameters(InputStream ins) {
        Repo result = new Repo();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(ins));){
                while (reader.ready()) {
                    result.mergeWith(new Repo(reader.readLine()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Activate
    void activate(BundleContext bundleContext) {
        Repo ecfRepos;
        Bundle b2;
        Enumeration entries;
        List bundles = Arrays.asList(bundleContext.getBundles()).stream().filter(b -> b.getSymbolicName().equals("org.bndtools.templating.gitrepo")).collect(Collectors.toList());
        Repo bndtoolsRepos = new Repo();
        if (bundles.size() > 0 && (entries = (b2 = (Bundle)bundles.get(0)).findEntries("org/bndtools/templating/jgit", "initialrepos.txt", false)) != null && entries.hasMoreElements()) {
            try {
                bndtoolsRepos = this.getRepoParameters(((URL)entries.nextElement()).openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((ecfRepos = this.getRepoParameters(Activator.class.getResourceAsStream("ecfrepos.txt"))).size() > 0) {
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.bndtools.templating.gitrepo");
            store.setDefault("githubRepos", bndtoolsRepos.toString());
            bndtoolsRepos.mergeWith(ecfRepos);
            store.setValue("githubRepos", bndtoolsRepos.toString());
        }
    }

    static class Attrs
    extends HashMap<String, String> {
        private static final long serialVersionUID = -4017513476270109969L;
        private String name;

        public Attrs() {
        }

        public Attrs(Attrs a) {
            this.mergeWith(a);
        }

        void mergeWith(Attrs a) {
            if (a.name != null) {
                this.name = a.name;
            }
            for (Map.Entry e : a.entrySet()) {
                this.put((String)e.getKey(), (String)e.getValue());
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append("name=").append(this.name);
            }
            String del = "";
            for (Map.Entry e : this.entrySet()) {
                sb.append(del);
                sb.append((String)e.getKey());
                sb.append("=");
                sb.append((String)e.getValue());
                del = ";";
            }
            return sb.toString();
        }
    }

    class Repo
    extends HashMap<String, Attrs> {
        private static final long serialVersionUID = -7604521690360522452L;

        static void parseRepo(Repo r, String s) {
            String[] repos = s.split(",");
            if (repos != null && repos.length > 0) {
                String[] stringArray = repos;
                int n = repos.length;
                int n2 = 0;
                while (n2 < n) {
                    String repo = stringArray[n2];
                    String[] parts = repo.split(";");
                    if (parts != null && parts.length > 0) {
                        String githuburl = parts[0].trim();
                        Attrs attrs = new Attrs();
                        if (parts.length > 1) {
                            int i = 1;
                            while (i < parts.length) {
                                String[] parts2 = parts[i].split("=");
                                attrs.put(parts2[0].strip(), parts2[1].strip());
                                ++i;
                            }
                        }
                        r.put(githuburl, attrs);
                    }
                    ++n2;
                }
            }
        }

        public Repo() {
        }

        public Repo(String s) {
            Repo.parseRepo(this, s);
        }

        public void mergeWith(Repo r) {
            for (Map.Entry e : r.entrySet()) {
                Attrs existing = (Attrs)this.get(e.getKey());
                if (existing == null) {
                    this.put((String)e.getKey(), new Attrs((Attrs)e.getValue()));
                    continue;
                }
                existing.mergeWith((Attrs)e.getValue());
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            String del = "";
            for (Map.Entry e : this.entrySet()) {
                sb.append(del);
                sb.append((String)e.getKey());
                Attrs value = (Attrs)e.getValue();
                if (!value.isEmpty()) {
                    sb.append(";");
                    sb.append(((Attrs)e.getValue()).toString());
                }
                del = ",";
            }
            return sb.toString();
        }
    }
}

