/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservices.ui;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ui.DiscoveryHandlerUtil;
import org.eclipse.ecf.internal.remoteservices.ui.Activator;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteServiceHandlerUtil {
    public static IRemoteServiceContainerAdapter getActiveIRemoteServiceContainerAdapterChecked(ExecutionEvent event) throws ExecutionException {
        ID activeConnectId = RemoteServiceHandlerUtil.getActiveConnectIDChecked(event);
        IContainer container = RemoteServiceHandlerUtil.getContainerWithConnectID(activeConnectId);
        if (container == null) {
            return null;
        }
        IRemoteServiceContainerAdapter adapter = (IRemoteServiceContainerAdapter)container.getAdapter(IRemoteServiceContainerAdapter.class);
        return adapter;
    }

    public static IRemoteServiceReference[] getActiveIRemoteServiceReferencesChecked(ExecutionEvent event) throws ExecutionException {
        IServiceInfo serviceInfo = DiscoveryHandlerUtil.getActiveIServiceInfoChecked((ExecutionEvent)event);
        IRemoteServiceContainerAdapter adapter = RemoteServiceHandlerUtil.getActiveIRemoteServiceContainerAdapterChecked(event);
        try {
            return RemoteServiceHandlerUtil.getRemoteServiceReferencesForRemoteServiceAdapter(adapter, serviceInfo);
        }
        catch (IDCreateException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public static ID getActiveConnectIDChecked(ExecutionEvent event) throws ExecutionException {
        IServiceInfo serviceInfo = DiscoveryHandlerUtil.getActiveIServiceInfoChecked((ExecutionEvent)event);
        String connectNamespace = RemoteServiceHandlerUtil.getConnectNamespace(serviceInfo);
        String connectId = RemoteServiceHandlerUtil.getConnectID(serviceInfo);
        try {
            return IDFactory.getDefault().createID(connectNamespace, connectId);
        }
        catch (IDCreateException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public static IContainer getActiveIRemoteServiceContainerChecked(ExecutionEvent event) throws ExecutionException {
        IServiceInfo serviceInfo = DiscoveryHandlerUtil.getActiveIServiceInfoChecked((ExecutionEvent)event);
        ID createConnectId = RemoteServiceHandlerUtil.getActiveConnectIDChecked(event);
        IContainer container = RemoteServiceHandlerUtil.getContainerWithConnectID(createConnectId);
        if (container != null) {
            return container;
        }
        Object[] parameters = new Object[]{createConnectId};
        try {
            return ContainerFactory.getDefault().createContainer(RemoteServiceHandlerUtil.getContainerFactory(serviceInfo), parameters);
        }
        catch (ContainerCreateException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private static IContainer getContainerWithConnectID(ID aConnectedID) {
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        IContainer[] containers = containerManager.getAllContainers();
        if (containers == null) {
            return null;
        }
        int i = 0;
        while (i < containers.length) {
            ID connectedId = containers[i].getConnectedID();
            if (connectedId != null && connectedId.equals((Object)aConnectedID)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    private static IRemoteServiceReference[] getRemoteServiceReferencesForRemoteServiceAdapter(IRemoteServiceContainerAdapter adapter, IServiceInfo serviceInfo) throws InvalidSyntaxException, IDCreateException {
        ID[] iDArray;
        ID serviceID = null;
        String serviceNamespace = RemoteServiceHandlerUtil.getServiceNamespace(serviceInfo);
        String serviceid = RemoteServiceHandlerUtil.getServiceID(serviceInfo);
        if (serviceNamespace != null && serviceid != null) {
            serviceID = IDFactory.getDefault().createID(serviceNamespace, serviceid);
        }
        if (serviceID == null) {
            iDArray = null;
        } else {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = serviceID;
        }
        ID[] targets = iDArray;
        return adapter.getRemoteServiceReferences(targets, RemoteServiceHandlerUtil.getRemoteServiceClass(serviceInfo), null);
    }

    private static String getServiceNamespace(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("ecf.endpoint.id.ns");
    }

    private static String getServiceID(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("ecf.endpoint.id");
    }

    private static String getRemoteServiceClass(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("objectClass");
    }

    private static String getConnectNamespace(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("ecf.endpoint.id.ns");
    }

    private static String getConnectID(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("ecf.endpoint.connecttarget.id");
    }

    private static String getContainerFactory(IServiceInfo serviceInfo) {
        return serviceInfo.getServiceProperties().getPropertyString("service.imported.configs");
    }
}

