/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;

public class XMPPIncomingFileTransfer
implements IIncomingFileTransfer {
    public static final int DEFAULT_BUF_LENGTH = 4096;
    protected int buff_length = 4096;
    ID threadID = null;
    InputStream remoteFileContents = null;
    OutputStream localFileContents = null;
    IFileTransferListener listener = null;
    Exception exception;
    long bytesReceived = 0L;
    long fileLength = -1L;
    Job job = null;
    boolean done = false;
    String fileName;

    protected IStatus getFinalStatus(Throwable exception) {
        return exception == null ? new Status(0, "org.eclipse.ecf.provider.xmpp", 0, Messages.XMPPIncomingFileTransfer_Status_Transfer_Completed_OK, null) : new Status(4, "org.eclipse.ecf.provider.xmpp", 4, Messages.XMPPIncomingFileTransfer_Status_Transfer_Exception, exception);
    }

    protected void hardClose() {
        try {
            if (this.remoteFileContents != null) {
                this.remoteFileContents.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.job = null;
        this.remoteFileContents = null;
        this.localFileContents = null;
    }

    protected void fireTransferReceiveDoneEvent() {
        if (this.listener != null) {
            this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDoneEvent(){

                public IIncomingFileTransfer getSource() {
                    return XMPPIncomingFileTransfer.this;
                }

                public Exception getException() {
                    return XMPPIncomingFileTransfer.this.getException();
                }

                public String toString() {
                    StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveDoneEvent[");
                    sb.append("isDone=").append(XMPPIncomingFileTransfer.this.done).append(";");
                    sb.append("bytesReceived=").append(XMPPIncomingFileTransfer.this.bytesReceived).append("]");
                    return sb.toString();
                }
            });
        }
    }

    protected void fireTransferReceiveDataEvent() {
        if (this.listener != null) {
            this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDataEvent(){

                public IIncomingFileTransfer getSource() {
                    return XMPPIncomingFileTransfer.this;
                }

                public String toString() {
                    StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveDataEvent[");
                    sb.append("isDone=").append(XMPPIncomingFileTransfer.this.done).append(";");
                    sb.append("bytesReceived=").append(XMPPIncomingFileTransfer.this.bytesReceived).append(";");
                    sb.append("percentComplete=").append(XMPPIncomingFileTransfer.this.getPercentComplete() * 100.0).append("]");
                    return sb.toString();
                }
            });
        }
    }

    public XMPPIncomingFileTransfer(ID threadID, String fileName, InputStream inputStream, OutputStream outputStream, long fileSize, IFileTransferListener listener) {
        this.threadID = threadID;
        this.fileName = fileName;
        this.remoteFileContents = inputStream;
        this.localFileContents = outputStream;
        this.fileLength = fileSize;
        this.listener = listener;
        this.job = new FileTransferJob(threadID.getName());
        this.job.schedule();
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public IFileTransferListener getListener() {
        return this.listener;
    }

    public void cancel() {
        if (this.job != null) {
            this.job.cancel();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        return (double)this.bytesReceived / (double)this.fileLength;
    }

    public boolean isDone() {
        return this.done;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public ID getID() {
        return this.threadID;
    }

    public IFileRangeSpecification getFileRangeSpecification() {
        return null;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public String getRemoteFileName() {
        return this.fileName;
    }

    public Date getRemoteLastModified() {
        return null;
    }

    class FileTransferJob
    extends Job {
        public FileTransferJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            block8: {
                byte[] buf = new byte[XMPPIncomingFileTransfer.this.buff_length];
                int totalWork = XMPPIncomingFileTransfer.this.fileLength == -1L ? 100 : (int)XMPPIncomingFileTransfer.this.fileLength;
                monitor.beginTask(String.valueOf(XMPPIncomingFileTransfer.this.getID().getName()) + Messages.XMPPIncomingFileTransfer_Progress_Data, totalWork);
                try {
                    try {
                        while (!XMPPIncomingFileTransfer.this.isDone()) {
                            if (monitor.isCanceled()) {
                                throw new UserCancelledException(Messages.XMPPIncomingFileTransfer_Exception_User_Cancelled);
                            }
                            int bytes = XMPPIncomingFileTransfer.this.remoteFileContents.read(buf);
                            if (bytes != -1) {
                                XMPPIncomingFileTransfer.this.bytesReceived += (long)bytes;
                                XMPPIncomingFileTransfer.this.localFileContents.write(buf, 0, bytes);
                                XMPPIncomingFileTransfer.this.fireTransferReceiveDataEvent();
                                monitor.worked(bytes);
                                continue;
                            }
                            XMPPIncomingFileTransfer.this.done = true;
                        }
                    }
                    catch (Exception e) {
                        XMPPIncomingFileTransfer.this.exception = e;
                        XMPPIncomingFileTransfer.this.done = true;
                        XMPPIncomingFileTransfer.this.hardClose();
                        monitor.done();
                        XMPPIncomingFileTransfer.this.fireTransferReceiveDoneEvent();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    XMPPIncomingFileTransfer.this.hardClose();
                    monitor.done();
                    XMPPIncomingFileTransfer.this.fireTransferReceiveDoneEvent();
                    throw throwable;
                }
                XMPPIncomingFileTransfer.this.hardClose();
                monitor.done();
                XMPPIncomingFileTransfer.this.fireTransferReceiveDoneEvent();
            }
            return XMPPIncomingFileTransfer.this.getFinalStatus(XMPPIncomingFileTransfer.this.exception);
        }
    }
}

