/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.identity;

import java.net.URI;
import java.net.URL;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.rest.identity.RestID;

public class RestNamespace
extends Namespace {
    private static final long serialVersionUID = -398861350452016954L;
    public static Namespace INSTANCE;
    public static final String NAME = "ecf.rest.namespace";
    public static final String SCHEME = "rest";

    public RestNamespace() {
        super(NAME, "RestID Namespace");
        INSTANCE = this;
    }

    public RestNamespace(String name, String desc) {
        super(name, desc);
    }

    private String getInitFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + ":")) {
            int index = arg.indexOf(":");
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public ID createInstance(Object[] parameters) throws IDCreateException {
        URI uri = null;
        try {
            String init = this.getInitFromExternalForm(parameters);
            if (init != null) {
                uri = URI.create(init);
                return new RestID(this, uri);
            }
            if (parameters != null) {
                if (parameters[0] instanceof URI) {
                    return new RestID(this, (URI)parameters[0]);
                }
                if (parameters[0] instanceof String) {
                    return new RestID(this, URI.create((String)parameters[0]));
                }
                if (parameters[0] instanceof URL) {
                    return new RestID(this, URI.create(((URL)parameters[0]).toExternalForm()));
                }
                if (parameters[0] instanceof RestID) {
                    return (ID)parameters[0];
                }
            }
            throw new IllegalArgumentException("Invalid parameters to RestID creation");
        }
        catch (Exception e) {
            throw new IDCreateException("Could not create rest ID", (Throwable)e);
        }
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{ID.class}, {URI.class}, {String.class}, {URL.class}};
    }
}

