/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.wizards;

import java.util.regex.Matcher;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class EclipseXMPPSConnectWizardPage
extends XMPPConnectWizardPage {
    private static final String ECLIPSE_XMPP_HOST = System.getProperty("org.eclipse.ecf.provider.xmpp.ui.eclipseXMPPServer", "xmpp.eclipse.org");

    EclipseXMPPSConnectWizardPage() {
        this.setTitle("Eclipse IM Connection Wizard");
        this.setDescription("Eclipse Bugzilla Account - Please login using your Eclipse Bugzilla username and password");
        this.setPageComplete(false);
    }

    EclipseXMPPSConnectWizardPage(String usernameAtHost) {
        this();
        this.usernameAtHost = usernameAtHost;
    }

    private void verify() {
        String text = this.connectText.getText();
        if (text.equals("")) {
            this.updateStatus("A valid Bugzilla account must be specified");
        } else {
            Matcher matcher = emailPattern.matcher(text);
            if (!matcher.matches()) {
                this.updateStatus("Invalid Bugzilla account information");
            } else {
                this.restorePassword(text);
                this.updateStatus(null);
            }
        }
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        GridData fillData = new GridData(4, 0x1000000, true, false);
        GridData endData = new GridData(4, 0x1000000, true, false, 2, 1);
        Label label = new Label(parent, 16384);
        label.setText("Bugzilla Username:");
        this.connectText = new Combo(parent, 2052);
        this.connectText.setLayoutData((Object)fillData);
        this.connectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EclipseXMPPSConnectWizardPage.this.verify();
            }
        });
        this.connectText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EclipseXMPPSConnectWizardPage.this.verify();
            }

            public void widgetSelected(SelectionEvent e) {
                EclipseXMPPSConnectWizardPage.this.verify();
            }
        });
        label = new Label(parent, 131072);
        label.setText("<email address>");
        label.setLayoutData((Object)endData);
        label = new Label(parent, 16384);
        label.setText(Messages.XMPPSConnectWizardPage_WIZARD_PAGE_PASSWORD);
        this.passwordText = new Text(parent, 0x400804);
        this.passwordText.setLayoutData((Object)fillData);
        this.restoreCombo();
        if (this.usernameAtHost != null) {
            this.connectText.setText(this.usernameAtHost);
            this.restorePassword(this.usernameAtHost);
            this.passwordText.setFocus();
        }
        this.verify();
        if (this.connectText.getText().equals("")) {
            this.updateStatus(null);
            this.setPageComplete(false);
        } else if (this.isPageComplete()) {
            this.passwordText.setFocus();
        }
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    String getConnectID() {
        String bugzillaAccount = this.connectText.getText();
        if (!bugzillaAccount.endsWith(ECLIPSE_XMPP_HOST)) {
            return String.valueOf(bugzillaAccount) + "@" + ECLIPSE_XMPP_HOST;
        }
        return bugzillaAccount;
    }
}

