/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferRequestEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.ui.Activator;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizardPage;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageEvent;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.presence.ui.MultiRosterView;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class XMPPConnectWizard
extends Wizard
implements IConnectWizard,
INewWizard {
    XMPPConnectWizardPage page;
    private Shell shell;
    protected IContainer container;
    private ID targetID;
    private IConnectContext connectContext;
    protected String usernameAtHost;
    protected IIncomingFileTransferRequestListener requestListener = new IIncomingFileTransferRequestListener(){

        public void handleFileTransferRequest(final IFileTransferRequestEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    String username = event.getRequesterID().getName();
                    IFileTransferInfo transferInfo = event.getFileTransferInfo();
                    String fileName = transferInfo.getFile().getName();
                    Object[] bindings = new Object[]{username, fileName, transferInfo.getFileSize() == -1L ? "unknown" : String.valueOf(transferInfo.getFileSize()) + " bytes", transferInfo.getDescription() == null ? "none" : transferInfo.getDescription()};
                    if (MessageDialog.openQuestion((Shell)XMPPConnectWizard.this.shell, (String)NLS.bind((String)Messages.XMPPConnectWizard_FILE_RECEIVE_TITLE, (Object)username), (String)NLS.bind((String)Messages.XMPPConnectWizard_FILE_RECEIVE_MESSAGE, (Object[])bindings))) {
                        FileDialog fd = new FileDialog(XMPPConnectWizard.this.shell, 4096);
                        fd.setFilterPath(System.getProperty("user.home"));
                        fd.setFileName(fileName);
                        int suffixLoc = fileName.lastIndexOf(46);
                        if (suffixLoc != -1) {
                            String ext = fileName.substring(fileName.lastIndexOf(46));
                            fd.setFilterExtensions(new String[]{ext});
                        }
                        fd.setText(NLS.bind((String)Messages.XMPPConnectWizard_FILE_SAVE_TITLE, (Object)username));
                        String res = fd.open();
                        if (res == null) {
                            event.reject();
                        } else {
                            try {
                                final FileOutputStream fos = new FileOutputStream(new File(res));
                                event.accept((OutputStream)fos, new IFileTransferListener(){

                                    public void handleTransferEvent(IFileTransferEvent event) {
                                        if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                                            try {
                                                fos.close();
                                            }
                                            catch (IOException iOException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)XMPPConnectWizard.this.shell, (String)Messages.XMPPConnectWizard_RECEIVE_ERROR_TITLE, (String)NLS.bind((String)Messages.XMPPConnectWizard_RECEIVE_ERROR_MESSAGE, (Object[])new Object[]{fileName, username, e.getLocalizedMessage()}));
                            }
                        }
                    } else {
                        event.reject();
                    }
                }
            });
        }
    };
    private IWorkbench workbench;
    private IChatMessageSender icms;
    private ITypingMessageSender itms;

    public XMPPConnectWizard() {
    }

    public XMPPConnectWizard(String usernameAtHost) {
        this();
        this.usernameAtHost = usernameAtHost;
    }

    public void addPages() {
        this.page = new XMPPConnectWizardPage(this.usernameAtHost);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        this.container = container;
        this.workbench = workbench;
        this.setWindowTitle(Messages.XMPPConnectWizard_WIZARD_TITLE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.shell = workbench.getActiveWorkbenchWindow().getShell();
        this.workbench = workbench;
        this.container = null;
        try {
            this.container = ContainerFactory.getDefault().createContainer("ecf.xmpp.smack");
        }
        catch (ContainerCreateException containerCreateException) {
            // empty catch block
        }
        this.setWindowTitle(Messages.XMPPConnectWizard_WIZARD_TITLE);
    }

    private void openView() {
        try {
            MultiRosterView view = (MultiRosterView)this.workbench.getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ecf.presence.ui.MultiRosterView");
            view.addContainer(this.container);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private boolean compareChatUsers(ID id1, ID id2) {
        IChatID cid1 = (IChatID)id1.getAdapter(IChatID.class);
        IChatID cid2 = (IChatID)id2.getAdapter(IChatID.class);
        if (cid1 == null || cid2 == null) {
            return false;
        }
        return cid1.getUsername().equals(cid2.getUsername()) && cid1.getHostname().equals(cid2.getHostname());
    }

    private String findNicknameForID(ID id, Collection items) {
        for (IRosterItem item : items) {
            if (item instanceof IRosterEntry) {
                IUser user = ((IRosterEntry)item).getUser();
                if (!this.compareChatUsers(id, user.getID())) continue;
                return user.getName();
            }
            if (!(item instanceof IRosterGroup)) continue;
            return this.findNicknameForID(id, ((IRosterGroup)item).getEntries());
        }
        return null;
    }

    private String getNickname(ID id) {
        String nickname = id.getName();
        IPresenceContainerAdapter pca = (IPresenceContainerAdapter)this.container.getAdapter(IPresenceContainerAdapter.class);
        if (pca != null) {
            String nick;
            IRosterManager rosterManager = pca.getRosterManager();
            if (rosterManager != null && (nick = this.findNicknameForID(id, rosterManager.getRoster().getItems())) != null) {
                nickname = nick;
            }
        } else {
            IChatID chatID = (IChatID)id.getAdapter(IChatID.class);
            nickname = chatID == null ? id.getName() : chatID.getUsername();
        }
        return nickname;
    }

    private void displayMessage(IChatMessageEvent e) {
        final IChatMessage message = e.getChatMessage();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                    view.openTab(XMPPConnectWizard.this.icms, XMPPConnectWizard.this.itms, XMPPConnectWizard.this.targetID, message.getFromID(), XMPPConnectWizard.this.getNickname(message.getFromID()));
                    view.showMessage(message);
                    service.warnOfContentChange();
                } else {
                    try {
                        IWorkbenchPage page = XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage();
                        view = (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView", null, 3);
                        if (!page.isPartVisible((IWorkbenchPart)view)) {
                            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                            service.warnOfContentChange();
                        }
                        view.openTab(XMPPConnectWizard.this.icms, XMPPConnectWizard.this.itms, XMPPConnectWizard.this.targetID, message.getFromID(), XMPPConnectWizard.this.getNickname(message.getFromID()));
                        view.showMessage(message);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void displayTypingNotification(final ITypingMessageEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessagesView view = (MessagesView)XMPPConnectWizard.this.workbench.getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ecf.presence.ui.MessagesView");
                if (view != null) {
                    view.displayTypingNotification(e);
                }
            }
        });
    }

    public boolean performCancel() {
        if (this.container != null) {
            this.container.dispose();
            IContainerManager containerManager = Activator.getDefault().getContainerManager();
            if (containerManager != null) {
                containerManager.removeContainer(this.container);
            }
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        final String connectID = this.page.getConnectID();
        final String password = this.page.getPassword();
        this.page.saveComboText();
        this.connectContext = this.createConnectContext();
        try {
            this.targetID = IDFactory.getDefault().createID(this.container.getConnectNamespace(), connectID);
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, connectID, e).open();
            return false;
        }
        this.page.saveComboItems();
        IPresenceContainerAdapter adapter = (IPresenceContainerAdapter)this.container.getAdapter(IPresenceContainerAdapter.class);
        this.container.addListener(new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerConnectedEvent) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            XMPPConnectWizard.this.openView();
                        }
                    });
                }
            }
        });
        IChatManager icm = adapter.getChatManager();
        this.icms = icm.getChatMessageSender();
        this.itms = icm.getTypingMessageSender();
        icm.addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent e) {
                if (e instanceof IChatMessageEvent) {
                    XMPPConnectWizard.this.displayMessage((IChatMessageEvent)e);
                } else if (e instanceof ITypingMessageEvent) {
                    XMPPConnectWizard.this.displayTypingNotification((ITypingMessageEvent)e);
                }
            }
        });
        ISendFileTransferContainerAdapter ioftca = (ISendFileTransferContainerAdapter)this.container.getAdapter(ISendFileTransferContainerAdapter.class);
        ioftca.addListener(this.requestListener);
        new AsynchContainerConnectAction(this.container, this.targetID, this.connectContext, null, new Runnable(){

            public void run() {
                XMPPConnectWizard.this.cachePassword(connectID, password);
            }
        }).run();
        return true;
    }

    protected void cachePassword(String connectID, String password) {
        if (password != null && !password.equals("")) {
            PasswordCacheHelper pwStorage = new PasswordCacheHelper(connectID);
            pwStorage.savePassword(password);
        }
    }

    protected IConnectContext createConnectContext() {
        return ConnectContextFactory.createPasswordConnectContext((String)this.page.getPassword());
    }
}

