/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.provider.IdentifiableTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpecHierarchyTest
extends IdentifiableTest {
    private ReqIF reqif;

    @Before
    public void setupReqif() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
    }

    protected SpecHierarchy getFixture() {
        return (SpecHierarchy)this.fixture;
    }

    @Before
    public void setUpSpecHierarchyTest() throws Exception {
        this.setFixture((Identifiable)ReqIF10Factory.eINSTANCE.createSpecHierarchy());
    }

    @After
    public void tearDownSpecHierarchyTest() throws Exception {
        this.setFixture(null);
    }

    @Test
    public void testPropertiesOfSpecElementWithAttribute() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.setViaCommand(reqif.getCoreContent().getSpecifications().get(0), (EStructuralFeature)ReqIF10Package.Literals.SPECIFICATION__CHILDREN, this.getFixture());
        SpecObject specObject = (SpecObject)reqif.getCoreContent().getSpecObjects().get(0);
        this.getFixture().setObject(specObject);
        ItemProviderAdapter ip = this.getItemProvider(this.getFixture());
        HashSet<String> expected = new HashSet<String>();
        for (IItemPropertyDescriptor prop : ip.getPropertyDescriptors((Object)this.getFixture())) {
            expected.add(String.valueOf(prop.getCategory((Object)this.getFixture())) + "-" + prop.getDisplayName((Object)this.getFixture()));
        }
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.adapterFactory.adapt((Notifier)ad, IItemLabelProvider.class);
        this.adapterFactory.adapt((Notifier)specObject.getType(), IItemLabelProvider.class);
        this.adapterFactory.adapt((Notifier)specObject, IItemLabelProvider.class);
        this.adapterFactory.adapt((Notifier)this.getFixture(), IItemLabelProvider.class);
        ad.setLongName("New");
        this.setViaCommand(specObject.getType(), (EStructuralFeature)ReqIF10Package.Literals.SPEC_TYPE__SPEC_ATTRIBUTES, ad);
        Assert.assertEquals((long)(expected.size() + 1), (long)ip.getPropertyDescriptors((Object)this.getFixture()).size());
        HashSet<String> actual = new HashSet<String>();
        for (IItemPropertyDescriptor prop : ip.getPropertyDescriptors((Object)this.getFixture())) {
            actual.add(String.valueOf(prop.getCategory((Object)this.getFixture())) + "-" + prop.getDisplayName((Object)this.getFixture()));
        }
        expected.add("Example SpecType-New");
        Assert.assertEquals(expected, actual);
    }

    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getSpecification_Children();
    }

    protected EObject getParent() {
        return (EObject)this.reqif.getCoreContent().getSpecifications().get(0);
    }

    @Test
    public void testSetLastChangeAfterMoving() {
    }
}

