/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;

public class ProrXhtmlSimplifiedHelper {
    private static String newLine = System.getProperty("line.separator");

    public static String generateXMLString(EObject eobject) throws IOException {
        StringWriter sw = new StringWriter();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ROOT_OBJECTS", Collections.singletonList(eobject));
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        options.put("DECLARE_XML", Boolean.TRUE);
        options.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.FALSE);
        XMLResourceImpl ri = new XMLResourceImpl();
        ri.save((Writer)sw, options);
        return sw.toString();
    }

    public static String xhtmlToSimplifiedString(XhtmlContent xhtmlContent) {
        String stringValue = "";
        try {
            stringValue = ProrXhtmlSimplifiedHelper.generateXMLString((EObject)xhtmlContent);
            stringValue = stringValue.replaceAll(newLine, "");
            stringValue = stringValue.replaceAll(" +", " ");
            stringValue = stringValue.replaceAll("\\<xhtml:br/\\>", newLine);
            stringValue = stringValue.replaceAll("\\</xhtml:p\\>", String.valueOf(newLine) + newLine);
            stringValue = stringValue.replaceAll("\\<xhtml:li\\>", "- ");
            stringValue = stringValue.replaceAll("\\<xhtml:ul\\>", newLine);
            stringValue = stringValue.replaceAll("\\</xhtml:ul\\>", newLine);
            stringValue = stringValue.replaceAll("\\<xhtml:ol\\>", newLine);
            stringValue = stringValue.replaceAll("\\</xhtml:ol\\>", newLine);
            stringValue = stringValue.replaceAll("\\</xhtml:li\\>", newLine);
            stringValue = stringValue.replaceAll("\\</xhtml:div\\>", newLine);
            stringValue = stringValue.replaceAll("\\<.*?\\>", " ");
            stringValue = stringValue.trim();
        }
        catch (IOException iOException) {}
        return stringValue;
    }

    public static XhtmlDivType stringToSimplifiedXhtml(String str) {
        XhtmlDivType div = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        String[] split = str.split("\\r\\n|\\r|\\n");
        int i = 0;
        while (i < split.length) {
            String br = split[i];
            FeatureMapUtil.addText((FeatureMap)div.getMixed(), (String)br);
            if (i < split.length - 1) {
                div.getBr().add((Object)XhtmlFactory.eINSTANCE.createXhtmlBrType());
            }
            ++i;
        }
        return div;
    }

    public static boolean isFormattedAttribute(XhtmlContent xhtmlContent) {
        try {
            String xhtmlString = ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)xhtmlContent);
            if (xhtmlString != null) {
                String stringValue = xhtmlString.replaceAll("\\<xhtml:br/\\>", "");
                stringValue = stringValue.replaceAll("\\<xhtml:div xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"\\>", " ");
                stringValue = stringValue.replaceAll("\\</xhtml:div\\>", "");
                stringValue = stringValue.replaceAll(newLine, "");
                if ((stringValue = stringValue.replaceAll(" ", "")).contains("<xhtml:")) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

