/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.string;

import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyKeyDialog;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

public final class StringPropertyDialog
extends ResizableDialog {
    private final Property m_property;
    private final JavaInfo m_component;
    private final GenericProperty m_genericProperty;
    private final NlsSupport m_support;
    private final IEditableSupport m_editableSupport;
    private final LocaleInfo m_locale;
    private final AbstractSource m_initialSource;
    private IEditableSource m_selectedEditSource;
    private String m_selectedKey;
    private Text m_valueText;
    private Composite m_nlsComposite;
    private Button m_nlsButton;
    private Text m_nlsSourceText;
    private Text m_nlsKeyText;

    public StringPropertyDialog(Shell parentShell, Property property) throws Exception {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_property = property;
        if (this.m_property instanceof GenericProperty) {
            this.m_genericProperty = (GenericProperty)this.m_property;
            this.m_component = this.m_genericProperty.getJavaInfo();
            this.m_support = NlsSupport.get(this.m_component);
            this.m_editableSupport = this.m_support.getEditable();
            this.m_locale = AbstractSource.getLocaleInfo(this.m_component);
            Expression expression = this.m_genericProperty.getExpression();
            if (expression != null) {
                this.m_initialSource = NlsSupport.getSource(expression);
                this.m_selectedEditSource = this.m_editableSupport.getEditableSource(this.m_initialSource);
                if (this.m_selectedEditSource != null) {
                    this.m_selectedKey = this.m_initialSource.getKey(expression);
                }
            } else {
                this.m_initialSource = null;
            }
        } else {
            this.m_genericProperty = null;
            this.m_component = null;
            this.m_support = null;
            this.m_editableSupport = null;
            this.m_locale = null;
            this.m_initialSource = null;
        }
    }

    public void create() {
        super.create();
        this.updateSourceKey();
        this.m_valueText.selectAll();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.m_valueText = new Text(area, 2114);
        GridDataFactory.create((Control)this.m_valueText).grab().hintC(80, 8).fill();
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Object value = StringPropertyDialog.this.m_property.getValue();
                if (value instanceof String) {
                    StringPropertyDialog.this.m_valueText.setText((String)value);
                }
            }
        });
        this.m_valueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 13) {
                    StringPropertyDialog.this.okPressed();
                }
            }
        });
        if (this.m_genericProperty != null) {
            Group group = new Group(area, 0);
            GridDataFactory.create((Control)group).fill();
            GridLayoutFactory.create((Composite)group);
            group.setText(ModelMessages.StringPropertyDialog_localizationGroup);
            this.m_nlsButton = new Button((Composite)group, 32);
            this.m_nlsButton.setText(ModelMessages.StringPropertyDialog_localizationUseExisting);
            this.m_nlsButton.setEnabled(!this.m_editableSupport.getEditableSources().isEmpty());
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    StringPropertyDialog.this.m_nlsButton.setSelection(StringPropertyDialog.this.m_support.isExternalized(StringPropertyDialog.this.m_genericProperty.getExpression()));
                }
            });
            this.m_nlsButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    UiUtils.changeControlEnable((Control)StringPropertyDialog.this.m_nlsComposite, (boolean)StringPropertyDialog.this.m_nlsButton.getSelection());
                    StringPropertyDialog.this.updateSourceKey();
                }
            });
            this.m_nlsComposite = new Composite((Composite)group, 0);
            GridDataFactory.create((Control)this.m_nlsComposite).grab().fill();
            GridLayoutFactory.create((Composite)this.m_nlsComposite).columns(3).noMargins();
            new Label(this.m_nlsComposite, 0).setText(ModelMessages.StringPropertyDialog_localizationSourceLabel);
            this.m_nlsSourceText = new Text(this.m_nlsComposite, 2056);
            GridDataFactory.create((Control)this.m_nlsSourceText).grabH().fillH();
            Button browseButton = new Button(this.m_nlsComposite, 0);
            GridDataFactory.create((Control)browseButton).hintHU(50).spanV(2).fill();
            browseButton.setText(ModelMessages.StringPropertyDialog_localizationBrowse);
            browseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StringPropertyKeyDialog keyDialog = new StringPropertyKeyDialog(StringPropertyDialog.this.getShell(), StringPropertyDialog.this.m_editableSupport, StringPropertyDialog.this.m_selectedEditSource, StringPropertyDialog.this.m_selectedKey, StringPropertyDialog.this.m_locale);
                    if (keyDialog.open() == 0) {
                        StringPropertyDialog.this.m_selectedEditSource = keyDialog.getSelectedSource();
                        StringPropertyDialog.this.m_selectedKey = keyDialog.getSelectedKey();
                        StringPropertyDialog.this.updateSourceKey();
                    }
                }
            });
            new Label(this.m_nlsComposite, 0).setText(ModelMessages.StringPropertyDialog_localizationKeyLabel);
            this.m_nlsKeyText = new Text(this.m_nlsComposite, 2056);
            GridDataFactory.create((Control)this.m_nlsKeyText).grabH().fillH();
            UiUtils.changeControlEnable((Control)this.m_nlsComposite, (boolean)this.m_nlsButton.getSelection());
        }
        return area;
    }

    private void updateSourceKey() {
        if (this.m_genericProperty != null) {
            if (this.m_nlsButton.getSelection() && this.m_selectedKey != null) {
                this.m_nlsSourceText.setText(this.m_selectedEditSource.getLongTitle());
                this.m_nlsKeyText.setText(this.m_selectedKey);
                String value = this.m_selectedEditSource.getValue(this.m_locale, this.m_selectedKey);
                if (value != null) {
                    this.m_valueText.setText(value);
                }
            }
            Button okButton = this.getButton(0);
            if (this.m_nlsButton.getSelection()) {
                okButton.setEnabled(this.m_selectedKey != null);
            } else {
                okButton.setEnabled(true);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.StringPropertyDialog_title);
    }

    protected void okPressed() {
        final String value = this.m_valueText.getText();
        if (this.m_component != null) {
            ExecutionUtils.run((ObjectInfo)this.m_component, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    if (StringPropertyDialog.this.m_genericProperty != null) {
                        if (!StringPropertyDialog.this.m_nlsButton.getSelection() && StringPropertyDialog.this.m_initialSource != null) {
                            StringPropertyDialog.this.m_initialSource.replace_toStringLiteral(StringPropertyDialog.this.m_genericProperty, value);
                            return;
                        }
                        if (StringPropertyDialog.this.m_nlsButton.getSelection()) {
                            AbstractSource selectedSource = StringPropertyDialog.this.m_support.getAttachedSource(StringPropertyDialog.this.m_editableSupport, StringPropertyDialog.this.m_selectedEditSource);
                            selectedSource.useKey(StringPropertyDialog.this.m_genericProperty, StringPropertyDialog.this.m_selectedKey);
                            if (this.isValueDifferentThanInSource()) {
                                StringPropertyDialog.this.m_property.setValue((Object)value);
                            }
                            return;
                        }
                    }
                    StringPropertyDialog.this.m_property.setValue((Object)value);
                }

                private boolean isValueDifferentThanInSource() {
                    String valueInSource = StringPropertyDialog.this.m_selectedEditSource.getValue(StringPropertyDialog.this.m_locale, StringPropertyDialog.this.m_selectedKey);
                    return !value.equals(valueInSource);
                }
            });
        } else {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    StringPropertyDialog.this.m_property.setValue((Object)value);
                }
            });
        }
        super.okPressed();
    }
}

