/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;

public final class SourcePage
implements IEditorPage {
    private final DesignerEditor m_editor;
    private final Map<String, IAction> m_idToTextEditorAction = new HashMap<String, IAction>();
    private Composite m_composite;
    private boolean m_active = false;

    public SourcePage(DesignerEditor editor) {
        this.m_editor = editor;
    }

    @Override
    public void initialize(IDesignerEditor designerPage) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void handleActiveState(boolean activate) {
        if (this.m_active == activate) {
            return;
        }
        this.m_active = activate;
        this.updateSourceActions(this.m_active);
    }

    @Override
    public Control createControl(Composite parent) {
        this.m_composite = new Composite(parent, 0);
        this.m_composite.setLayout((Layout)new FillLayout());
        this.m_editor.super_createPartControl(this.m_composite);
        return this.m_composite;
    }

    @Override
    public Control getControl() {
        return this.m_composite;
    }

    @Override
    public void setFocus() {
        this.getTextWidget().setFocus();
    }

    private StyledText getTextWidget() {
        return this.m_editor.super_getSourceViewer().getTextWidget();
    }

    public boolean isActive() {
        return this.getTextWidget().isFocusControl();
    }

    @Override
    public String getName() {
        return Messages.SourcePage_name;
    }

    @Override
    public Image getImage() {
        return DesignerPlugin.getImage((String)"editor_source_page.png");
    }

    public void setAction(String actionID, IAction action) {
        if (!(action == null || "save".equals(actionID) || "undo".equals(actionID) || "redo".equals(actionID))) {
            this.m_idToTextEditorAction.put(actionID, action);
        }
    }

    private void updateSourceActions(boolean install) {
        for (Map.Entry<String, IAction> entry : this.m_idToTextEditorAction.entrySet()) {
            String id = entry.getKey();
            IAction action = entry.getValue();
            action.setEnabled(install);
            if (install) {
                this.m_editor.super_setAction(id, action);
                continue;
            }
            this.m_editor.super_setAction(id, null);
        }
    }
}

