/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServerCompositeFragment;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.server.core.types.IServerType;
import org.eclipse.php.server.core.types.ServerTypesManager;
import org.eclipse.php.server.ui.types.IServerTypeDescriptor;
import org.eclipse.php.server.ui.types.ServerTypesDescriptorRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ServerEditPage
extends WizardPage
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.server.ui.serverWizardAndComposite";
    private Server server;
    private ArrayList<CompositeFragment> runtimeComposites;
    private TabFolder tabs;
    private String tabID;
    private List<IPostFinish> postFinish = new ArrayList<IPostFinish>();

    public ServerEditPage(Server server) {
        super(PHPServerUIMessages.getString("ServerEditPage.Title"));
        this.server = server;
        this.runtimeComposites = new ArrayList();
    }

    public ServerEditPage(Server server, String tabID) {
        this(server);
        this.tabID = tabID;
    }

    public void createControl(Composite parent) {
        ICompositeFragmentFactory[] factories;
        this.tabs = new TabFolder(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tabs.setLayoutData((Object)gd);
        IServerType serverType = ServerTypesManager.getInstance().getType(this.server);
        IServerTypeDescriptor serverTypeDescriptor = ServerTypesDescriptorRegistry.getDescriptor(serverType);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = factories = serverTypeDescriptor.getEditorFragmentFactories();
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory element = iCompositeFragmentFactoryArray[n2];
            TabItem tabItem = new TabItem(this.tabs, 0);
            CompositeFragment fragment = element.createComposite((Composite)this.tabs, (IControlHandler)this);
            fragment.setData((Object)this.server);
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            tabItem.setData((Object)fragment.getId());
            this.runtimeComposites.add(fragment);
            ++n2;
        }
        this.getShell().setText(PHPServerUIMessages.getString("ServerEditDialog.editServer"));
        this.getShell().setImage(ServersPluginImages.get("org.eclipse.php.server.ui.server.png"));
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServerType type;
                TabItem item = (TabItem)e.item;
                CompositeFragment fragment = (CompositeFragment)item.getControl();
                if (fragment instanceof ServerCompositeFragment && (type = ServerTypesManager.getInstance().getType(ServerEditPage.this.server)) != null) {
                    IServerTypeDescriptor serverTypeDescriptor = ServerTypesDescriptorRegistry.getDescriptor(type);
                    ((ServerCompositeFragment)fragment).setImageDescriptor(serverTypeDescriptor.getImageDescriptor(IServerTypeDescriptor.ImageType.WIZARD));
                }
                ServerEditPage.this.setImageDescriptor(fragment.getImageDescriptor());
                ServerEditPage.this.setDescription(fragment.getDescription());
                ServerEditPage.this.setTitle(fragment.getTitle());
                fragment.validate();
            }
        });
        if (this.tabID != null) {
            this.setSelect(this.tabID);
        }
        int selectionIndex = this.tabs.getSelectionIndex() != -1 ? this.tabs.getSelectionIndex() : 0;
        CompositeFragment selectedFragment = this.runtimeComposites.get(selectionIndex);
        this.setTitle(selectedFragment.getTitle());
        this.setDescription(selectedFragment.getDescription());
        this.setControl((Control)this.tabs);
        IServerType type = ServerTypesManager.getInstance().getType(this.server);
        if (type != null) {
            serverTypeDescriptor = ServerTypesDescriptorRegistry.getDescriptor(type);
            this.setImageDescriptor(serverTypeDescriptor.getImageDescriptor(IServerTypeDescriptor.ImageType.WIZARD));
        }
    }

    public IControlHandler.Kind getKind() {
        return IControlHandler.Kind.EDITOR;
    }

    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    public void update() {
        for (CompositeFragment composite : this.runtimeComposites) {
            if (composite.isComplete()) continue;
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getContainer().run(fork, cancelable, runnable);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void performCancel() {
        for (CompositeFragment composite : this.runtimeComposites) {
            composite.performCancel();
        }
    }

    public boolean performFinish() {
        for (CompositeFragment composite : this.runtimeComposites) {
            if (composite.performOk()) continue;
            return false;
        }
        try {
            Server originalServer = ServersManager.findServer((String)this.server.getUniqueId());
            if (originalServer != null) {
                originalServer.update(this.server);
            }
        }
        catch (Throwable e) {
            Logger.logException("Error while saving the server settings", e);
            return false;
        }
        this.performPostFinish();
        return true;
    }

    public void addPostFinish(IPostFinish operation) {
        this.postFinish.add(operation);
    }

    private void performPostFinish() {
        for (IPostFinish operation : this.postFinish) {
            operation.perform();
        }
    }

    private void setSelect(String id) {
        if (id == null) {
            return;
        }
        int i = 0;
        while (i < this.tabs.getItemCount()) {
            if (id.equals(this.tabs.getItem(i).getData())) {
                this.tabs.setSelection(i);
                break;
            }
            ++i;
        }
    }

    public static interface IPostFinish {
        public void perform();
    }
}

