/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.query.MergeSourceTable;
import org.eclipse.datatools.modelbase.sql.query.MergeTargetTable;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryMergeStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCase;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionUnaryOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ValueExpressionHelper {
    protected static HashMap FunctionReturnType = ValueExpressionHelper.createFunctionReturnTypeMap();

    public static void addExpressionsToList(List columnList, QueryValueExpression aValueExpr) {
        if (aValueExpr instanceof ValueExpressionColumn) {
            columnList.add(aValueExpr);
        } else {
            columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(aValueExpr));
        }
    }

    public static QueryValueExpression cloneQueryValueExpression(QueryValueExpression valueExpr) {
        QueryValueExpression clone = null;
        if (valueExpr != null) {
            DataType dataType = valueExpr.getDataType();
            DataType dataTypeCopy = ValueExpressionHelper.copyDataType(dataType);
            valueExpr.setDataType(null);
            clone = (QueryValueExpression)EcoreUtil.copy((EObject)valueExpr);
            valueExpr.setDataType(dataType);
            clone.setDataType(dataTypeCopy);
        }
        return clone;
    }

    public static DataType copyDataType(DataType dataType) {
        DataType copy = null;
        if (dataType != null) {
            copy = (DataType)EcoreUtil.copy((EObject)dataType);
        }
        return copy;
    }

    public static void copyDataType(QueryValueExpression aSourceExpr, QueryValueExpression aTargetExpr) {
        if (aSourceExpr != null && aSourceExpr.getDataType() != null) {
            DataType dataType = aSourceExpr.getDataType();
            DataType dataTypeCopy = ValueExpressionHelper.copyDataType(dataType);
            aTargetExpr.setDataType(dataTypeCopy);
        }
    }

    public static List getColumnsFromSearchCondition(QuerySearchCondition aSearchCond) {
        ArrayList columns = new ArrayList();
        QuerySearchCondition sc = aSearchCond;
        if (sc instanceof SearchConditionCombined) {
            QuerySearchCondition left = ((SearchConditionCombined)sc).getLeftCondition();
            QuerySearchCondition right = ((SearchConditionCombined)sc).getRightCondition();
            columns.addAll(ValueExpressionHelper.getColumnsFromSearchCondition(left));
            columns.addAll(ValueExpressionHelper.getColumnsFromSearchCondition(right));
        } else if (sc instanceof SearchConditionNested) {
            QuerySearchCondition nested = ((SearchConditionNested)sc).getNestedCondition();
            columns.addAll(ValueExpressionHelper.getColumnsFromSearchCondition(nested));
        } else if (sc instanceof PredicateBasic) {
            QueryValueExpression valueExpr = ((PredicateBasic)sc).getLeftValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
            valueExpr = ((PredicateBasic)sc).getRightValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
        } else if (sc instanceof PredicateBetween) {
            QueryValueExpression valueExpr = ((PredicateBetween)sc).getLeftValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
            QueryValueExpression lower = ((PredicateBetween)sc).getRightValueExpr1();
            ValueExpressionHelper.addExpressionsToList(columns, lower);
            QueryValueExpression upper = ((PredicateBetween)sc).getRightValueExpr2();
            ValueExpressionHelper.addExpressionsToList(columns, upper);
        } else if (sc instanceof PredicateInValueList) {
            QueryValueExpression valueExpr = ((PredicateInValueList)sc).getValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
            EList inValues = ((PredicateInValueList)sc).getValueExprList();
            for (QueryValueExpression inExpr : inValues) {
                ValueExpressionHelper.addExpressionsToList(columns, inExpr);
            }
        } else if (sc instanceof PredicateLike) {
            QueryValueExpression valueExpr = ((PredicateLike)sc).getMatchingValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
            valueExpr = ((PredicateLike)sc).getPatternValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
        } else if (sc instanceof PredicateIsNull) {
            QueryValueExpression valueExpr = ((PredicateIsNull)sc).getValueExpr();
            ValueExpressionHelper.addExpressionsToList(columns, valueExpr);
        }
        return columns;
    }

    public static List getColumnsFromValueExpression(QueryValueExpression valueExpr) {
        ArrayList<QueryValueExpression> columns = new ArrayList<QueryValueExpression>();
        if (valueExpr instanceof ValueExpressionColumn) {
            columns.add(valueExpr);
        } else if (valueExpr instanceof ValueExpressionFunction) {
            columns.addAll(ValueExpressionHelper.getVEFunctionColumns((ValueExpressionFunction)valueExpr));
        } else if (valueExpr instanceof ValueExpressionCombined) {
            columns.addAll(ValueExpressionHelper.getVECombinedColumns((ValueExpressionCombined)valueExpr));
        } else if (valueExpr instanceof ValueExpressionCast) {
            columns.addAll(ValueExpressionHelper.getVECastColumns((ValueExpressionCast)valueExpr));
        } else if (valueExpr instanceof ValueExpressionCase) {
            columns.addAll(ValueExpressionHelper.getVECaseColumns((ValueExpressionCase)valueExpr));
        } else if (valueExpr instanceof ValueExpressionLabeledDuration) {
            columns.addAll(ValueExpressionHelper.getVELabeledDurationColumns((ValueExpressionLabeledDuration)valueExpr));
        }
        return columns;
    }

    public static List getTableNamesFromExpression(QueryValueExpression valueExpr) {
        ArrayList<String> tableNames = new ArrayList<String>();
        List columnExpr = ValueExpressionHelper.getColumnsFromValueExpression(valueExpr);
        if (!columnExpr.isEmpty()) {
            for (ValueExpressionColumn aColumn : columnExpr) {
                String aTableName = ((TableInDatabase)aColumn.getTableExpr()).getName();
                if (tableNames.contains(aTableName) && !tableNames.isEmpty()) continue;
                tableNames.add(aTableName);
            }
        }
        return tableNames;
    }

    public static List getTableRefsFromExpression(QueryValueExpression valueExpr) {
        ArrayList<TableExpression> tableRefs = new ArrayList<TableExpression>();
        List columnExpr = ValueExpressionHelper.getColumnsFromValueExpression(valueExpr);
        if (!columnExpr.isEmpty()) {
            for (ValueExpressionColumn aColumn : columnExpr) {
                TableExpression aTableRef = aColumn.getTableExpr();
                if (aTableRef == null) continue;
                tableRefs.add(aTableRef);
            }
        }
        return tableRefs;
    }

    public static List getVECaseColumns(ValueExpressionCase aValExpr) {
        EList contentList = null;
        Iterator contentListIter = null;
        ArrayList<QueryValueExpression> columnList = new ArrayList<QueryValueExpression>();
        if (aValExpr instanceof ValueExpressionCaseSearch) {
            contentList = ((ValueExpressionCaseSearch)aValExpr).getSearchContentList();
            for (ValueExpressionCaseSearchContent searchedWhen : contentList) {
                QueryValueExpression resultExpr;
                QuerySearchCondition searchCondition = searchedWhen.getSearchCondition();
                if (searchCondition != null) {
                    columnList.addAll(ValueExpressionHelper.getColumnsFromSearchCondition(searchCondition));
                }
                if ((resultExpr = searchedWhen.getValueExpr()) instanceof ValueExpressionColumn) {
                    columnList.add(resultExpr);
                    continue;
                }
                columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(resultExpr));
            }
        } else {
            QueryValueExpression operandExpr = ((ValueExpressionCaseSimple)aValExpr).getValueExpr();
            if (operandExpr instanceof ValueExpressionColumn) {
                columnList.add(operandExpr);
            } else {
                columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(operandExpr));
            }
            contentList = ((ValueExpressionCaseSimple)aValExpr).getContentList();
            for (ValueExpressionCaseSimpleContent simpleWhen : contentList) {
                QueryValueExpression whenExpr = simpleWhen.getWhenValueExpr();
                if (whenExpr instanceof ValueExpressionColumn) {
                    columnList.add(whenExpr);
                } else {
                    columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(whenExpr));
                }
                QueryValueExpression resultExpr = simpleWhen.getResultValueExpr();
                if (resultExpr instanceof ValueExpressionColumn) {
                    columnList.add(resultExpr);
                    continue;
                }
                columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(resultExpr));
            }
        }
        ValueExpressionCaseElse caseElse = aValExpr.getValueExprCaseElse();
        if (caseElse != null) {
            QueryValueExpression elseExpr = caseElse.getValueExpr();
            if (elseExpr instanceof ValueExpressionColumn) {
                columnList.add(elseExpr);
            } else {
                columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(elseExpr));
            }
        }
        return columnList;
    }

    public static List getVECastColumns(ValueExpressionCast aValExpr) {
        ArrayList<QueryValueExpression> columnList = new ArrayList<QueryValueExpression>();
        QueryValueExpression castValExpr = aValExpr.getValueExpr();
        if (aValExpr instanceof ValueExpressionColumn) {
            columnList.add(castValExpr);
        } else {
            columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(castValExpr));
        }
        return columnList;
    }

    public static List getVECombinedColumns(ValueExpressionCombined combined) {
        ArrayList<QueryValueExpression> columnList = new ArrayList<QueryValueExpression>();
        QueryValueExpression leftVE = combined.getLeftValueExpr();
        if (leftVE instanceof ValueExpressionColumn) {
            columnList.add(leftVE);
        } else {
            columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(leftVE));
        }
        QueryValueExpression rightVE = combined.getRightValueExpr();
        if (rightVE instanceof ValueExpressionColumn) {
            columnList.add(rightVE);
        } else {
            columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(rightVE));
        }
        return columnList;
    }

    public static List getVEFunctionColumns(ValueExpressionFunction funcExpr) {
        ArrayList<ValueExpressionColumn> valueExprCols = new ArrayList<ValueExpressionColumn>();
        EList parms = funcExpr.getParameterList();
        for (Object parmx : parms) {
            QueryValueExpression parmExpr = (QueryValueExpression)parmx;
            if (parmx instanceof ValueExpressionColumn) {
                ValueExpressionColumn colExpr = (ValueExpressionColumn)parmx;
                valueExprCols.add(colExpr);
                continue;
            }
            valueExprCols.addAll(ValueExpressionHelper.getColumnsFromValueExpression(parmExpr));
        }
        return valueExprCols;
    }

    public static List getVELabeledDurationColumns(ValueExpressionLabeledDuration labeledDurExpr) {
        ArrayList<QueryValueExpression> columnList = new ArrayList<QueryValueExpression>();
        QueryValueExpression durExpr = labeledDurExpr.getValueExpr();
        if (durExpr instanceof ValueExpressionColumn) {
            columnList.add(durExpr);
        } else {
            columnList.addAll(ValueExpressionHelper.getColumnsFromValueExpression(durExpr));
        }
        return columnList;
    }

    public static DataType numericDataTypePromotion(DataType left, DataType right) {
        DataType retType = ValueExpressionHelper.doNumericDataTypePromotion(left, right);
        if (retType == null) {
            retType = ValueExpressionHelper.doNumericDataTypePromotion(right, left);
        }
        if (retType == null) {
            retType = left != null ? ValueExpressionHelper.copyDataType(left) : ValueExpressionHelper.copyDataType(right);
        }
        return retType;
    }

    public static Column resolveColumnFromValueExpression(ValueExpressionColumn aValExpr) {
        String colName = aValExpr.getName();
        Column theColumn = null;
        TableInDatabase tableRef = aValExpr.getTableInDatabase();
        if (tableRef != null) {
            EList columns = tableRef.getDatabaseTable().getColumns();
            for (Column aColumn : columns) {
                String aColumnName = aColumn.getName();
                if (!StatementHelper.equalSQLIdentifiers(aColumnName, colName)) continue;
                theColumn = aColumn;
                break;
            }
        }
        return theColumn;
    }

    public static DataType resolveCombinedDataType(DataType aDataType, DataType anotherDataType) {
        if (aDataType != null && anotherDataType != null && aDataType instanceof CharacterStringDataType && anotherDataType instanceof CharacterStringDataType) {
            CharacterStringDataType resolvedDataType = (CharacterStringDataType)ValueExpressionHelper.copyDataType(aDataType);
            resolvedDataType.setLength(Math.max(((CharacterStringDataType)aDataType).getLength(), ((CharacterStringDataType)anotherDataType).getLength()));
            PrimitiveType aPrimType = ((PredefinedDataType)aDataType).getPrimitiveType();
            PrimitiveType anotherPrimType = ((PredefinedDataType)anotherDataType).getPrimitiveType();
            if (aPrimType == PrimitiveType.CHARACTER_LITERAL && anotherPrimType == PrimitiveType.CHARACTER_VARYING_LITERAL) {
                resolvedDataType.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
            } else if ((aPrimType == PrimitiveType.CHARACTER_LITERAL || aPrimType == PrimitiveType.CHARACTER_VARYING_LITERAL) && anotherPrimType == PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL) {
                resolvedDataType.setPrimitiveType(PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL);
            }
            return resolvedDataType;
        }
        if (aDataType != null) {
            return aDataType;
        }
        return anotherDataType;
    }

    public static void resolveTablesInValueExpression(QueryValueExpression valExpr, List tables) {
        List columnList = ValueExpressionHelper.getColumnsFromValueExpression(valExpr);
        boolean useCorrName = false;
        String searchTableName = "";
        String colCorrName = "";
        if (columnList != null && !columnList.isEmpty()) {
            for (ValueExpressionColumn colExpr : columnList) {
                TableExpression colTable = colExpr.getTableExpr();
                if (colTable != null) {
                    colCorrName = colTable.getTableCorrelation().getName();
                    if (colCorrName != null && colCorrName.length() > 0) {
                        searchTableName = colCorrName;
                        useCorrName = true;
                    } else {
                        searchTableName = colExpr.getTableExpr().getName();
                        useCorrName = false;
                    }
                }
                Iterator tIter = tables.iterator();
                TableExpression foundTable = null;
                while (tIter.hasNext() && foundTable == null) {
                    TableExpression fcTable = (TableExpression)tIter.next();
                    if (useCorrName) {
                        String fcCorrName = fcTable.getTableCorrelation().getName();
                        if (fcCorrName == null || !StatementHelper.equalSQLIdentifiers(fcCorrName, searchTableName)) continue;
                        foundTable = fcTable;
                        continue;
                    }
                    String fcTableName = fcTable.getName();
                    if (fcTableName == null || !StatementHelper.equalSQLIdentifiers(fcTableName, searchTableName)) continue;
                    foundTable = fcTable;
                }
                if (foundTable == null) continue;
                colExpr.setTableExpr(foundTable);
            }
        }
    }

    public static void resolveValueExpressionCaseDatatype(ValueExpressionCase aValExpr) {
        EList contentList = null;
        Iterator contentListIter = null;
        DataType contentDatatype = null;
        if (aValExpr instanceof ValueExpressionCaseSearch) {
            QueryValueExpression contentValExpr;
            contentList = ((ValueExpressionCaseSearch)aValExpr).getSearchContentList();
            for (ValueExpressionCaseSearchContent content : contentList) {
                contentValExpr = content.getValueExpr();
                if (contentValExpr instanceof ValueExpressionNullValue) continue;
                contentDatatype = ValueExpressionHelper.copyDataType(ValueExpressionHelper.resolveCombinedDataType(contentDatatype, contentValExpr.getDataType()));
            }
            ValueExpressionCaseElse elseContent = ((ValueExpressionCaseSearch)aValExpr).getCaseElse();
            if (elseContent != null && !((contentValExpr = elseContent.getValueExpr()) instanceof ValueExpressionNullValue)) {
                contentDatatype = ValueExpressionHelper.copyDataType(ValueExpressionHelper.resolveCombinedDataType(contentDatatype, contentValExpr.getDataType()));
            }
        } else {
            QueryValueExpression contentValExpr;
            contentList = ((ValueExpressionCaseSimple)aValExpr).getContentList();
            for (ValueExpressionCaseSimpleContent content : contentList) {
                contentValExpr = content.getResultValueExpr();
                if (contentValExpr instanceof ValueExpressionNullValue) continue;
                contentDatatype = ValueExpressionHelper.copyDataType(ValueExpressionHelper.resolveCombinedDataType(contentDatatype, contentValExpr.getDataType()));
            }
            ValueExpressionCaseElse elseContent = ((ValueExpressionCaseSimple)aValExpr).getCaseElse();
            if (elseContent != null && !((contentValExpr = elseContent.getValueExpr()) instanceof ValueExpressionNullValue)) {
                contentDatatype = ValueExpressionHelper.copyDataType(ValueExpressionHelper.resolveCombinedDataType(contentDatatype, contentValExpr.getDataType()));
            }
        }
        if (contentDatatype != null) {
            aValExpr.setDataType(contentDatatype);
        }
    }

    public static void resolveValueExpressionColumnDatatype(ValueExpressionColumn aValExpr) {
        if (aValExpr == null || aValExpr.getDataType() != null) {
            return;
        }
        String colName = aValExpr.getName();
        TableExpression tableRef = aValExpr.getTableExpr();
        if (tableRef != null) {
            if (tableRef instanceof TableInDatabase) {
                TableInDatabase tableInDB = (TableInDatabase)tableRef;
                Column rdbColumn = null;
                rdbColumn = TableHelper.getColumnForName(tableInDB, colName);
                if (rdbColumn != null) {
                    DataType datatype = rdbColumn.getDataType();
                    aValExpr.setDataType(ValueExpressionHelper.copyDataType(datatype));
                }
            } else {
                ValueExpressionColumn tableColExpr = TableHelper.getColumnExpressionForName(tableRef, colName);
                if (tableColExpr != null && tableColExpr.getDataType() != null) {
                    aValExpr.setDataType(ValueExpressionHelper.copyDataType(tableColExpr.getDataType()));
                }
            }
        }
    }

    public static void resolveValueExpressionCombined(ValueExpressionCombined aValExpr) {
        QueryValueExpression leftExpr = aValExpr.getLeftValueExpr();
        QueryValueExpression rightExpr = aValExpr.getRightValueExpr();
        int oper = aValExpr.getCombinedOperator().getValue();
        if (oper == 4) {
            ValueExpressionHelper.resolveValueExpressionConcatDatatype(aValExpr, leftExpr, rightExpr);
        } else {
            DataType leftExprDatatype = leftExpr.getDataType();
            DataType rightExprDatatype = rightExpr.getDataType();
            aValExpr.setDataType(ValueExpressionHelper.numericDataTypePromotion(leftExprDatatype, rightExprDatatype));
        }
    }

    public static void resolveValueExpressionConcatDatatype(QueryValueExpression aValExpr, QueryValueExpression aLeftValExpr, QueryValueExpression aRightValExpr) {
        if (aLeftValExpr instanceof ValueExpressionVariable && aLeftValExpr.getDataType() == null || aRightValExpr instanceof ValueExpressionVariable && aRightValExpr.getDataType() == null) {
            PredicateLike likePred = null;
            ValueExpressionCombined combined = aLeftValExpr.getValueExprCombinedLeft();
            if (combined != null) {
                QueryValueExpression matchExpr;
                likePred = combined.getLikePattern();
                if (likePred == null) {
                    ValueExpressionCombined combined2 = combined.getValueExprCombinedLeft();
                    if (combined2 == null) {
                        combined2 = combined.getValueExprCombinedRight();
                    }
                    if (combined2 != null) {
                        likePred = combined2.getLikePattern();
                    }
                }
                if (likePred != null && (matchExpr = likePred.getMatchingValueExpr()) != null && matchExpr instanceof ValueExpressionColumn) {
                    if (aLeftValExpr instanceof ValueExpressionVariable && aLeftValExpr.getDataType() == null) {
                        ValueExpressionHelper.copyDataType(matchExpr, aLeftValExpr);
                    }
                    if (aRightValExpr instanceof ValueExpressionVariable && aRightValExpr.getDataType() == null) {
                        ValueExpressionHelper.copyDataType(matchExpr, aRightValExpr);
                    }
                }
            }
        }
        DataType leftDatatype = aLeftValExpr.getDataType();
        DataType rightDatatype = aRightValExpr.getDataType();
        aValExpr.setDataType(ValueExpressionHelper.concatCharStringDataTypePromotion(leftDatatype, rightDatatype));
    }

    public static void resolveValueExpressionDatatype(QueryValueExpression valExpr) {
        if (valExpr instanceof ValueExpressionColumn) {
            ValueExpressionHelper.resolveValueExpressionColumnDatatype((ValueExpressionColumn)valExpr);
        } else if (valExpr instanceof ValueExpressionCombined) {
            ValueExpressionHelper.resolveValueExpressionCombined((ValueExpressionCombined)valExpr);
        } else if (valExpr instanceof ValueExpressionNested) {
            ValueExpressionNested nest = (ValueExpressionNested)valExpr;
            QueryValueExpression nestedExpr = nest.getNestedValueExpr();
            if (nestedExpr != null && nestedExpr.getDataType() == null) {
                ValueExpressionHelper.resolveValueExpressionDatatype(nestedExpr);
            }
            ValueExpressionHelper.copyDataType(nestedExpr, nest);
        } else if (valExpr instanceof ValueExpressionDefaultValue) {
            ValueExpressionHelper.resolveValueExpressionDefaultValueDatatype((ValueExpressionDefaultValue)valExpr);
        } else if (valExpr instanceof ValueExpressionCase) {
            ValueExpressionHelper.resolveValueExpressionCaseDatatype((ValueExpressionCase)valExpr);
        } else if (!(valExpr instanceof ValueExpressionCast)) {
            if (valExpr instanceof ValueExpressionFunction) {
                ValueExpressionHelper.resolveValueExpressionFunctionDatatype((ValueExpressionFunction)valExpr);
            } else if (valExpr instanceof ValueExpressionLabeledDuration) {
                ValueExpressionHelper.resolveValueExpressionLabeledDurationDatatype((ValueExpressionLabeledDuration)valExpr);
            } else if (valExpr instanceof ValueExpressionNullValue) {
                ValueExpressionHelper.resolveValueExpressionNullValueDatatype((ValueExpressionNullValue)valExpr);
            } else if (valExpr instanceof ValueExpressionSimple) {
                ValueExpressionHelper.resolveValueExpressionSimpleDatatype((ValueExpressionSimple)valExpr);
            } else if (valExpr instanceof ValueExpressionVariable) {
                ValueExpressionHelper.resolveValueExpressionVariableDatatype((ValueExpressionVariable)valExpr);
            }
        }
    }

    public static void resolveValueExpressionDatatypeRecursively(QueryValueExpression aValueExpr) {
        Class<QueryValueExpression> valueExprType = QueryValueExpression.class;
        Class[] valueExprRefType = new Class[]{valueExprType};
        Set allValueExprRefs = StatementHelper.getReferencesViaSpecificReferencePaths((EObject)aValueExpr, valueExprType, valueExprRefType);
        allValueExprRefs.add(aValueExpr);
        int valueExprsUnresolved = 0;
        do {
            valueExprsUnresolved = allValueExprRefs.size();
            Iterator exprIt = allValueExprRefs.iterator();
            while (exprIt.hasNext()) {
                QueryValueExpression valueExpr = (QueryValueExpression)exprIt.next();
                ValueExpressionHelper.resolveValueExpressionDatatype(valueExpr);
                if (valueExpr.getDataType() == null) continue;
                exprIt.remove();
            }
        } while (valueExprsUnresolved > allValueExprRefs.size());
    }

    public static void resolveValueExpressionDefaultValueDatatype(ValueExpressionDefaultValue aValExpr) {
    }

    public static void resolveValueExpressionFunctionDatatype(ValueExpressionFunction aValExpr) {
        String funcName = aValExpr.getName();
        DataType dataType = aValExpr.getDataType();
        if (dataType == null) {
            EList paramList = aValExpr.getParameterList();
            int paramSize = paramList.size();
            ArrayList<DataType> paramDataTypeList = new ArrayList<DataType>();
            if (paramSize > 0) {
                int i = 0;
                while (i < paramSize) {
                    QueryValueExpression valExpr = (QueryValueExpression)paramList.get(i);
                    DataType paramDataType = null;
                    if (valExpr != null) {
                        paramDataType = valExpr.getDataType();
                    }
                    paramDataTypeList.add(paramDataType);
                    ++i;
                }
            }
            dataType = ValueExpressionHelper.getFuncReturnType(funcName);
            DataType param1DataType = null;
            PrimitiveType param1PrimType = null;
            if (paramDataTypeList.size() > 0) {
                param1DataType = (DataType)paramDataTypeList.get(0);
            }
            if (param1DataType != null) {
                if (param1DataType instanceof PredefinedDataType) {
                    param1PrimType = ((PredefinedDataType)param1DataType).getPrimitiveType();
                }
                param1DataType = ValueExpressionHelper.copyDataType(param1DataType);
            }
            DataType param2DataType = null;
            PrimitiveType param2PrimType = null;
            if (paramDataTypeList.size() > 1) {
                param2DataType = (DataType)paramDataTypeList.get(1);
            }
            if (param2DataType != null && (param2DataType = ValueExpressionHelper.copyDataType(param2DataType)) instanceof PredefinedDataType) {
                param2PrimType = ((PredefinedDataType)param2DataType).getPrimitiveType();
            }
            if (dataType == null) {
                if (FunctionReturnType.containsKey(funcName)) {
                    dataType = param1DataType;
                } else if (funcName != null) {
                    if (funcName.equals("AVG") || funcName.equals("SUM")) {
                        if (param1DataType instanceof IntegerDataType) {
                            IntegerDataType intDataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                            intDataType.setPrimitiveType(PrimitiveType.BIGINT_LITERAL);
                            dataType = intDataType;
                        } else if (param1DataType instanceof ApproximateNumericDataType) {
                            ApproximateNumericDataType doubleDataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                            doubleDataType.setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
                            dataType = doubleDataType;
                        } else if (param1DataType instanceof FixedPrecisionDataType) {
                            FixedPrecisionDataType decimalDataType = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
                            decimalDataType.setPrimitiveType(PrimitiveType.DECIMAL_LITERAL);
                            decimalDataType.setPrecision(31);
                            int scale = ((FixedPrecisionDataType)param1DataType).getScale();
                            decimalDataType.setScale(scale);
                            dataType = decimalDataType;
                        } else {
                            dataType = ValueExpressionHelper.copyDataType(param1DataType);
                        }
                    } else if (funcName.equals("CHAR")) {
                        dataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                        int length = 254;
                        if (param1DataType instanceof CharacterStringDataType && param1DataType != null) {
                            length = ((CharacterStringDataType)param1DataType).getLength();
                        } else if (param1DataType instanceof DateDataType) {
                            length = 10;
                        } else if (param1DataType instanceof TimeDataType) {
                            if (param1PrimType == PrimitiveType.TIME_LITERAL) {
                                length = 8;
                            } else if (param1PrimType == PrimitiveType.TIMESTAMP_LITERAL) {
                                length = 26;
                            }
                        } else if (param1DataType instanceof IntegerDataType) {
                            length = param1PrimType == PrimitiveType.SMALLINT_LITERAL && param2PrimType == PrimitiveType.SMALLINT_LITERAL ? 6 : (param1PrimType == PrimitiveType.BIGINT_LITERAL && param2PrimType != PrimitiveType.BIGINT_LITERAL ? 20 : 11);
                        } else if (param1DataType instanceof FixedPrecisionDataType && param1DataType != null) {
                            length = ((FixedPrecisionDataType)param1DataType).getPrecision() + 2;
                        } else if (param1DataType instanceof ApproximateNumericDataType) {
                            length = 24;
                        }
                        length = length > 254 ? 254 : length;
                        ((CharacterStringDataType)dataType).setLength(length);
                    } else if (funcName.equals("CEILING") || funcName.equals("CEIL") || funcName.equals("FLOOR")) {
                        if (param1DataType instanceof FixedPrecisionDataType) {
                            int precision = ((FixedPrecisionDataType)param1DataType).getPrecision();
                            if (precision < 31) {
                                ((FixedPrecisionDataType)param1DataType).setPrecision(precision + 1);
                            }
                            ((FixedPrecisionDataType)param1DataType).setScale(0);
                        }
                        dataType = param1DataType;
                    } else if (funcName.equals("MOD")) {
                        dataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                        if (param1DataType instanceof IntegerDataType || param2DataType instanceof IntegerDataType) {
                            if (param1PrimType == PrimitiveType.SMALLINT_LITERAL && param2PrimType == PrimitiveType.SMALLINT_LITERAL) {
                                ((IntegerDataType)dataType).setPrimitiveType(PrimitiveType.SMALLINT_LITERAL);
                            } else if (param1PrimType != PrimitiveType.BIGINT_LITERAL && param2PrimType != PrimitiveType.BIGINT_LITERAL) {
                                ((IntegerDataType)dataType).setPrimitiveType(PrimitiveType.INTEGER_LITERAL);
                            } else {
                                ((IntegerDataType)dataType).setPrimitiveType(PrimitiveType.BIGINT_LITERAL);
                            }
                        }
                    } else if (funcName.equals("MULTIPLY_ALT")) {
                        dataType = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
                        ((FixedPrecisionDataType)dataType).setPrimitiveType(PrimitiveType.DECIMAL_LITERAL);
                        if (param1PrimType == PrimitiveType.DECIMAL_LITERAL && param2PrimType == PrimitiveType.DECIMAL_LITERAL) {
                            int p1 = ((FixedPrecisionDataType)param1DataType).getPrecision();
                            int s1 = ((FixedPrecisionDataType)param1DataType).getScale();
                            int p2 = ((FixedPrecisionDataType)param2DataType).getPrecision();
                            int s2 = ((FixedPrecisionDataType)param2DataType).getScale();
                            int p = p1 + p2 > 31 ? 31 : p1 + p2;
                            int s = s1 + s2;
                            if (s != 0) {
                                if (p1 + p2 > 31) {
                                    int t1 = s > 3 ? 3 : s;
                                    int t2 = 31 - (p1 - s1 + p2 - s2);
                                    s = t1 > t2 ? t1 : t2;
                                } else {
                                    s = s > 31 ? 31 : s;
                                }
                            }
                            ((FixedPrecisionDataType)dataType).setPrecision(p);
                            ((FixedPrecisionDataType)dataType).setScale(s);
                        } else {
                            ((FixedPrecisionDataType)dataType).setPrecision(31);
                            ((FixedPrecisionDataType)dataType).setScale(10);
                        }
                    } else if (funcName.equals("POWER")) {
                        if (param1DataType instanceof IntegerDataType || param2DataType instanceof IntegerDataType) {
                            dataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                            if (param1PrimType != PrimitiveType.BIGINT_LITERAL && param2PrimType != PrimitiveType.BIGINT_LITERAL) {
                                ((IntegerDataType)dataType).setPrimitiveType(PrimitiveType.INTEGER_LITERAL);
                            } else {
                                ((IntegerDataType)dataType).setPrimitiveType(PrimitiveType.BIGINT_LITERAL);
                            }
                        } else {
                            dataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                            ((ApproximateNumericDataType)dataType).setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
                        }
                    } else if (funcName.equals("ROUND")) {
                        int precision;
                        if (param1DataType instanceof FixedPrecisionDataType && (precision = ((FixedPrecisionDataType)param1DataType).getPrecision()) < 31) {
                            ((FixedPrecisionDataType)param1DataType).setPrecision(precision + 1);
                        }
                        dataType = param1DataType;
                    } else if (funcName.equals("SIGN")) {
                        if (param1DataType instanceof IntegerDataType) {
                            dataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                            ((IntegerDataType)dataType).setPrimitiveType(((IntegerDataType)param1DataType).getPrimitiveType());
                        } else {
                            dataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                            ((ApproximateNumericDataType)dataType).setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
                        }
                    } else {
                        dataType = funcName.equals("CONCAT") ? ValueExpressionHelper.concatCharStringDataTypePromotion(param1DataType, param2DataType) : param1DataType;
                    }
                }
            }
            aValExpr.setDataType(ValueExpressionHelper.copyDataType(dataType));
        }
    }

    public static void resolveValueExpressionLabeledDurationDatatype(ValueExpressionLabeledDuration aValExpr) {
        FixedPrecisionDataType datatype = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
        datatype.setPrimitiveType(PrimitiveType.DECIMAL_LITERAL);
        aValExpr.setDataType((DataType)datatype);
    }

    public static void resolveValueExpressionListDatatypes(List aValExprList) {
        int valExprCount = aValExprList.size();
        int resolvedCount = 0;
        int prevResolvedCount = -1;
        do {
            prevResolvedCount = resolvedCount;
            for (QueryValueExpression valExpr : aValExprList) {
                if (valExpr.getDataType() != null) continue;
                ValueExpressionHelper.resolveValueExpressionDatatype(valExpr);
                if (valExpr.getDataType() == null) continue;
                ++resolvedCount;
            }
        } while (resolvedCount < valExprCount && resolvedCount != prevResolvedCount);
        if (resolvedCount < valExprCount) {
            CharacterStringDataType memberType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
            for (QueryValueExpression valExpr : aValExprList) {
                if (valExpr.getDataType() != null) continue;
                valExpr.setDataType((DataType)memberType);
            }
        }
    }

    public static void resolveValueExpressionNullValueDatatype(ValueExpressionNullValue aValExpr) {
    }

    public static void resolveValueExpressionSimpleDatatype(ValueExpressionSimple aValExpr) {
        String value = aValExpr.getValue();
        PredefinedDataType datatype = null;
        if (value != null && value.length() > 0) {
            datatype = ValueExpressionHelper.getPredefinedDataTypeForSimpleValue(value, aValExpr.getUnaryOperator());
        }
        if (datatype != null) {
            aValExpr.setDataType((DataType)datatype);
        }
    }

    public static void resolveValueExpressionVariableDatatype(ValueExpressionVariable aVarExpr) {
        ValueExpressionCast valCast;
        PredicateIsNull predNull;
        CharacterStringDataType datatype;
        QueryValueExpression leftExpr;
        boolean resolved = false;
        ValueExpressionVariable varExpr = aVarExpr;
        QueryValueExpression aValExpr = aVarExpr;
        while (aValExpr.getNest() != null) {
            aValExpr = aValExpr.getNest();
        }
        PredicateBasic predBasic = aValExpr.getBasicLeft();
        if (predBasic != null) {
            QueryValueExpression rightExpr = predBasic.getRightValueExpr();
            ValueExpressionHelper.copyDataType(rightExpr, varExpr);
            resolved = true;
        } else {
            predBasic = aValExpr.getBasicRight();
            if (predBasic != null) {
                QueryValueExpression leftExpr2 = predBasic.getLeftValueExpr();
                ValueExpressionHelper.copyDataType(leftExpr2, varExpr);
                resolved = true;
            }
        }
        if (!resolved) {
            PredicateBetween predBetween = aValExpr.getBetweenLeft();
            if (predBetween != null) {
                QueryValueExpression rightExpr1 = predBetween.getRightValueExpr1();
                QueryValueExpression rightExpr2 = predBetween.getRightValueExpr2();
                ValueExpressionHelper.copyDataType(rightExpr1, varExpr);
                if (aValExpr.getDataType() == null) {
                    ValueExpressionHelper.copyDataType(rightExpr2, varExpr);
                }
                resolved = true;
            } else {
                predBetween = aValExpr.getBetweenRight1();
                if (predBetween != null) {
                    leftExpr = predBetween.getLeftValueExpr();
                    ValueExpressionHelper.copyDataType(leftExpr, varExpr);
                    resolved = true;
                } else {
                    predBetween = aValExpr.getBetweenRight2();
                    if (predBetween != null) {
                        leftExpr = predBetween.getLeftValueExpr();
                        ValueExpressionHelper.copyDataType(leftExpr, varExpr);
                        resolved = true;
                    }
                }
            }
        }
        if (!resolved) {
            PredicateInValueList predIn = aValExpr.getInValueListLeft();
            if (predIn != null) {
                EList rightExprList = predIn.getValueExprList();
                Iterator listIter = rightExprList.iterator();
                while (listIter.hasNext() && aValExpr.getDataType() == null) {
                    QueryValueExpression inListMember = (QueryValueExpression)listIter.next();
                    ValueExpressionHelper.copyDataType(inListMember, varExpr);
                    resolved = true;
                }
            } else {
                predIn = aValExpr.getInValueListRight();
                if (predIn != null) {
                    leftExpr = predIn.getValueExpr();
                    ValueExpressionHelper.copyDataType(leftExpr, varExpr);
                    resolved = true;
                }
            }
        }
        if (!resolved) {
            PredicateLike predLikeMatching = aValExpr.getLikeMatching();
            if (predLikeMatching != null) {
                datatype = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                datatype.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
                aValExpr.setDataType((DataType)datatype);
                resolved = true;
            } else {
                PredicateLike predLikePattern = aValExpr.getLikePattern();
                if (predLikePattern != null) {
                    QueryValueExpression leftExpr3 = predLikePattern.getMatchingValueExpr();
                    ValueExpressionHelper.copyDataType(leftExpr3, varExpr);
                    resolved = true;
                }
            }
        }
        if (!resolved && (predNull = aValExpr.getPredicateNull()) != null) {
            datatype = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
            datatype.setPrimitiveType(PrimitiveType.INTEGER_LITERAL);
            aValExpr.setDataType((DataType)datatype);
            resolved = true;
        }
        if (!resolved) {
            ValuesRow valRow = aValExpr.getValuesRow();
            if (valRow != null) {
                EList valExprList = valRow.getExprList();
                int valExprIndex = valExprList.indexOf(aValExpr);
                QueryInsertStatement insertStmt = valRow.getInsertStatement();
                if (insertStmt != null) {
                    EList intoColList = insertStmt.getTargetColumnList();
                    if (intoColList != null && intoColList.size() > valExprIndex) {
                        ValueExpressionColumn intoCol = (ValueExpressionColumn)intoColList.get(valExprIndex);
                        ValueExpressionHelper.copyDataType(intoCol, varExpr);
                        resolved = true;
                    } else {
                        TableInDatabase intoTable = insertStmt.getTargetTable();
                        if (intoTable != null && intoTable.getColumnList() != null && intoTable.getColumnList().size() > valExprIndex) {
                            intoColList = intoTable.getColumnList();
                            ValueExpressionColumn intoCol = (ValueExpressionColumn)intoColList.get(valExprIndex);
                            ValueExpressionHelper.copyDataType(intoCol, varExpr);
                            resolved = true;
                        }
                    }
                } else {
                    TableInDatabase tableInDB;
                    TableExpression tableExpr;
                    MergeTargetTable mergeTargetTbl;
                    QueryMergeStatement mergeStmt;
                    MergeSourceTable mergeSourceTable;
                    QueryValues queryValues = valRow.getQueryValues();
                    if (queryValues != null && (mergeSourceTable = queryValues.getMergeSourceTable()) != null && (mergeStmt = mergeSourceTable.getMergeStatement()) != null && (mergeTargetTbl = mergeStmt.getTargetTable()) != null && (tableExpr = mergeTargetTbl.getTableExpr()) instanceof TableInDatabase && (tableInDB = (TableInDatabase)tableExpr).getColumnList() != null && tableInDB.getColumnList().size() > valExprIndex) {
                        EList colList = tableInDB.getColumnList();
                        ValueExpressionColumn col = (ValueExpressionColumn)colList.get(valExprIndex);
                        ValueExpressionHelper.copyDataType(col, varExpr);
                        resolved = true;
                    }
                }
            } else {
                UpdateSourceExprList updateSrcExprList = aValExpr.getUpdateSourceExprList();
                if (updateSrcExprList != null) {
                    UpdateAssignmentExpression assignExpr = updateSrcExprList.getUpdateAssignmentExpr();
                    EList valExprList = updateSrcExprList.getValueExprList();
                    int valExprIndex = valExprList.indexOf((Object)aValExpr);
                    EList assignColList = assignExpr.getTargetColumnList();
                    ValueExpressionColumn assignCol = (ValueExpressionColumn)assignColList.get(valExprIndex);
                    ValueExpressionHelper.copyDataType(assignCol, varExpr);
                    resolved = true;
                }
            }
        }
        if (!resolved && (valCast = aValExpr.getValueExprCast()) != null) {
            ValueExpressionHelper.copyDataType(valCast, varExpr);
            resolved = true;
        }
        if (!(resolved || aValExpr.getValueExprCombinedLeft() == null && aValExpr.getValueExprCombinedRight() == null)) {
            ValueExpressionCombined valExprCombined = null;
            QueryValueExpression otherExpr = null;
            boolean isLeft = true;
            if (aValExpr.getValueExprCombinedLeft() != null) {
                valExprCombined = aValExpr.getValueExprCombinedLeft();
                otherExpr = valExprCombined.getRightValueExpr();
            } else if (aValExpr.getValueExprCombinedRight() != null) {
                valExprCombined = aValExpr.getValueExprCombinedRight();
                otherExpr = valExprCombined.getLeftValueExpr();
                isLeft = false;
            }
            if (valExprCombined != null && otherExpr != null && valExprCombined.getCombinedOperator().getValue() == 4) {
                if (isLeft) {
                    ValueExpressionHelper.resolveValueExpressionConcatDatatype(valExprCombined, aValExpr, otherExpr);
                } else {
                    ValueExpressionHelper.resolveValueExpressionConcatDatatype(valExprCombined, otherExpr, aValExpr);
                }
                resolved = true;
            }
        }
    }

    protected static HashMap createFunctionReturnTypeMap() {
        HashMap<String, Object> functionReturnTypes = new HashMap<String, Object>();
        ApproximateNumericDataType doubleType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
        doubleType.setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
        ApproximateNumericDataType realType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
        realType.setPrimitiveType(PrimitiveType.REAL_LITERAL);
        IntegerDataType bigIntType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
        bigIntType.setPrimitiveType(PrimitiveType.BIGINT_LITERAL);
        IntegerDataType intType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
        intType.setPrimitiveType(PrimitiveType.INTEGER_LITERAL);
        IntegerDataType smallIntType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
        smallIntType.setPrimitiveType(PrimitiveType.SMALLINT_LITERAL);
        BinaryStringDataType blobType = SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType();
        blobType.setPrimitiveType(PrimitiveType.BINARY_LARGE_OBJECT_LITERAL);
        CharacterStringDataType clobType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        clobType.setPrimitiveType(PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL);
        DateDataType dateType = SQLDataTypesFactory.eINSTANCE.createDateDataType();
        dateType.setPrimitiveType(PrimitiveType.DATE_LITERAL);
        TimeDataType timeType = SQLDataTypesFactory.eINSTANCE.createTimeDataType();
        timeType.setPrimitiveType(PrimitiveType.TIME_LITERAL);
        TimeDataType timeStampType = SQLDataTypesFactory.eINSTANCE.createTimeDataType();
        timeStampType.setPrimitiveType(PrimitiveType.TIMESTAMP_LITERAL);
        functionReturnTypes.put("CORRELATION", doubleType);
        functionReturnTypes.put("CORR", doubleType);
        functionReturnTypes.put("COUNT", bigIntType);
        functionReturnTypes.put("COUNT_BIG", bigIntType);
        functionReturnTypes.put("COVARIANCE", doubleType);
        functionReturnTypes.put("COVAR", doubleType);
        functionReturnTypes.put("MAX", null);
        functionReturnTypes.put("MIN", null);
        functionReturnTypes.put("STDDEV", doubleType);
        functionReturnTypes.put("VARIANCE", doubleType);
        functionReturnTypes.put("VAR", doubleType);
        functionReturnTypes.put("ABS", null);
        functionReturnTypes.put("ABSVAL", null);
        functionReturnTypes.put("ACOS", doubleType);
        CharacterStringDataType varchar128 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar128.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar128.setLength(128);
        functionReturnTypes.put("APPLICATION_ID", varchar128);
        functionReturnTypes.put("ASCII", intType);
        functionReturnTypes.put("ASIN", doubleType);
        functionReturnTypes.put("ATAN", doubleType);
        functionReturnTypes.put("ATAN2", doubleType);
        functionReturnTypes.put("BIGINT", bigIntType);
        functionReturnTypes.put("BLOB", blobType);
        CharacterStringDataType char1 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        char1.setPrimitiveType(PrimitiveType.CHARACTER_LITERAL);
        char1.setLength(1);
        functionReturnTypes.put("CHR", char1);
        functionReturnTypes.put("CLOB", clobType);
        functionReturnTypes.put("COALESCE", char1);
        functionReturnTypes.put("COS", doubleType);
        functionReturnTypes.put("COSH", doubleType);
        functionReturnTypes.put("COT", doubleType);
        functionReturnTypes.put("DATE", dateType);
        functionReturnTypes.put("DAY", bigIntType);
        CharacterStringDataType varchar100 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar100.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar100.setLength(100);
        functionReturnTypes.put("DAYNAME", varchar100);
        functionReturnTypes.put("DAYOFWEEK", intType);
        functionReturnTypes.put("DAYOFWEEK_ISO", intType);
        functionReturnTypes.put("DAYOFYEAR", intType);
        functionReturnTypes.put("DAYS", intType);
        functionReturnTypes.put("DBCLOB", clobType);
        functionReturnTypes.put("DBPARTITIONNUM", intType);
        functionReturnTypes.put("DEGREES", doubleType);
        functionReturnTypes.put("DIFFERENCE", intType);
        CharacterStringDataType varchar254 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar254.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar254.setLength(254);
        CharacterStringDataType varchar4 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar4.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar4.setLength(4);
        CharacterStringDataType varchar200 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar200.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar200.setLength(200);
        CharacterStringDataType varchar20 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar20.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar20.setLength(20);
        functionReturnTypes.put("DLCOMMENT", varchar254);
        functionReturnTypes.put("DLLINKTYPE", varchar4);
        functionReturnTypes.put("DLNEWCOPY", varchar200);
        functionReturnTypes.put("DLPREVIOUSCOPY", varchar200);
        functionReturnTypes.put("DLURLCOMPLETE", varchar4);
        functionReturnTypes.put("DLURLCOMPLETEONLY", varchar4);
        functionReturnTypes.put("DLURLCOMPLETEWRITE", varchar254);
        functionReturnTypes.put("DLURLPATH", varchar4);
        functionReturnTypes.put("DLURLPATHONLY", varchar4);
        functionReturnTypes.put("DLURLPATHWRITE", varchar4);
        functionReturnTypes.put("DLURLSCHEME", varchar20);
        functionReturnTypes.put("DLURLSERVER", varchar254);
        functionReturnTypes.put("DOUBLE", doubleType);
        functionReturnTypes.put("EVENT_MON_STATE", intType);
        functionReturnTypes.put("EXP", doubleType);
        functionReturnTypes.put("FLOAT", doubleType);
        CharacterStringDataType varchar32 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar32.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar32.setLength(32);
        functionReturnTypes.put("GETHINT", varchar32);
        CharacterStringDataType varchar1024 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar1024.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar1024.setLength(1024);
        functionReturnTypes.put("GET_ROUTINE_OPTS", varchar1024);
        functionReturnTypes.put("HASHEDVALUE", intType);
        functionReturnTypes.put("HOUR", bigIntType);
        FixedPrecisionDataType decimalType_31_0 = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
        decimalType_31_0.setPrimitiveType(PrimitiveType.DECIMAL_LITERAL);
        decimalType_31_0.setPrecision(31);
        decimalType_31_0.setScale(0);
        functionReturnTypes.put("IDENTITY_VAL_LOCAL", varchar1024);
        functionReturnTypes.put("INTEGER", bigIntType);
        functionReturnTypes.put("INT", bigIntType);
        functionReturnTypes.put("JULIAN_DAY", intType);
        functionReturnTypes.put("LCASE", null);
        functionReturnTypes.put("LOWER", null);
        functionReturnTypes.put("LENGTH", bigIntType);
        functionReturnTypes.put("LN", doubleType);
        functionReturnTypes.put("LOCATE", intType);
        functionReturnTypes.put("LOG", doubleType);
        functionReturnTypes.put("LOG10", doubleType);
        functionReturnTypes.put("LTRIM", null);
        functionReturnTypes.put("MICROSECOND", bigIntType);
        functionReturnTypes.put("MIDNIGHT_SECONDS", intType);
        functionReturnTypes.put("MINUTE", bigIntType);
        functionReturnTypes.put("MONTH", bigIntType);
        functionReturnTypes.put("MONTHNAME", varchar100);
        functionReturnTypes.put("NULLIF", null);
        functionReturnTypes.put("POSSTR", bigIntType);
        functionReturnTypes.put("QUARTER", intType);
        functionReturnTypes.put("RADIANS", doubleType);
        functionReturnTypes.put("RAND", doubleType);
        functionReturnTypes.put("REAL", realType);
        functionReturnTypes.put("RTRIM", null);
        functionReturnTypes.put("SECOND", bigIntType);
        functionReturnTypes.put("SIN", doubleType);
        functionReturnTypes.put("SINH", doubleType);
        functionReturnTypes.put("SMALLINT", smallIntType);
        CharacterStringDataType char4 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        char4.setPrimitiveType(PrimitiveType.CHARACTER_LITERAL);
        char4.setLength(4);
        functionReturnTypes.put("SOUNDEX", char4);
        CharacterStringDataType varchar4000 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar4000.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar4000.setLength(4000);
        functionReturnTypes.put("SPACE", varchar4000);
        functionReturnTypes.put("SQRT", doubleType);
        functionReturnTypes.put("SOUNDEX", char4);
        functionReturnTypes.put("TABLE_NAME", varchar128);
        functionReturnTypes.put("TABLE_SCHEMA", varchar128);
        functionReturnTypes.put("TAN", doubleType);
        functionReturnTypes.put("TANH", doubleType);
        functionReturnTypes.put("TIME", timeType);
        functionReturnTypes.put("TIMESTAMP", timeStampType);
        functionReturnTypes.put("TIMESTAMP_FORMAT", timeStampType);
        functionReturnTypes.put("TIMESTAMP_ISO", timeStampType);
        functionReturnTypes.put("TIMESTAMPDIFF", intType);
        functionReturnTypes.put("TO_DATE", timeStampType);
        functionReturnTypes.put("TRUNCATE", null);
        functionReturnTypes.put("TRUNC", null);
        functionReturnTypes.put("TYPE_ID", intType);
        CharacterStringDataType varchar18 = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        varchar18.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
        varchar18.setLength(18);
        functionReturnTypes.put("TYPE_NAME", varchar18);
        functionReturnTypes.put("TYPE_SCHEMA", varchar128);
        functionReturnTypes.put("UCASE", null);
        functionReturnTypes.put("UPPER", varchar18);
        functionReturnTypes.put("VALUE", null);
        functionReturnTypes.put("WEEK", intType);
        functionReturnTypes.put("WEEK_ISO", intType);
        functionReturnTypes.put("YEAR", bigIntType);
        return functionReturnTypes;
    }

    private static DataType concatCharStringDataTypePromotion(DataType left, DataType right) {
        CharacterStringDataType retType = null;
        if (left != null && right != null) {
            PrimitiveType leftPrim = ((PredefinedDataType)left).getPrimitiveType();
            PrimitiveType rightPrim = ((PredefinedDataType)right).getPrimitiveType();
            if (left instanceof CharacterStringDataType && right instanceof CharacterStringDataType) {
                retType = ValueExpressionHelper.copyDataType(left);
                int len = ((CharacterStringDataType)left).getLength();
                retType.setLength(len += ((CharacterStringDataType)right).getLength());
                if (leftPrim == PrimitiveType.CHARACTER_LITERAL && rightPrim == PrimitiveType.CHARACTER_LITERAL && len < 255) {
                    retType.setPrimitiveType(PrimitiveType.CHARACTER_LITERAL);
                } else {
                    retType.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
                }
            }
        }
        if (retType == null) {
            retType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
            retType.setPrimitiveType(PrimitiveType.CHARACTER_VARYING_LITERAL);
            retType.setLength(100);
        }
        return retType;
    }

    private static DataType doNumericDataTypePromotion(DataType left, DataType right) {
        DataType retType = null;
        if (left != null && right != null) {
            PrimitiveType leftPrim = ((PredefinedDataType)left).getPrimitiveType();
            PrimitiveType rightPrim = ((PredefinedDataType)right).getPrimitiveType();
            if (leftPrim == PrimitiveType.SMALLINT_LITERAL) {
                if (rightPrim == PrimitiveType.SMALLINT_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                }
            } else if (leftPrim == PrimitiveType.INTEGER_LITERAL) {
                if (rightPrim == PrimitiveType.SMALLINT_LITERAL || rightPrim == PrimitiveType.INTEGER_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                }
            } else if (leftPrim == PrimitiveType.BIGINT_LITERAL) {
                if (rightPrim == PrimitiveType.SMALLINT_LITERAL || rightPrim == PrimitiveType.INTEGER_LITERAL || rightPrim == PrimitiveType.BIGINT_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                }
            } else if (leftPrim == PrimitiveType.DECIMAL_LITERAL) {
                if (rightPrim == PrimitiveType.SMALLINT_LITERAL) {
                    int scale;
                    retType = ValueExpressionHelper.copyDataType(left);
                    int precision = ((FixedPrecisionDataType)left).getPrecision();
                    precision = scale + (precision - (scale = ((FixedPrecisionDataType)left).getScale()) > 5 ? precision - scale : 5);
                    precision = precision > 31 ? 31 : precision;
                    ((FixedPrecisionDataType)retType).setPrecision(precision);
                } else if (rightPrim == PrimitiveType.INTEGER_LITERAL) {
                    int scale;
                    retType = ValueExpressionHelper.copyDataType(left);
                    int precision = ((FixedPrecisionDataType)left).getPrecision();
                    precision = scale + (precision - (scale = ((FixedPrecisionDataType)left).getScale()) > 11 ? precision - scale : 11);
                    precision = precision > 31 ? 31 : precision;
                    ((FixedPrecisionDataType)retType).setPrecision(precision);
                } else if (rightPrim == PrimitiveType.BIGINT_LITERAL) {
                    int scale;
                    retType = ValueExpressionHelper.copyDataType(left);
                    int precision = ((FixedPrecisionDataType)left).getPrecision();
                    precision = scale + (precision - (scale = ((FixedPrecisionDataType)left).getScale()) > 19 ? precision - scale : 19);
                    precision = precision > 31 ? 31 : precision;
                    ((FixedPrecisionDataType)retType).setPrecision(precision);
                } else if (rightPrim == PrimitiveType.DECIMAL_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                    int pleft = ((FixedPrecisionDataType)left).getPrecision();
                    int sleft = ((FixedPrecisionDataType)left).getScale();
                    int pright = ((FixedPrecisionDataType)right).getPrecision();
                    int sright = ((FixedPrecisionDataType)right).getScale();
                    int s = sleft > sright ? sleft : sright;
                    int p = s + (pleft - sleft > pright - sright ? pleft - sleft : pright - sright);
                    ((FixedPrecisionDataType)retType).setPrecision(p);
                    ((FixedPrecisionDataType)retType).setScale(s);
                }
            } else if (leftPrim == PrimitiveType.REAL_LITERAL) {
                if (rightPrim == PrimitiveType.REAL_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                } else if (rightPrim == PrimitiveType.SMALLINT_LITERAL || rightPrim == PrimitiveType.INTEGER_LITERAL || rightPrim == PrimitiveType.BIGINT_LITERAL || rightPrim == PrimitiveType.DECIMAL_LITERAL) {
                    retType = ValueExpressionHelper.copyDataType(left);
                    ((ApproximateNumericDataType)retType).setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
                }
            } else if (leftPrim == PrimitiveType.DOUBLE_PRECISION_LITERAL) {
                retType = ValueExpressionHelper.copyDataType(left);
            }
        }
        return retType;
    }

    private static DataType getFuncReturnType(String funcName) {
        DataType dt = (DataType)FunctionReturnType.get(funcName);
        if (dt != null) {
            return (DataType)EcoreUtil.copy((EObject)dt);
        }
        return null;
    }

    private static Object[][] getParameterFormats(String funcName) {
        throw new UnsupportedOperationException(String.valueOf(ValueExpressionHelper.class.getName()) + "#getParameterFormats(String funcName) not implemented!");
    }

    private static PredefinedDataType getPredefinedDataTypeForSimpleValue(String value, ValueExpressionUnaryOperator op) {
        CharacterStringDataType datatype = null;
        SQLDataTypesFactory sqlDataTypesFactory = SQLDataTypesFactory.eINSTANCE;
        if (value != null && value.length() > 0) {
            if (value.startsWith("'") && value.endsWith("'")) {
                Integer len = value.length() - 2;
                len.toString();
                datatype = sqlDataTypesFactory.createCharacterStringDataType();
                datatype.setPrimitiveType(PrimitiveType.CHARACTER_LITERAL);
                datatype.setLength(len.intValue());
            } else if ((value.startsWith("G'") || value.startsWith("g'") || value.startsWith("N'") || value.startsWith("n'")) && value.endsWith("'")) {
                Integer len = (value.length() - 3) / 2;
                len.toString();
                datatype = sqlDataTypesFactory.createCharacterStringDataType();
                datatype.setPrimitiveType(PrimitiveType.NATIONAL_CHARACTER_LITERAL);
            } else if ((value.startsWith("X'") || value.startsWith("x'")) && value.endsWith("'")) {
                datatype = sqlDataTypesFactory.createBinaryStringDataType();
                datatype.setPrimitiveType(PrimitiveType.BINARY_LARGE_OBJECT_LITERAL);
            } else {
                String ucValue = value.toUpperCase();
                if (((Object)((Object)ValueExpressionUnaryOperator.MINUS_LITERAL)).equals((Object)op)) {
                    ucValue = "-" + ucValue;
                }
                int eIndex = ucValue.indexOf(69);
                int dIndex = ucValue.lastIndexOf(46);
                if (eIndex == -1 && dIndex == -1 && datatype == null) {
                    try {
                        Integer intObj = Integer.valueOf(ucValue);
                        int intValue = intObj;
                        int precision = 10;
                        PrimitiveType primitiveType = PrimitiveType.INTEGER_LITERAL;
                        if (intValue > -32769 && intValue < 32768) {
                            precision = 5;
                            primitiveType = PrimitiveType.SMALLINT_LITERAL;
                        }
                        datatype = sqlDataTypesFactory.createIntegerDataType();
                        datatype.setPrimitiveType(primitiveType);
                        ((NumericalDataType)datatype).setPrecision(precision);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            Long.valueOf(ucValue);
                            int precision = 19;
                            datatype = sqlDataTypesFactory.createIntegerDataType();
                            datatype.setPrimitiveType(PrimitiveType.BIGINT_LITERAL);
                            ((NumericalDataType)datatype).setPrecision(precision);
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                }
                if (eIndex == -1 && datatype == null) {
                    try {
                        BigDecimal decimal = new BigDecimal(ucValue);
                        BigInteger bigIntVal = decimal.unscaledValue();
                        bigIntVal = bigIntVal.abs();
                        String bigIntValStr = bigIntVal.toString();
                        int precision = bigIntValStr.length();
                        int scale = decimal.scale();
                        datatype = sqlDataTypesFactory.createFixedPrecisionDataType();
                        datatype.setPrimitiveType(PrimitiveType.DECIMAL_LITERAL);
                        ((FixedPrecisionDataType)datatype).setPrecision(precision);
                        ((FixedPrecisionDataType)datatype).setScale(scale);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (datatype == null) {
                    try {
                        Double doubleObject = Double.valueOf(ucValue);
                        double doubleValue = doubleObject;
                        float floatNegMin = Float.parseFloat("-3.402E+38");
                        float floatNegMax = Float.parseFloat("-1.175E-37");
                        float floatPosMin = Float.parseFloat("1.175E-37");
                        float floatPosMax = Float.parseFloat("3.402E+38");
                        int valPrecision = eIndex;
                        if (ucValue.startsWith("-") || ucValue.startsWith("+")) {
                            --valPrecision;
                        }
                        if (ucValue.lastIndexOf(46, eIndex) != -1) {
                            --valPrecision;
                        }
                        datatype = sqlDataTypesFactory.createApproximateNumericDataType();
                        if (doubleValue < (double)floatNegMin || doubleValue > (double)floatPosMax || doubleValue > (double)floatNegMax && doubleValue < (double)floatPosMin) {
                            datatype.setPrimitiveType(PrimitiveType.DOUBLE_PRECISION_LITERAL);
                        } else {
                            datatype.setPrimitiveType(PrimitiveType.REAL_LITERAL);
                        }
                        ((ApproximateNumericDataType)datatype).setPrecision(valPrecision);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        return datatype;
    }

    private static int getReturnDatatypeLength(String funcName, String returnDatatypeName, String param1DatatypeName, int param1DatatypeLen) {
        throw new UnsupportedOperationException(String.valueOf(ValueExpressionHelper.class.getName()) + "#getReturnDatatypeLength(String funcName, String returnDatatypeName, String param1DatatypeName, int param1DatatypeLen) not implemented!");
    }
}

